/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.entity.drug.influence;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.psychedelicraft.entity.drug.DrugProperties;
import ivorius.psychedelicraft.entity.drug.DrugType;
import ivorius.psychedelicraft.entity.drug.influence.DrugInfluence;
import ivorius.psychedelicraft.util.compat.PacketCodec;
import ivorius.psychedelicraft.util.compat.PacketCodecs;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2540;
import org.joml.Vector3f;

public class DrugInfluenceInstance {
    public static final Codec<DrugInfluenceInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DrugType.REGISTRY.method_39673().fieldOf("drugType").forGetter(i -> i.drugType), (App)Codec.INT.fieldOf("delay").forGetter(i -> i.delay), (App)Codec.DOUBLE.fieldOf("influenceSpeed").forGetter(i -> i.factor), (App)Codec.DOUBLE.fieldOf("influenceSpeedPlus").forGetter(i -> i.base), (App)Codec.DOUBLE.fieldOf("maxInfluence").forGetter(i -> i.targetRemaining), (App)DrugInfluence.COLOR_CODEC.optionalFieldOf("color").forGetter(i -> i.color)).apply((Applicative)instance, DrugInfluenceInstance::new));
    public static final Codec<List<DrugInfluenceInstance>> LIST_CODEC = CODEC.listOf();
    public static final PacketCodec<class_2540, DrugInfluenceInstance> PACKET_CODEC = PacketCodec.tuple(PacketCodecs.registryValue(DrugType.REGISTRY.method_30517()), i -> i.drugType, PacketCodecs.INTEGER, i -> i.delay, PacketCodecs.DOUBLE, i -> i.factor, PacketCodecs.DOUBLE, i -> i.base, PacketCodecs.DOUBLE, i -> i.targetRemaining, DrugInfluence.COLOR_PACKET_CODEC, i -> i.color, DrugInfluenceInstance::new);
    public final DrugType<?> drugType;
    public final double factor;
    public final double base;
    public final Optional<Vector3f> color;
    private int delay;
    private double targetRemaining;

    public DrugInfluenceInstance(DrugInfluence influence) {
        this(influence.drugType(), influence.delay(), influence.factor(), influence.base(), influence.target(), influence.color());
    }

    public DrugInfluenceInstance(DrugType<?> drugType, int delay, double factor, double base, double target, Optional<Vector3f> color) {
        this.drugType = drugType;
        this.delay = delay;
        this.factor = factor;
        this.base = base;
        this.targetRemaining = target;
        this.color = color;
    }

    public boolean isOf(DrugType<?> type) {
        return this.drugType == type;
    }

    public boolean update(DrugProperties properties) {
        if (--this.delay > 0) {
            return false;
        }
        if (this.targetRemaining > 0.0) {
            double addition = Math.min(this.targetRemaining, this.base + this.targetRemaining * this.factor);
            properties.addToDrug(this.drugType, addition, this);
            this.targetRemaining -= addition;
        }
        return this.targetRemaining <= 0.0;
    }
}

