/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.fluid;

import ivorius.psychedelicraft.Psychedelicraft;
import ivorius.psychedelicraft.entity.drug.DrugType;
import ivorius.psychedelicraft.entity.drug.influence.DrugInfluence;
import ivorius.psychedelicraft.fluid.AgaveFluid;
import ivorius.psychedelicraft.fluid.AlcoholicFluid;
import ivorius.psychedelicraft.fluid.ChemicalExtractFluid;
import ivorius.psychedelicraft.fluid.CocaTeaFluid;
import ivorius.psychedelicraft.fluid.CoffeeFluid;
import ivorius.psychedelicraft.fluid.DrugFluid;
import ivorius.psychedelicraft.fluid.EthanolFluid;
import ivorius.psychedelicraft.fluid.PetroliumFluid;
import ivorius.psychedelicraft.fluid.SimpleFluid;
import ivorius.psychedelicraft.fluid.SlurryFluid;
import ivorius.psychedelicraft.fluid.VanillaFluid;
import ivorius.psychedelicraft.fluid.alcohol.DrinkType;
import ivorius.psychedelicraft.fluid.alcohol.DrinkTypes;
import ivorius.psychedelicraft.fluid.alcohol.FluidAppearance;
import ivorius.psychedelicraft.fluid.alcohol.StatePredicate;
import ivorius.psychedelicraft.fluid.alcohol.TickRate;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.minecraft.class_3612;

public interface PSFluids {
    public static final SimpleFluid EMPTY = VanillaFluid.register(SimpleFluid.EMPTY_KEY, class_3612.field_15906, true);
    public static final AlcoholicFluid WHEAT_HOP = new AlcoholicFluid(Psychedelicraft.id("wheat_hop"), (AlcoholicFluid.Settings)new AlcoholicFluid.Settings().alcohol(0.25, 1.7, 0.1).tickRate(TickRate.ofMinutes(30, 60, 100, 30)).variants(DrinkTypes.builder("bitter").vinegar(DrinkType.VINEGAR.withName("beer_vinegar").withVariation("bitter")).firstFerment(DrinkType.HALF_WASH.withVariation("bitter")).secondFerment(DrinkType.BEER.withVariation("green").withAppearance(FluidAppearance.RUM_MATURE)).matured(DrinkType.BEER).distilled(DrinkType.BEER.withAppearance(FluidAppearance.CLEAR))).color(-1426150904));
    public static final AlcoholicFluid WHEAT = new AlcoholicFluid(Psychedelicraft.id("wheat"), (AlcoholicFluid.Settings)new AlcoholicFluid.Settings().alcohol(0.25, 1.7, 0.1).variants(DrinkTypes.builder(DrinkType.WORT).vinegar(DrinkType.VINEGAR.withName("beer_vinegar")).firstFerment(DrinkType.HALF_WASH).secondFerment(DrinkType.WASH).matured(DrinkType.BRANDY).distilled(DrinkType.VODKA).add(DrinkType.WHISKEY.withName("wheat_whiskey").withVariation("well_aged"), StatePredicate.builder().minFerments(1).minMaturity(8).minDistills(1)).matureDistilled(DrinkType.WHISKEY.withName("wheat_whiskey"))).color(-1426150904));
    public static final AlcoholicFluid POTATO = new AlcoholicFluid(Psychedelicraft.id("potato"), (AlcoholicFluid.Settings)((SimpleFluid.Settings)new AlcoholicFluid.Settings().alcohol(0.45, 1.9, 0.15).variants(DrinkTypes.builder(DrinkType.WORT).vinegar(DrinkType.VINEGAR).firstFerment(DrinkType.HALF_WASH).secondFerment(DrinkType.BEER).matured(DrinkType.BEER.withAppearance(FluidAppearance.RUM_MATURE)).distilled(DrinkType.VODKA).matureDistilled(DrinkType.POTEEN.withAppearance(FluidAppearance.RUM_SEMI_MATURE))).color(-1426150904)).viscocity(2));
    public static final AlcoholicFluid TOMATO = new AlcoholicFluid(Psychedelicraft.id("tomato"), (AlcoholicFluid.Settings)((SimpleFluid.Settings)new AlcoholicFluid.Settings().alcohol(0.15, 0.9, 0.05).distilledColor(-1426128896).matureColor(-1426115840).variants(DrinkTypes.builder(DrinkType.JUICE.withAppearance(FluidAppearance.TOMATO_JUICE)).vinegar(DrinkType.KETCHUP.withExtraDrug(new DrugInfluence(DrugType.SUGAR, 20, 0.003, 0.002, 0.3))).firstFerment(DrinkType.HALF_WASH).secondFerment(DrinkType.BEER).add(DrinkType.WHISKEY.withAppearance(FluidAppearance.RUM_SEMI_MATURE), StatePredicate.builder().minFerments(1).minMaturity(6).minDistills(2)).add(DrinkType.MEAD, StatePredicate.builder().minFerments(1).minMaturity(5).distills(1)).matured(DrinkType.BEER.withVariation("aged")).distilled(DrinkType.VODKA)).color(-1426085368)).viscocity(1));
    public static final AlcoholicFluid RED_GRAPES = new AlcoholicFluid(Psychedelicraft.id("red_grapes"), (AlcoholicFluid.Settings)new AlcoholicFluid.Settings().alcohol(0.55, 1.7, 0.2).distilledColor(-1723922398).matureColor(-297859038).variants(DrinkTypes.builder(DrinkType.JUICE.withAppearance(FluidAppearance.WINE)).vinegar(DrinkType.VINEGAR).add(DrinkType.VINEGAR.withVariation("bitter"), StatePredicate.builder().minMaturity(16)).firstFerment(DrinkType.HALF_WASH.withVariation("wine").withAppearance(FluidAppearance.WINE)).secondFerment(DrinkType.WASH.withVariation("wine").withAppearance(FluidAppearance.WINE)).add(DrinkType.WINE.withVariation("well_aged"), StatePredicate.builder().ferments(1).minMaturity(14)).add(DrinkType.WINE.withVariation("aged"), StatePredicate.builder().ferments(1).minMaturity(8)).add(DrinkType.WINE.withVariation("slightly_aged"), StatePredicate.builder().ferments(1).minMaturity(4)).add(DrinkType.WINE.withVariation("young"), StatePredicate.FERMENTED_MATURED).distilled(DrinkType.BRANDY)).color(-1426150904));
    public static final AlcoholicFluid RICE = new AlcoholicFluid(Psychedelicraft.id("rice"), (AlcoholicFluid.Settings)new AlcoholicFluid.Settings().alcohol(0.25, 1.7, 0.1).matureColor(-1999192944).variants(DrinkTypes.builder(FluidAppearance.RICE_WINE).vinegar(DrinkType.VINEGAR).firstFerment(DrinkType.HALF_WASH.withAppearance(FluidAppearance.CLEAR)).secondFerment(DrinkType.WINE.withVariation("young").withAppearance(FluidAppearance.CLEAR)).matured(DrinkType.WINE.withAppearance(FluidAppearance.CLEAR)).distilled(DrinkType.BRANDY.withAppearance(FluidAppearance.CLEAR))).color(-288701262));
    public static final AlcoholicFluid JUNIPER = new AlcoholicFluid(Psychedelicraft.id("juniper"), (AlcoholicFluid.Settings)new AlcoholicFluid.Settings().alcohol(0.4, 1.7, 0.1).variants(DrinkTypes.builder(FluidAppearance.SLURRY).vinegar(DrinkType.VINEGAR).firstFerment(DrinkType.HALF_WASH).secondFerment(DrinkType.WASH.withVariation("young")).matured(DrinkType.WASH).distilled(DrinkType.GIN)).color(-865055199));
    public static final AlcoholicFluid HONEY = new AlcoholicFluid(Psychedelicraft.id("honey"), (AlcoholicFluid.Settings)((SimpleFluid.Settings)new AlcoholicFluid.Settings().alcohol(0.35, 1.7, 0.1).distilledColor(-1712738757).matureColor(-1429104563).variants(DrinkTypes.builder(FluidAppearance.MEAD).vinegar(DrinkType.VINEGAR.withAppearance(FluidAppearance.MEAD)).firstFerment(DrinkType.HALF_WASH.withAppearance(FluidAppearance.MEAD)).secondFerment(DrinkType.MEAD.withVariation("young")).matured(DrinkType.MEAD).distilled(DrinkType.BRANDY.withAppearance(FluidAppearance.MEAD))).color(-1142313413)).viscocity(5));
    public static final AlcoholicFluid SUGAR_CANE = new AlcoholicFluid(Psychedelicraft.id("sugar_cane"), (AlcoholicFluid.Settings)new AlcoholicFluid.Settings().alcohol(0.35, 1.7, 0.1).variants(DrinkTypes.builder(FluidAppearance.CLEAR).vinegar(DrinkType.VINEGAR).firstFerment(DrinkType.HALF_WASH).secondFerment(DrinkType.BASI.withVariation("young")).matured(DrinkType.BASI).distilled(DrinkType.RUM.withVariation("young")).matureDistilled(DrinkType.RUM)).color(-1426150904));
    public static final AlcoholicFluid CORN = new AlcoholicFluid(Psychedelicraft.id("corn"), (AlcoholicFluid.Settings)new AlcoholicFluid.Settings().alcohol(0.25, 1.7, 0.1).variants(DrinkTypes.builder(FluidAppearance.BEER).vinegar(DrinkType.VINEGAR).firstFerment(DrinkType.HALF_WASH).secondFerment(DrinkType.BEER.withVariation("green")).matured(DrinkType.BEER).distilled(DrinkType.VODKA).matureDistilled(DrinkType.WHISKEY)).color(-1426150904));
    public static final AlcoholicFluid APPLE = new AlcoholicFluid(Psychedelicraft.id("apple"), (AlcoholicFluid.Settings)new AlcoholicFluid.Settings().alcohol(0.35, 1.7, 0.1).distilledColor(1726857531).matureColor(-1997684421).variants(DrinkTypes.builder(DrinkType.CIDER.withVariation("sweet")).vinegar(DrinkType.VINEGAR).firstFerment(DrinkType.CIDER.withVariation("half_sweet")).secondFerment(DrinkType.CIDER.withVariation("hard")).matured(DrinkType.CIDER).distilled(DrinkType.BRANDY.withAppearance(FluidAppearance.CIDER))).color(-1712471749));
    public static final AlcoholicFluid PINEAPPLE = new AlcoholicFluid(Psychedelicraft.id("pineapple"), (AlcoholicFluid.Settings)((SimpleFluid.Settings)new AlcoholicFluid.Settings().alcohol(0.35, 1.7, 0.1).distilledColor(1726857531).matureColor(-1997684421).variants(DrinkTypes.builder(DrinkType.JUICE.withAppearance(FluidAppearance.CIDER)).vinegar(DrinkType.VINEGAR).firstFerment(DrinkType.HALF_WASH.withAppearance(FluidAppearance.CIDER)).secondFerment(DrinkType.WINE.withVariation("young").withAppearance(FluidAppearance.CIDER)).matured(DrinkType.WINE.withAppearance(FluidAppearance.CIDER)).distilled(DrinkType.BRANDY.withAppearance(FluidAppearance.CIDER))).color(-1712471749)).viscocity(2));
    public static final AlcoholicFluid BANANA = new AlcoholicFluid(Psychedelicraft.id("banana"), (AlcoholicFluid.Settings)((SimpleFluid.Settings)new AlcoholicFluid.Settings().alcohol(0.35, 1.7, 0.1).distilledColor(-1712738757).matureColor(-1429104563).variants(DrinkTypes.builder(DrinkType.JUICE.withAppearance(FluidAppearance.MEAD)).vinegar(DrinkType.VINEGAR).firstFerment(DrinkType.HALF_WASH.withAppearance(FluidAppearance.MEAD)).secondFerment(DrinkType.BEER.withAppearance(FluidAppearance.MEAD)).matured(DrinkType.BEER.withVariation("aged").withAppearance(FluidAppearance.MEAD)).distilled(DrinkType.BRANDY.withAppearance(FluidAppearance.MEAD))).color(-1142313413)).viscocity(3));
    public static final AlcoholicFluid MILK = new AlcoholicFluid(Psychedelicraft.id("milk"), (AlcoholicFluid.Settings)((SimpleFluid.Settings)new AlcoholicFluid.Settings().alcohol(0.35, 1.7, 0.1).distilledColor(2009777330).matureColor(-1999192944).variants(DrinkTypes.builder(DrinkType.ROOT.withAppearance(FluidAppearance.RICE_WINE)).vinegar(DrinkType.VINEGAR.withAppearance(FluidAppearance.RICE_WINE)).firstFerment(DrinkType.HALF_WASH.withAppearance(FluidAppearance.RICE_WINE)).secondFerment(DrinkType.BLAAND.withAppearance(FluidAppearance.RICE_WINE)).matured(DrinkType.BLAAND.withVariation("aged").withAppearance(FluidAppearance.RICE_WINE)).distilled(DrinkType.ARKHI.withAppearance(FluidAppearance.RICE_WINE))).color(-1996488705)).viscocity(2));
    public static final AlcoholicFluid AGAVE = new AgaveFluid(Psychedelicraft.id("agave"), (AlcoholicFluid.Settings)((SimpleFluid.Settings)new AlcoholicFluid.Settings().alcohol(0.15, 1.5, 0.05).distilledColor(2006707042).matureColor(2006707042).tickRate(TickRate.ofMinutes(30, 80, 40, 90)).variants(DrinkTypes.builder(DrinkType.JUICE).vinegar(DrinkType.VINEGAR).firstFerment(DrinkType.HALF_WASH).secondFerment(DrinkType.WASH).add(DrinkType.MEZCAL, StatePredicate.builder().minFerments(1).maturation(0).distills(1)).add(DrinkType.TEQUILA.withVariation("blanco"), StatePredicate.builder().minFerments(1).maturation(0).minDistills(2)).add(DrinkType.TEQUILA.withVariation("reposado"), StatePredicate.builder().minFerments(1).minMaturity(1).minDistills(2))).color(2006690658)).viscocity(1));
    public static final DrugFluid COFFEE = new CoffeeFluid(Psychedelicraft.id("coffee"), (DrugFluid.Settings)new DrugFluid.Settings().drinkable().appearance(FluidAppearance.COFFEE).color(-5800619));
    public static final DrugFluid COCA_TEA = new CocaTeaFluid(Psychedelicraft.id("coca_tea"), (DrugFluid.Settings)new DrugFluid.Settings().drinkable().appearance(FluidAppearance.TEA).influence(new DrugInfluence(DrugType.COCAINE, 60, 0.005, 0.002, 0.2)).color(1148746294));
    public static final DrugFluid CANNABIS_TEA = new DrugFluid(Psychedelicraft.id("cannabis_tea"), (DrugFluid.Settings)new DrugFluid.Settings().drinkable().appearance(FluidAppearance.TEA).influence(new DrugInfluence(DrugType.CANNABIS, 60, 0.005, 0.002, 0.25)).color(1148022588));
    public static final DrugFluid PEYOTE_JUICE = new DrugFluid(Psychedelicraft.id("peyote_juice"), (DrugFluid.Settings)((SimpleFluid.Settings)new DrugFluid.Settings().drinkable().influence(new DrugInfluence(DrugType.PEYOTE, 15, 0.005, 0.003, 2.0)).appearance(FluidAppearance.TEA).color(2006690658)).viscocity(2));
    public static final DrugFluid KAVA = new DrugFluid(Psychedelicraft.id("kava"), (DrugFluid.Settings)new DrugFluid.Settings().drinkable().influence(new DrugInfluence(DrugType.KAVA, 20, 0.005, 0.003, 2.0)).color(2006690658));
    public static final DrugFluid ETHANOL = new EthanolFluid(Psychedelicraft.id("ethanol"), PSFluids.chemicalSolution(DrugType.ALCOHOL));
    public static final SimpleFluid PETROLIUM = new PetroliumFluid(Psychedelicraft.id("petrolium"), (SimpleFluid.Settings)((SimpleFluid.Settings)((SimpleFluid.Settings)((SimpleFluid.Settings)new SimpleFluid.Settings().color(-16777216)).flammability(2.3f, 2.0f)).viscocity(2)).sprites(Psychedelicraft.id("block/fluid/petrolium_flow"), Psychedelicraft.id("block/fluid/petrolium_still")));
    public static final SimpleFluid GASOLINE = new SimpleFluid(Psychedelicraft.id("gasoline"), (SimpleFluid.Settings)((SimpleFluid.Settings)new SimpleFluid.Settings().color(-171)).flammability(1.3f, 5.0f));
    public static final DrugFluid ACID = new DrugFluid(Psychedelicraft.id("acid"), PSFluids.chemicalSolution(DrugType.LSD));
    public static final DrugFluid ATROPINE = new DrugFluid(Psychedelicraft.id("atropine"), PSFluids.chemicalSolution(DrugType.ATROPINE));
    public static final DrugFluid COCAINE = new DrugFluid(Psychedelicraft.id("cocaine"), PSFluids.chemicalSolution(DrugType.COCAINE));
    public static final DrugFluid CAFFEINE = new DrugFluid(Psychedelicraft.id("caffeine"), (DrugFluid.Settings)new DrugFluid.Settings().injectable().appearance(FluidAppearance.CLEAR).influence(new DrugInfluence(DrugType.CAFFEINE, 0, 0.005, 0.01, 85.0)).color(1726931667));
    public static final DrugFluid BATH_SALTS = new DrugFluid(Psychedelicraft.id("bath_salts"), (DrugFluid.Settings)new DrugFluid.Settings().injectable().appearance(FluidAppearance.CLEAR).influence(new DrugInfluence(DrugType.BATH_SALTS, 0, 0.005, 0.01, 50.0)).color(573830392));
    public static final DrugFluid MORPHINE = new DrugFluid(Psychedelicraft.id("morphine"), (DrugFluid.Settings)new DrugFluid.Settings().injectable().appearance(FluidAppearance.CLEAR).influence(new DrugInfluence(DrugType.MORPHINE, 0, 0.005, 0.01, 50.0)).color(573830392));
    public static final ChemicalExtractFluid MORNING_GLORY_EXTRACT = new ChemicalExtractFluid(Psychedelicraft.id("morning_glory_extract"), (DrugFluid.Settings)new DrugFluid.Settings().color(1726931667), DrugType.LSD, ACID);
    public static final ChemicalExtractFluid BELLADONA_EXTRACT = new ChemicalExtractFluid(Psychedelicraft.id("belladonna_extract"), (DrugFluid.Settings)new DrugFluid.Settings().color(1726931667), DrugType.ATROPINE, ATROPINE);
    public static final ChemicalExtractFluid JIMSONWEED_EXTRACT = new ChemicalExtractFluid(Psychedelicraft.id("jimsonweed_extract"), (DrugFluid.Settings)new DrugFluid.Settings().color(1726931667), DrugType.ATROPINE, ATROPINE);
    public static final SimpleFluid SLURRY = new SlurryFluid(Psychedelicraft.id("slurry"), (SimpleFluid.Settings)((SimpleFluid.Settings)new SimpleFluid.Settings().color(-865055199)).viscocity(4));

    public static DrugFluid.Settings chemicalSolution(DrugType<?> type) {
        return (DrugFluid.Settings)new DrugFluid.Settings().injectable().appearance(FluidAppearance.CLEAR).influence(new DrugInfluence(type, 0, 0.05, 0.01, 50.0)).color(1156117752);
    }

    public static void bootstrap() {
        VanillaFluid.bootstrap();
        FlammableBlockRegistry.getDefaultInstance().add(ATROPINE.getPhysical().getBlock(), 60, 100);
    }
}

