/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.item;

import ivorius.psychedelicraft.block.PlacedDrinksBlock;
import ivorius.psychedelicraft.fluid.ConsumableFluid;
import ivorius.psychedelicraft.item.component.FluidCapacity;
import ivorius.psychedelicraft.item.component.ItemFluids;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3414;
import org.jetbrains.annotations.Nullable;

public class DrinkableItem
extends class_1792 {
    public static final int FLUID_PER_INJECTION = 810;
    public static final int DEFAULT_MAX_USE_TIME = 32;
    private final int consumptionVolume;
    private final int consumptionTime;
    private final ConsumableFluid.ConsumptionType consumptionType;

    public DrinkableItem(class_1792.class_1793 settings, int consumptionVolume, int consumptionTime, ConsumableFluid.ConsumptionType consumptionType) {
        super(settings.method_7889(1));
        this.consumptionVolume = consumptionVolume;
        this.consumptionTime = consumptionTime;
        this.consumptionType = consumptionType;
    }

    public class_1799 getRecipeRemainder(class_1799 stack) {
        return ItemFluids.set(stack.method_7972(), ItemFluids.EMPTY);
    }

    public class_1839 method_7853(class_1799 stack) {
        return ItemFluids.of(stack).isEmpty() ? class_1839.field_8952 : this.consumptionType.getUseAction();
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 entity) {
        return this.use(stack, world, entity, entity);
    }

    protected boolean canUse(class_1799 stack, class_1937 world, class_1309 entity) {
        return ConsumableFluid.canConsume(stack, entity, this.consumptionVolume, this.consumptionType);
    }

    protected class_1799 use(class_1799 stack, class_1937 world, class_1309 entity, class_1309 user) {
        @Nullable class_3414 sound = this.getUseSound();
        if (sound != null) {
            entity.method_5783(sound, 2.0f, (float)entity.method_6051().method_43385(0.5, 0.2));
        }
        return ConsumableFluid.consume(stack, entity, this.consumptionVolume, class_1301.field_6156.test(user), this.consumptionType);
    }

    @Nullable
    protected class_3414 getUseSound() {
        return null;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (this.canUse(stack, world, (class_1309)player)) {
            player.method_6019(hand);
            return class_1271.method_22428((Object)stack);
        }
        return super.method_7836(world, player, hand);
    }

    public class_1269 method_7884(class_1838 context) {
        return PlacedDrinksBlock.tryPlace(context);
    }

    public int method_7881(class_1799 stack) {
        return this.consumptionTime;
    }

    public class_2561 method_7864(class_1799 stack) {
        ItemFluids fluid = ItemFluids.of(stack);
        if (!fluid.isEmpty()) {
            return class_2561.method_43469((String)(this.method_7876() + ".filled"), (Object[])new Object[]{fluid.fluid().getName(fluid)});
        }
        return super.method_7864(stack);
    }

    public boolean method_31567(class_1799 stack) {
        return !ItemFluids.of(stack).isEmpty() && FluidCapacity.getPercentage(stack) < 1.0f;
    }

    public int method_31569(class_1799 stack) {
        return (int)(13.0f * FluidCapacity.getPercentage(stack));
    }

    public int method_31571(class_1799 stack) {
        return 0xAAAAFF;
    }
}

