/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.psychedelicraft.item.RiftJarItem;
import ivorius.psychedelicraft.item.component.PSComponents;
import ivorius.psychedelicraft.item.component.TooltipAppender;
import ivorius.psychedelicraft.util.compat.PacketCodec;
import ivorius.psychedelicraft.util.compat.PacketCodecs;
import ivorius.psychedelicraft.util.compat.StackCompat;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2540;
import net.minecraft.class_2561;

public record RiftFractionComponent(float amount) implements TooltipAppender
{
    public static final RiftFractionComponent DEFAULT = new RiftFractionComponent(0.0f);
    public static final Codec<RiftFractionComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("amount").forGetter(RiftFractionComponent::amount)).apply((Applicative)instance, RiftFractionComponent::new));
    public static final PacketCodec<class_2540, RiftFractionComponent> PACKET_CODEC = PacketCodec.tuple(PacketCodecs.FLOAT, RiftFractionComponent::amount, RiftFractionComponent::new);

    public static float getRiftFraction(class_1799 stack) {
        RiftFractionComponent amount = StackCompat.get(stack, PSComponents.RIFT_FRACTION);
        return amount == null ? 0.0f : amount.amount();
    }

    public static class_1799 set(class_1799 stack, float riftFraction) {
        if (riftFraction > 0.0f && stack.method_7909() instanceof RiftJarItem) {
            StackCompat.set(stack, PSComponents.RIFT_FRACTION, new RiftFractionComponent(riftFraction));
        }
        return stack;
    }

    @Override
    public void appendTooltip(class_1836 context, Consumer<class_2561> tooltip) {
        tooltip.accept((class_2561)class_2561.method_43471((String)("item.psychedelicraft.rift_jar." + RiftFractionComponent.getUnlocalizedFractionName(this.amount))).method_27692(class_124.field_1080));
    }

    private static String getUnlocalizedFractionName(float fraction) {
        if (fraction <= 0.0f) {
            return "empty";
        }
        if (fraction < 0.4f) {
            return "slightly_filled";
        }
        if (fraction < 0.6f) {
            return "half_filled";
        }
        if (fraction < 0.8f) {
            return "filled";
        }
        return "over_filled";
    }
}

