/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.recipe;

import com.mojang.serialization.Codec;
import ivorius.psychedelicraft.fluid.Processable;
import ivorius.psychedelicraft.fluid.SimpleFluid;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.recipe.ingredient.FluidIngredient;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public class FluidMound
implements Iterable<ItemFluids> {
    public static final Codec<FluidMound> CODEC = ItemFluids.CODEC.listOf().xmap(FluidMound::of, FluidMound::getFluids);
    private final List<ItemFluids> fluids = new ArrayList<ItemFluids>();

    public static FluidMound of() {
        return new FluidMound();
    }

    public static FluidMound of(ItemFluids ... fluids) {
        return FluidMound.of(List.of(fluids));
    }

    public static FluidMound of(Iterable<ItemFluids> fluids) {
        return FluidMound.of().addAll(fluids);
    }

    public static FluidMound of(Processable.Context context) {
        return FluidMound.of(context.getAuxiliaryTanks().stream().map(tank -> tank.getContents()).toList());
    }

    private FluidMound() {
    }

    public List<ItemFluids> getFluids() {
        return this.fluids;
    }

    public ItemFluids get(int index) {
        return this.fluids.get(index);
    }

    public FluidMound addAll(Iterable<ItemFluids> fluids) {
        fluids.forEach(this::add);
        return this;
    }

    public boolean contains(SimpleFluid fluid) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).isOf(fluid)) continue;
            return true;
        }
        return false;
    }

    public int getAmount(ItemFluids fluids) {
        for (int i = 0; i < this.size(); ++i) {
            ItemFluids into = this.get(i);
            if (!into.canCombine(fluids)) continue;
            return into.amount();
        }
        return 0;
    }

    public void add(ItemFluids fluids) {
        for (int i = 0; i < this.size(); ++i) {
            ItemFluids into = this.get(i);
            if (!into.canCombine(fluids)) continue;
            this.fluids.set(i, into.ofAmount(into.amount() + fluids.amount()));
            return;
        }
        this.fluids.add(fluids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int remove(ItemFluids fluids) {
        try {
            int amountRemoved = 0;
            for (int i = 0; i < this.size(); ++i) {
                ItemFluids into = this.get(i);
                if (!into.canCombine(fluids)) continue;
                int amountToRemove = Math.min(into.amount(), fluids.amount());
                this.fluids.set(i, into.ofAmount(into.amount() - amountToRemove));
                if ((amountRemoved += amountToRemove) >= fluids.amount()) break;
            }
            int n = amountRemoved;
            return n;
        }
        finally {
            this.fluids.removeIf(ItemFluids::isEmpty);
        }
    }

    public int size() {
        return this.fluids.size();
    }

    public int totalSize() {
        return this.fluids.stream().mapToInt(ItemFluids::amount).sum();
    }

    public boolean isEmpty() {
        return this.fluids.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeMatch(FluidIngredient ingredient, int defaultLevel) {
        try {
            int amountRemoved = 0;
            for (int i = 0; i < this.fluids.size(); ++i) {
                ItemFluids fluid = this.fluids.get(i);
                if (!ingredient.test(fluid)) continue;
                int amountToConsume = ingredient.level().orElse(defaultLevel <= 0 ? fluid.amount() : defaultLevel);
                int amountConsumed = Math.min(fluid.amount(), amountToConsume);
                this.fluids.set(i, fluid.ofAmount(fluid.amount() - amountConsumed));
                if ((amountRemoved += amountConsumed) < amountToConsume) continue;
                int n = amountRemoved;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.fluids.removeIf(ItemFluids::isEmpty);
        }
    }

    public int getMatchingAmount(FluidIngredient ingredient, int defaultLevel) {
        return this.fluids.stream().filter(ingredient::test).mapToInt(fluid -> ingredient.level().orElse(defaultLevel <= 0 ? fluid.amount() : defaultLevel)).sum();
    }

    public FluidMound split(Predicate<ItemFluids> predicate) {
        FluidMound removed = FluidMound.of();
        this.fluids.removeIf(fluid -> {
            if (predicate.test((ItemFluids)fluid)) {
                removed.add((ItemFluids)fluid);
                return true;
            }
            return false;
        });
        return removed;
    }

    public ItemFluids split(int levels) {
        if (this.isEmpty()) {
            return ItemFluids.EMPTY;
        }
        ItemFluids fluid = this.fluids.get(0);
        int amount = Math.min(fluid.amount(), levels);
        if (amount >= fluid.amount()) {
            this.fluids.remove(0);
        } else {
            this.fluids.set(0, fluid.ofAmount(fluid.amount() - amount));
        }
        return fluid.ofAmount(amount);
    }

    @Override
    public Iterator<ItemFluids> iterator() {
        return this.fluids.iterator();
    }
}

