/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.psychedelicraft.item.component.FluidCapacity;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.recipe.MultiResultRecipe;
import ivorius.psychedelicraft.recipe.PSRecipes;
import ivorius.psychedelicraft.recipe.RecipeUtils;
import ivorius.psychedelicraft.util.compat.PacketCodec;
import ivorius.psychedelicraft.util.compat.PacketCodecs;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1263;
import net.minecraft.class_1662;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1867;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;

public class MixingRecipe
extends class_1867
implements MultiResultRecipe<MixingRecipe> {
    public static final MapCodec<MixingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(class_1867::method_8112), (App)class_7710.field_40252.fieldOf("category").orElse((Object)class_7710.field_40251).forGetter(class_1867::method_45441), (App)ItemFluids.CODEC.fieldOf("result").forGetter(MixingRecipe::getOutputFluid), (App)class_1856.field_46095.fieldOf("receptical").forGetter(i -> i.receptical), (App)RecipeUtils.SHAPELESS_RECIPE_INGREDIENTS_CODEC.fieldOf("ingredients").forGetter(i -> i.input)).apply((Applicative)instance, MixingRecipe::new));
    public static final PacketCodec<class_2540, MixingRecipe> PACKET_CODEC = PacketCodec.tuple(PacketCodecs.STRING, class_1867::method_8112, RecipeUtils.CRAFTING_RECIPE_CATEGORY_PACKET_CODEC, class_1867::method_45441, ItemFluids.PACKET_CODEC, MixingRecipe::getOutputFluid, PacketCodecs.INGREDIENT, recipe -> recipe.receptical, RecipeUtils.INGREDIENTS_PACKET_CODEC, i -> i.input, MixingRecipe::new);
    private final class_1856 receptical;
    private final class_2371<class_1856> input;
    private final ItemFluids output;

    public MixingRecipe(String group, class_7710 category, ItemFluids output, class_1856 receptical, class_2371<class_1856> input) {
        super(group, category, class_1799.field_8037, RecipeUtils.checkLength(RecipeUtils.union(input, receptical)));
        this.receptical = receptical;
        this.input = input;
        this.output = output;
    }

    public ItemFluids getOutputFluid() {
        return this.output;
    }

    public class_1865<?> method_8119() {
        return PSRecipes.FILL_RECEPTICAL;
    }

    public boolean method_17730(class_8566 inventory, class_1937 world) {
        class_1662 recipeMatcher = new class_1662();
        RecipeUtils.stacks((class_1263)inventory).forEach(s -> recipeMatcher.method_20478(s, 1));
        return this.getOutputRecepticals(inventory).count() == 1L && recipeMatcher.method_7402((class_1860)this, null);
    }

    public final class_1799 method_8110(class_5455 registryManager) {
        return this.getOutputFluid().ofFilling(this.receptical.method_8105()[0]);
    }

    private Stream<class_1799> getOutputRecepticals(class_8566 inventory) {
        return RecipeUtils.recepticals(RecipeUtils.stacks((class_1263)inventory)).filter((Predicate<class_1799>)this.receptical).filter(receptical -> this.input.stream().noneMatch(i -> i.method_8093(receptical)) && ItemFluids.of(receptical).isOf((class_3611)class_3612.field_15910) && FluidCapacity.getPercentage(receptical) >= 1.0f);
    }

    public class_1799 method_17729(class_8566 inventory, class_5455 registries) {
        return this.getOutputRecepticals(inventory).findFirst().map(receptical -> this.output.amount() <= 1 ? this.output.ofFilling(receptical.method_7972()) : ItemFluids.set(receptical.method_7972(), this.output.ofAmount(Math.min(this.output.amount(), FluidCapacity.get(receptical))))).orElse(class_1799.field_8037);
    }

    @Override
    public Stream<MixingRecipe> flatten() {
        return Arrays.stream(this.receptical.method_8105()).map(result -> new MixingRecipe(this.method_8112(), this.method_45441(), this.output, class_1856.method_8101((class_1799[])new class_1799[]{result}), this.input));
    }
}

