/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.util.compat;

import io.netty.buffer.ByteBuf;
import ivorius.psychedelicraft.util.compat.PacketCodec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.IntFunction;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2378;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_8702;
import org.joml.Vector3f;

public interface PacketCodecs {
    public static final PacketCodec<ByteBuf, String> STRING = PacketCodec.ofStatic((buff, s) -> class_8702.method_53013((ByteBuf)buff, (CharSequence)s, (int)262144), buff -> class_8702.method_53012((ByteBuf)buff, (int)262144));
    public static final PacketCodec<ByteBuf, Integer> INTEGER = PacketCodec.ofStatic(ByteBuf::writeInt, ByteBuf::readInt);
    public static final PacketCodec<ByteBuf, Float> FLOAT = PacketCodec.ofStatic(ByteBuf::writeFloat, ByteBuf::readFloat);
    public static final PacketCodec<ByteBuf, Double> DOUBLE = PacketCodec.ofStatic(ByteBuf::writeDouble, ByteBuf::readDouble);
    public static final PacketCodec<ByteBuf, Long> VAR_LONG = PacketCodec.ofStatic(ByteBuf::writeLong, ByteBuf::readLong);
    public static final PacketCodec<ByteBuf, Boolean> BOOL = PacketCodec.ofStatic(ByteBuf::writeBoolean, ByteBuf::readBoolean);
    public static final PacketCodec<ByteBuf, Vector3f> VECTOR3F = PacketCodec.tuple(FLOAT, Vector3f::x, FLOAT, Vector3f::y, FLOAT, Vector3f::z, Vector3f::new);
    public static final PacketCodec<class_2540, class_2520> NBT_ELEMENT = PacketCodec.ofStatic(class_2540::method_10794, class_2540::method_10798);
    public static final PacketCodec<ByteBuf, class_2960> IDENTIFIER = STRING.xmap(class_2960::new, class_2960::toString);
    public static final PacketCodec<class_2540, class_1856> INGREDIENT = PacketCodec.ofStatic((buff, i) -> i.method_8088(buff), class_1856::method_8086);
    public static final PacketCodec<class_2540, class_1799> ITEM_STACK = PacketCodec.ofStatic(class_2540::method_10793, class_2540::method_10819);
    public static final PacketCodec<class_2540, Optional<class_1799>> OPTIONAL_ITEM_STACK = PacketCodecs.optional(ITEM_STACK);

    public static <T> PacketCodec<ByteBuf, T> registryValue(class_5321<? extends class_2378<T>> key) {
        return IDENTIFIER.xmap(id -> ((class_2378)class_7923.field_41167.method_29107(key)).method_10223(id), obj -> ((class_2378)class_7923.field_41167.method_29107(key)).method_10221(obj));
    }

    public static <Buff extends ByteBuf, V> PacketCodec<Buff, Optional<V>> optional(PacketCodec<? super Buff, V> valueCodec) {
        return PacketCodec.ofStatic((buffer, value) -> {
            buffer.writeBoolean(value.isPresent());
            if (value.isPresent()) {
                valueCodec.encode(buffer, value.get());
            }
        }, buffer -> buffer.readBoolean() ? Optional.of(valueCodec.decode(buffer)) : Optional.empty());
    }

    public static <B extends ByteBuf, V> PacketCodec.ResultFunction<B, V, List<V>> toList() {
        return PacketCodecs.toCollection(ArrayList::new);
    }

    public static <K, V> PacketCodec<class_2540, Map<K, V>> map(IntFunction<Map<K, V>> maker, PacketCodec<? super class_2540, K> keyCodec, PacketCodec<? super class_2540, V> valueCodec) {
        return PacketCodec.ofStatic((buffer, value) -> buffer.method_34063(value, keyCodec::encode, valueCodec::encode), buffer -> buffer.method_34069(maker, keyCodec::decode, valueCodec::decode));
    }

    public static <Buff extends ByteBuf, T, Result extends Collection<T>> PacketCodec.ResultFunction<Buff, T, Result> toCollection(final IntFunction<Result> factory) {
        return new PacketCodec.ResultFunction<Buff, T, Result>(){

            @Override
            public void encode(Buff buffer, Result value, PacketCodec<? super Buff, T> elementCodec) {
                buffer.writeInt(value.size());
                for (Object t : value) {
                    elementCodec.encode(buffer, t);
                }
            }

            @Override
            public Result decode(Buff buffer, PacketCodec<? super Buff, T> elementCodec) {
                int size = buffer.readInt();
                Collection c = (Collection)factory.apply(size);
                for (int i = 0; i < size; ++i) {
                    c.add(elementCodec.decode(buffer));
                }
                return c;
            }
        };
    }
}

