/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.world.gen.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.psychedelicraft.fluid.SimpleFluid;
import ivorius.psychedelicraft.item.component.FluidCapacity;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.world.gen.loot.PSLootFunctionTypes;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_117;
import net.minecraft.class_120;
import net.minecraft.class_1799;
import net.minecraft.class_44;
import net.minecraft.class_47;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import net.minecraft.class_5658;
import net.minecraft.class_5659;

public class SetFluidsLootFunction
extends class_120 {
    public static final Codec<SetFluidsLootFunction> CODEC = RecordCodecBuilder.create(i -> SetFluidsLootFunction.method_53344((RecordCodecBuilder.Instance)i).and(i.group((App)Codec.list(SimpleFluid.CODEC).fieldOf("fluid").forGetter(o -> o.fluid), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)class_5659.field_45888).fieldOf("attributes").forGetter(o -> o.attributes))).apply((Applicative)i, SetFluidsLootFunction::new));
    private final List<SimpleFluid> fluid;
    private final Map<String, class_5658> attributes;

    protected SetFluidsLootFunction(List<class_5341> conditions, Collection<SimpleFluid> fluid, Map<String, class_5658> attributes) {
        super(conditions);
        this.fluid = fluid.stream().distinct().toList();
        this.attributes = attributes;
    }

    public class_5339 method_29321() {
        return PSLootFunctionTypes.SET_FLUIDS;
    }

    protected class_1799 method_522(class_1799 stack, class_47 context) {
        ItemFluids fluids = this.fluid.get(context.method_294().method_43048(this.fluid.size())).getDefaultStack(FluidCapacity.get(stack));
        HashMap<String, Integer> atrs = new HashMap<String, Integer>(fluids.attributes());
        this.attributes.forEach((attribute, value) -> atrs.put((String)attribute, value.method_366(context)));
        return ItemFluids.set(stack, fluids.withAttributes(atrs));
    }

    public static Builder builder(SimpleFluid fluid) {
        return SetFluidsLootFunction.builder(Set.of(fluid));
    }

    public static Builder builder(Set<SimpleFluid> fluid) {
        return new Builder(fluid);
    }

    public static class Builder
    extends class_120.class_121<Builder> {
        private final Set<SimpleFluid> fluid;
        private final Map<String, class_5658> attributes = new HashMap<String, class_5658>();

        public Builder(Set<SimpleFluid> fluid) {
            this.fluid = fluid;
        }

        public Builder attribute(SimpleFluid.Attribute<Integer> attribute, class_5658 value) {
            this.attributes.put(attribute.name(), value);
            return this;
        }

        public Builder attribute(SimpleFluid.Attribute<Boolean> attribute, boolean value) {
            this.attributes.put(attribute.name(), (class_5658)class_44.method_32448((float)(value ? 1.0f : 0.0f)));
            return this;
        }

        protected Builder getThisBuilder() {
            return this;
        }

        public class_117 method_515() {
            return new SetFluidsLootFunction(this.method_526(), this.fluid, this.attributes);
        }
    }
}

