/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.block;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import ivorius.psychedelicraft.block.PipeInsertable;
import ivorius.psychedelicraft.block.entity.PSBlockEntities;
import ivorius.psychedelicraft.block.entity.SyncedBlockEntity;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.particle.FluidParticleEffect;
import ivorius.psychedelicraft.particle.PSParticles;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3542;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3902;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.joml.Vector3f;

public class GlassTubeBlock
extends class_2237 {
    public static final class_2754<IODirection> IN = class_2754.method_11850((String)"in", IODirection.class);
    public static final class_2754<IODirection> OUT = class_2754.method_11850((String)"out", IODirection.class);
    public static final class_2746 EXTENDED_IN = class_2746.method_11825((String)"extended_in");
    public static final class_2746 EXTENDED_OUT = class_2746.method_11825((String)"extended_out");
    public static final double RADIUS = 0.06;
    private static final class_265 DEFAULT_SHAPE = class_259.method_1081((double)0.4, (double)0.4, (double)0.4, (double)0.6, (double)0.6, (double)0.6);
    private static final Function<class_2350, class_265> SHAPE_PART_CACHE = GlassTubeBlock.createShapePartCache(0.06, 0.0, 1.0);
    private static final Function<class_2680, class_265> SHAPE_CACHE = class_156.method_34866(state -> Stream.of((IODirection)((Object)((Object)state.method_11654(IN))), (IODirection)((Object)((Object)state.method_11654(OUT)))).map(IODirection::getDirection).flatMap(Optional::stream).map(SHAPE_PART_CACHE).reduce(class_259::method_1084).orElse(DEFAULT_SHAPE));

    public static Function<class_2350, class_265> createShapePartCache(double radius, double offset, double length) {
        return class_156.method_34866(direction -> class_259.method_1081((double)((double)direction.method_10148() * offset + 0.5 + Math.min(-radius, (double)direction.method_10148() * 0.5 * length)), (double)((double)direction.method_10164() * offset + 0.5 + Math.min(-radius, (double)direction.method_10164() * 0.5 * length)), (double)((double)direction.method_10165() * offset + 0.5 + Math.min(-radius, (double)direction.method_10165() * 0.5 * length)), (double)((double)direction.method_10148() * offset + 0.5 + Math.max(radius, (double)direction.method_10148() * 0.5 * length)), (double)((double)direction.method_10164() * offset + 0.5 + Math.max(radius, (double)direction.method_10164() * 0.5 * length)), (double)((double)direction.method_10165() * offset + 0.5 + Math.max(radius, (double)direction.method_10165() * 0.5 * length))));
    }

    static class_2754<IODirection> getInverseProperty(class_2754<IODirection> property) {
        return property == IN ? OUT : IN;
    }

    protected GlassTubeBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(IN, (Comparable)((Object)IODirection.NONE))).method_11657((class_2769)EXTENDED_IN, (Comparable)Boolean.valueOf(false))).method_11657(OUT, (Comparable)((Object)IODirection.NONE))).method_11657((class_2769)EXTENDED_OUT, (Comparable)Boolean.valueOf(false)));
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{IN, OUT, EXTENDED_IN, EXTENDED_OUT});
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE_CACHE.apply(state);
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_31574(class_1802.field_8600)) {
            world.method_8652(pos, (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(IN, (Comparable)((Object)((IODirection)((Object)state.method_11654(OUT)))))).method_11657(OUT, (Comparable)((Object)((IODirection)((Object)state.method_11654(IN)))))).method_11657((class_2769)EXTENDED_IN, (Comparable)((Boolean)state.method_11654((class_2769)EXTENDED_OUT)))).method_11657((class_2769)EXTENDED_OUT, (Comparable)((Boolean)state.method_11654((class_2769)EXTENDED_IN))), 16);
            world.method_45447(player, pos, state.method_26231().method_10598(), class_3419.field_15248);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public class_2680 method_9605(class_1750 ctx) {
        IODirection placedDir = IODirection.LOOKUP.get(ctx.method_8038());
        class_2680 state = super.method_9605(ctx);
        class_1937 world = ctx.method_8045();
        class_2338 neighborPos = ctx.method_8037().method_10093(ctx.method_8038().method_10153());
        class_2680 neighborState = world.method_8320(neighborPos);
        return this.updateExtensions(GlassTubeBlock.getConnectionsForRedirection((class_1936)world, neighborPos, neighborState).findFirst().map(placingConnection -> {
            IODirection other = GlassTubeBlock.getValidConnectionDirections((class_1936)ctx.method_8045(), ctx.method_8037(), (class_2754<IODirection>)placingConnection, placedDir.getOpposite()).findFirst().orElse(placedDir);
            return (class_2680)((class_2680)state.method_11657(GlassTubeBlock.getInverseProperty((class_2754<IODirection>)placingConnection), (Comparable)((Object)placedDir.getOpposite()))).method_11657((class_2769)placingConnection, (Comparable)((Object)other));
        }).orElseGet(() -> {
            IODirection in = GlassTubeBlock.getValidConnectionDirections((class_1936)ctx.method_8045(), ctx.method_8037(), OUT, placedDir).findFirst().orElse(placedDir.getOpposite());
            IODirection out = GlassTubeBlock.getValidConnectionDirections((class_1936)ctx.method_8045(), ctx.method_8037(), IN, in).findFirst().orElse(in.getOpposite());
            return this.setDirection(state, in, out);
        }), (class_1936)world, ctx.method_8037());
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        return this.updateExtensions(this.setDirection(state, this.getConnectionStateForNeighborUpdate(pos, state, direction, neighborPos, neighborState, world, IN), this.getConnectionStateForNeighborUpdate(pos, state, direction, neighborPos, neighborState, world, OUT)), world, pos);
    }

    private class_2680 updateExtensions(class_2680 state, class_1936 world, class_2338 pos) {
        IODirection in = (IODirection)((Object)state.method_11654(IN));
        IODirection out = (IODirection)((Object)state.method_11654(OUT));
        return (class_2680)((class_2680)state.method_11657((class_2769)EXTENDED_IN, (Comparable)Boolean.valueOf(in != IODirection.NONE && this.canConnectInto(world, pos, in.direction)))).method_11657((class_2769)EXTENDED_OUT, (Comparable)Boolean.valueOf(out != IODirection.NONE && this.canConnectInto(world, pos, out.direction)));
    }

    private boolean canConnectInto(class_1936 world, class_2338 pos, class_2350 direction) {
        class_2680 state = world.method_8320(pos = pos.method_10093(direction));
        return !(state.method_26204() instanceof GlassTubeBlock) && PipeInsertable.getPipeInterableAt(world, state, pos) != null;
    }

    private IODirection getConnectionStateForNeighborUpdate(class_2338 pos, class_2680 state, class_2350 direction, class_2338 neighborPos, class_2680 neighbor, class_1936 world, class_2754<IODirection> property) {
        IODirection current = (IODirection)((Object)state.method_11654(property));
        if (PipeInsertable.canConnectWith(world, state, pos, neighbor, neighborPos, direction, property == IN)) {
            if (current == IODirection.NONE || !PipeInsertable.canConnectWith(world, state, pos, world.method_8320(pos.method_10093(current.direction)), pos.method_10093(current.direction), current.direction, property == IN)) {
                return IODirection.LOOKUP.get(direction);
            }
        } else if (current.direction == direction) {
            return IODirection.NONE;
        }
        return current;
    }

    protected boolean isBlocked(class_2680 state) {
        return false;
    }

    public class_2680 setDirection(class_2680 state, IODirection in, IODirection out) {
        if (in != IODirection.NONE || out != IODirection.NONE) {
            in = in == IODirection.NONE ? out.getOpposite() : in;
            out = out == IODirection.NONE || in == out ? in.getOpposite() : out;
        }
        return (class_2680)((class_2680)state.method_11657(IN, (Comparable)((Object)in))).method_11657(OUT, (Comparable)((Object)out));
    }

    private static Stream<IODirection> getValidConnectionDirections(class_1936 world, class_2338 pos, class_2754<IODirection> property, IODirection exclude) {
        return List.of(IODirection.NORTH, IODirection.SOUTH, IODirection.EAST, IODirection.WEST, IODirection.DOWN, IODirection.UP).stream().filter(direction -> {
            if (direction == exclude) {
                return false;
            }
            class_2338 neighborPos = pos.method_10093(direction.direction);
            class_2680 neighborState = world.method_8320(neighborPos);
            IODirection neighborComplimentaryDirection = neighborState.method_28500(GlassTubeBlock.getInverseProperty(property)).orElse(null);
            if (neighborComplimentaryDirection == null && !PipeInsertable.canConnectWith(world, neighborState, pos, neighborState, neighborPos, direction.direction, property == IN)) {
                return false;
            }
            return GlassTubeBlock.getConnectionsForRedirection(world, neighborPos, neighborState).anyMatch(openConnection -> openConnection == GlassTubeBlock.getInverseProperty(property));
        });
    }

    private static Stream<class_2754<IODirection>> getConnectionsForRedirection(class_1936 world, class_2338 pos, class_2680 state) {
        return Stream.of(IN, OUT).filter(property -> {
            IODirection currentDirection = state.method_28500((class_2769)property).orElse(IODirection.NONE);
            if (currentDirection == IODirection.NONE) {
                return false;
            }
            class_2338 neighborPos = pos.method_10093(currentDirection.direction);
            class_2680 neighborState = world.method_8320(neighborPos);
            IODirection neighborComplimentaryDirection = neighborState.method_28500(GlassTubeBlock.getInverseProperty((class_2754<IODirection>)property)).orElse(null);
            if (neighborComplimentaryDirection == null && !PipeInsertable.canConnectWith(world, state, pos, neighborState, neighborPos, currentDirection.direction, property == IN)) {
                return true;
            }
            return neighborComplimentaryDirection != null && neighborComplimentaryDirection != currentDirection.getOpposite();
        });
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        world.method_35230(pos, PSBlockEntities.GLASS_TUBE).ifPresent(data -> data.pushContentsForward(world, pos, (IODirection)((Object)((Object)state.method_11654(OUT)))));
    }

    @Deprecated
    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        super.method_9612(state, world, pos, sourceBlock, sourcePos, notify);
        if (world instanceof class_3218) {
            class_3218 sw = (class_3218)world;
            world.method_35230(pos, PSBlockEntities.GLASS_TUBE).ifPresent(data -> {
                data.pushContentsForward(sw, pos, (IODirection)((Object)((Object)state.method_11654(OUT))));
                data.pullContentsForward(sw, pos);
            });
        }
    }

    public boolean method_9516(class_2680 state, class_1922 world, class_2338 pos, class_10 type) {
        return false;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return world.method_35230(pos, PSBlockEntities.GLASS_TUBE).map(data -> (int)((float)data.contents.size() / 10.0f * 15.0f)).orElse(0);
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new Data(pos, state);
    }

    static int getTemperatureDropPerTransfer(class_3218 world, class_2338 center) {
        return 1 + class_2338.method_25998((class_2338)center, (int)1, (int)1, (int)1).mapToInt(pos -> pos.equals((Object)center) ? 0 : GlassTubeBlock.getTemperatureDropFor(world, pos)).sum();
    }

    static int getTemperatureDropFor(class_3218 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        if (state.method_26164(class_3481.field_15467) || state.method_26164(class_3481.field_29823)) {
            return 1;
        }
        if (state.method_26164(class_3481.field_21952) || state.method_26164(class_3481.field_23799) && state.method_28500((class_2769)class_2741.field_12548).orElse(false).booleanValue()) {
            return -1;
        }
        if (state.method_26227().method_15767(class_3486.field_15518)) {
            return -4;
        }
        return 0;
    }

    public static enum IODirection implements class_3542
    {
        NONE(null),
        UP(class_2350.field_11036),
        DOWN(class_2350.field_11033),
        NORTH(class_2350.field_11043),
        SOUTH(class_2350.field_11035),
        EAST(class_2350.field_11034),
        WEST(class_2350.field_11039);

        public static final Map<class_2350, IODirection> LOOKUP;
        static final List<IODirection> VALUES;
        private final class_2350 direction;
        private final String name = this.name().toLowerCase(Locale.ROOT);

        private IODirection(class_2350 direction) {
            this.direction = direction;
        }

        public IODirection getOpposite() {
            return this.direction == null ? this : LOOKUP.getOrDefault(this.direction.method_10153(), NONE);
        }

        public Optional<class_2350> getDirection() {
            return Optional.ofNullable(this.direction);
        }

        public String method_15434() {
            return this.name;
        }

        static {
            LOOKUP = Arrays.stream(IODirection.values()).filter(i -> i.getDirection().isPresent()).collect(Collectors.toMap(i -> i.getDirection().get(), Function.identity()));
            VALUES = LOOKUP.values().stream().toList();
        }
    }

    public static class Data
    extends SyncedBlockEntity
    implements PipeInsertable {
        private final List<PipeInsertable.PipeFluids> contents = new LinkedList<PipeInsertable.PipeFluids>();
        private int temperatureUpdateCooldown;
        private int temperatureDrop;

        public Data(class_2338 pos, class_2680 state) {
            super(PSBlockEntities.GLASS_TUBE, pos, state);
        }

        public List<PipeInsertable.PipeFluids> getContents() {
            return this.contents;
        }

        private int getTemperatureDrop(class_3218 world, class_2338 pos) {
            if (this.temperatureUpdateCooldown == 0) {
                this.temperatureUpdateCooldown = 200;
                this.temperatureDrop = GlassTubeBlock.getTemperatureDropPerTransfer(world, pos);
            }
            return this.temperatureDrop;
        }

        public Either<PipeInsertable.PipeFluids, class_3902> receiveContents(class_3218 world, class_2338 pos, class_2680 state, PipeInsertable.PipeFluids contents) {
            this.pushContentsForward(world, pos, (IODirection)((Object)state.method_11654(OUT)));
            Either status = Optional.of(contents).filter(i -> !i.isEmpty()).map(i -> i.withTemperature(i.temperature() - this.getTemperatureDrop(world, pos))).map(newContents -> {
                if (this.contents.size() < 10) {
                    this.contents.add(0, (PipeInsertable.PipeFluids)newContents);
                } else {
                    PipeInsertable.PipeFluids first = this.contents.get(0);
                    if (first.isEmpty()) {
                        this.contents.remove(0);
                        this.contents.add(0, contents);
                    } else {
                        Optional<PipeInsertable.PipeFluids> available = this.contents.stream().filter(i -> i.fluids().totalSize() < 100).findFirst();
                        if (available.isEmpty()) {
                            return PipeInsertable.reject(contents);
                        }
                        this.contents.set(this.contents.indexOf(available.get()), available.get().combine((PipeInsertable.PipeFluids)newContents));
                    }
                }
                this.method_5431();
                return STATUS_ACCEPT_ALL;
            }).orElse(STATUS_ACCEPT_ALL);
            this.scheduleNextTick(world);
            return status;
        }

        public void pushContentsForward(class_3218 world, class_2338 pos, IODirection direction) {
            if (((GlassTubeBlock)this.method_11010().method_26204()).isBlocked(this.method_11010())) {
                return;
            }
            if (this.contents.size() >= 10) {
                for (int i = this.contents.size() - 2; i > 0; --i) {
                    if (!this.contents.get(i).isEmpty() || this.contents.get(i - 1).isEmpty()) continue;
                    this.contents.remove(i);
                    this.contents.add(0, PipeInsertable.PipeFluids.EMPTY);
                    this.method_5431();
                }
                if (!this.contents.isEmpty()) {
                    PipeInsertable.PipeFluids fluids = this.contents.remove(this.contents.size() - 1);
                    if (!fluids.isEmpty()) {
                        PipeInsertable.PipeFluids pushedBack;
                        PipeInsertable.PipeFluids pipeFluids = pushedBack = fluids.isEmpty() ? PipeInsertable.PipeFluids.EMPTY : direction.getDirection().map(d -> PipeInsertable.tryInsert(world, pos.method_10093(d), d, fluids)).orElse(STATUS_VOIDED).ifRight(unit -> fluids.fluids().getFluids().forEach(fluid -> {
                            Vector3f outVec = direction.getDirection().map(class_2350::method_23955).orElseGet(Vector3f::new);
                            world.method_14199((class_2394)(fluid.fluid().getPhysical().isOf((class_3611)class_3612.field_15910) ? class_2398.field_11232 : (fluid.fluid().getPhysical().isOf((class_3611)class_3612.field_15908) ? class_2398.field_11223 : new FluidParticleEffect(PSParticles.DRIPPING_FLUID, (ItemFluids)fluid))), (double)pos.method_10263() + 0.5 + (double)outVec.x * 0.5, (double)pos.method_10264() + 0.5 + (double)outVec.y * 0.5 - 0.2, (double)pos.method_10260() + 0.5 + (double)outVec.z * 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                        })).left().orElse(PipeInsertable.PipeFluids.EMPTY);
                        if (!pushedBack.isEmpty()) {
                            this.contents.add(pushedBack);
                            if (!pushedBack.equals(fluids)) {
                                this.method_5431();
                            }
                        } else {
                            world.method_8396(null, pos, class_3417.field_15065, class_3419.field_15245, 0.1f, 0.001f);
                            this.method_5431();
                        }
                    } else {
                        this.method_5431();
                    }
                }
            } else {
                this.contents.add(0, PipeInsertable.PipeFluids.EMPTY);
                this.method_5431();
            }
            this.scheduleNextTick(world);
        }

        private void scheduleNextTick(class_3218 world) {
            for (PipeInsertable.PipeFluids i : this.contents) {
                if (i.isEmpty()) continue;
                world.method_39279(this.field_11867, this.method_11010().method_26204(), 3);
                return;
            }
        }

        public void pullContentsForward(class_3218 world, class_2338 pos) {
            if (((GlassTubeBlock)this.method_11010().method_26204()).isBlocked(this.method_11010())) {
                return;
            }
            if (world.method_49809(pos) == 15) {
                ((IODirection)((Object)this.method_11010().method_11654(IN))).getDirection().flatMap(d -> PipeInsertable.tryExtract(world, pos.method_10093(d), d)).ifPresent(fluid -> {
                    this.contents.add(0, (PipeInsertable.PipeFluids)fluid);
                    this.method_5431();
                });
            }
            this.scheduleNextTick(world);
        }

        @Override
        public boolean acceptsConnectionFrom(class_1936 world, class_2680 state, class_2338 pos, class_2680 neighborState, class_2338 neighborPos, class_2350 direction, boolean input) {
            return neighborState.method_26204() instanceof GlassTubeBlock && ((IODirection)((Object)state.method_11654(input ? GlassTubeBlock.OUT : GlassTubeBlock.IN))).direction == direction;
        }

        @Override
        public Either<PipeInsertable.PipeFluids, class_3902> tryInsert(class_3218 world, class_2680 state, class_2338 pos, class_2350 direction, PipeInsertable.PipeFluids fluids) {
            if (((IODirection)((Object)state.method_11654(GlassTubeBlock.IN))).direction == direction.method_10153()) {
                return this.receiveContents(world, pos, state, fluids);
            }
            return PipeInsertable.reject(fluids);
        }

        protected void method_11007(class_2487 nbt) {
            super.method_11007(nbt);
            PipeInsertable.PipeFluids.LIST_CODEC.encodeStart((DynamicOps)class_2509.field_11560, this.contents).result().ifPresent(el -> nbt.method_10566("contents", el));
        }

        public void method_11014(class_2487 nbt) {
            super.method_11014(nbt);
            this.contents.clear();
            PipeInsertable.PipeFluids.LIST_CODEC.decode((DynamicOps)class_2509.field_11560, (Object)nbt.method_10580("contents")).result().map(Pair::getFirst).ifPresent(this.contents::addAll);
        }
    }
}

