/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.render.bezier;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.ints.Int2DoubleFunction;
import ivorius.psychedelicraft.client.render.bezier.Bezier;
import ivorius.psychedelicraft.util.MathUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import net.minecraft.class_3532;
import org.joml.Vector3d;
import org.joml.Vector3dc;

final class Path {
    static final int SAMPLES = 50;
    static final Vector3d[][] UNIT_VECTORS = new Vector3d[][]{{new Vector3d(1.0, 1.0, -1.0), new Vector3d(-1.0, 1.0, -1.0)}, {new Vector3d(-1.0, 1.0, -1.0), new Vector3d(-1.0, 1.0, 1.0)}, {new Vector3d(-1.0, 1.0, 1.0), new Vector3d(1.0, 1.0, 1.0)}, {new Vector3d(1.0, 1.0, 1.0), new Vector3d(1.0, 1.0, -1.0)}};
    private final List<Node> nodes = new ArrayList<Node>();
    private final DoubleList distances = new DoubleArrayList();
    private final double[] progresses;
    private double totalDistance;
    private final java.util.function.Supplier<Intermediate> terminal;

    static Bezier createMemoized(Consumer<NodeConsumer> nodeFactory) {
        return () -> ((Supplier)Suppliers.memoize(() -> new Path(nodeFactory))).get();
    }

    private Path(Consumer<NodeConsumer> nodeFactory) {
        Vector3d from = new Vector3d();
        Vector3d to = new Vector3d();
        Vector3d point1 = new Vector3d();
        Vector3d point2 = new Vector3d();
        nodeFactory.accept((position, orientation, fontSize) -> {
            if (!this.nodes.isEmpty()) {
                Node previous = this.nodes.get(this.nodes.size() - 1);
                double distance = 0.0;
                for (int i = 0; i < 50; ++i) {
                    Path.depart(previous.position(), previous.orientation(), from);
                    Path.approach(position, orientation, to);
                    MathUtils.cubicMix(previous.position(), from, to, position, (double)i / 50.0, point1);
                    MathUtils.cubicMix(previous.position(), from, to, position, (double)(i + 1) / 50.0, point2);
                    distance += point1.distance((Vector3dc)point2);
                }
                this.totalDistance += distance;
                this.distances.add(distance);
            }
            this.nodes.add(new Node(position, orientation, fontSize));
        });
        this.progresses = this.distances.doubleStream().map(d -> d / this.totalDistance).toArray();
        this.terminal = Suppliers.memoize(() -> {
            int nodeCount = this.nodes.size();
            Int2DoubleFunction deltaSupplier = index -> IntStream.range(0, index).mapToDouble(i -> this.progresses[i % this.progresses.length]).sum();
            return Intermediate.create(this.nodes.get(nodeCount - 2), this.nodes.get(nodeCount - 1), deltaSupplier.applyAsDouble(nodeCount - 2), deltaSupplier.applyAsDouble(nodeCount - 1), 1.0);
        });
    }

    public Intermediate getStep(double delta) {
        delta = (delta % 1.0 + 1.0) % 1.0;
        double curProgress = 0.0;
        for (int i = 1; i < this.nodes.size(); ++i) {
            double progress = this.progresses[i - 1];
            if (delta - progress <= 0.0) {
                return Intermediate.create(this.nodes.get(i - 1), this.nodes.get(i), curProgress, curProgress + progress, delta / progress);
            }
            delta -= progress;
            curProgress += progress;
        }
        return this.terminal.get();
    }

    public Vector3d getNaturalRotation(Intermediate intermediate, double stepSize) {
        return Path.toNatural(Path.toSpherical(this.getStep(intermediate.delta() + stepSize * 0.3).position().sub((Vector3dc)intermediate.position(), new Vector3d())));
    }

    private static Vector3d toNatural(Vector3d spherical) {
        spherical.x /= 565.4866776461628;
        spherical.y /= 565.4866776461628;
        spherical.y += 90.0;
        return spherical;
    }

    private static Vector3d toSpherical(Vector3d vector) {
        double r = vector.length();
        double inclination = Math.acos(vector.x / r);
        double azimuth = Math.atan2(vector.y, vector.z);
        return vector.set(azimuth, inclination, r);
    }

    private static Vector3d approach(Vector3d position, Vector3d orientation, Vector3d dest) {
        return position.sub((Vector3dc)orientation, dest);
    }

    private static Vector3d depart(Vector3d position, Vector3d orientation, Vector3d dest) {
        return position.add((Vector3dc)orientation, dest);
    }

    static interface NodeConsumer {
        public void accept(Vector3d var1, Vector3d var2, double var3);
    }

    record Node(Vector3d position, Vector3d orientation, double fontSize) {
    }

    record Intermediate(Vector3d position, float fontSize, double delta) {
        static Intermediate create(Node prev, Node next, double minDelta, double maxDelta, double betweenDelta) {
            float delta = (float)class_3532.method_16436((double)betweenDelta, (double)minDelta, (double)maxDelta);
            return new Intermediate(MathUtils.cubicMix(prev.position(), Path.depart(prev.position(), prev.orientation(), new Vector3d()), Path.approach(next.position(), next.orientation(), new Vector3d()), next.position(), betweenDelta, new Vector3d()), (float)class_3532.method_16436((double)delta, (double)prev.fontSize(), (double)next.fontSize()), delta);
        }
    }
}

