/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.render.effect;

import ivorius.psychedelicraft.client.render.effect.ScreenEffect;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class CompoundScreenEffect
implements ScreenEffect {
    private final List<ScreenEffect> effects = new ArrayList<ScreenEffect>();
    private final class_310 client = class_310.method_1551();

    public static ScreenEffect of(ScreenEffect ... effects) {
        return new CompoundScreenEffect().add(effects);
    }

    private CompoundScreenEffect() {
    }

    public CompoundScreenEffect add(ScreenEffect ... effects) {
        for (ScreenEffect effect : effects) {
            this.add(effect);
        }
        return this;
    }

    public CompoundScreenEffect add(ScreenEffect effect) {
        if (effect instanceof CompoundScreenEffect) {
            CompoundScreenEffect comp = (CompoundScreenEffect)effect;
            this.effects.addAll(comp.effects);
        } else {
            this.effects.add(effect);
        }
        return this;
    }

    @Override
    public boolean shouldApply(float tickDelta) {
        return this.client.field_1724 != null;
    }

    @Override
    public void update(float tickDelta) {
        this.effects.forEach(effect -> effect.update(tickDelta));
    }

    @Override
    public void render(class_332 context, class_1041 window, float tickDelta) {
        this.effects.forEach(effect -> {
            if (effect.shouldApply(tickDelta)) {
                effect.render(context, window, tickDelta);
            }
        });
    }

    @Override
    public void close() {
        this.effects.forEach(e -> {
            try {
                e.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.effects.clear();
    }
}

