/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.render.effect;

import com.mojang.blaze3d.platform.GlStateManager;
import ivorius.psychedelicraft.client.PsychedelicraftClient;
import ivorius.psychedelicraft.client.render.RenderUtil;
import ivorius.psychedelicraft.client.render.effect.ScreenEffect;
import ivorius.psychedelicraft.entity.drug.Drug;
import ivorius.psychedelicraft.entity.drug.DrugProperties;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.class_1041;
import net.minecraft.class_1657;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_6367;

public class MotionBlurScreenEffect
implements ScreenEffect {
    private static final int MAX_SAMPLES = 30;
    private static final float SAMPLE_FREQUENCY = 0.5f;
    private float previousTicks;
    private int currentSample;
    private GlTextureSet textures;
    public float motionBlur;

    @Override
    public void update(float tickDelta) {
        this.motionBlur = (Boolean)PsychedelicraftClient.getConfig().doMotionBlur.get() != false && class_310.method_1551().field_1724 != null ? DrugProperties.of((class_1657)class_310.method_1551().field_1724).getModifier(Drug.MOTION_BLUR) : 0.0f;
    }

    @Override
    public void render(class_332 context, class_1041 window, float tickDelta) {
        if (class_310.method_1551().field_1724 == null) {
            return;
        }
        int screenWidth = window.method_4486();
        int screenHeight = window.method_4502();
        if (this.motionBlur > 0.0f) {
            if (this.textures != null && this.textures.sizeChanged(screenWidth, screenHeight)) {
                this.close();
            }
            if (this.textures == null) {
                this.textures = new GlTextureSet(30, screenWidth, screenHeight);
            }
            if (this.previousTicks > (tickDelta += (float)class_310.method_1551().field_1724.field_6012)) {
                this.previousTicks = tickDelta;
            } else if (this.previousTicks + 15.0f < tickDelta) {
                this.previousTicks = tickDelta - 15.0f;
            }
            while (this.previousTicks + 0.5f <= tickDelta) {
                ++this.currentSample;
                this.currentSample %= 30;
                this.textures.getTexture(this.currentSample).sample();
                this.previousTicks += 0.5f;
            }
            this.textures.drawToScreen(context, this.currentSample);
        } else if (this.textures != null) {
            ++this.currentSample;
            this.currentSample %= 30;
            this.textures.getTexture(this.currentSample).reset();
        }
    }

    @Override
    public void close() {
        if (this.textures != null) {
            this.textures.close();
            this.textures = null;
        }
    }

    private class GlTextureSet
    implements AutoCloseable {
        private final int width;
        private final int height;
        private final List<GlTexture> textures;

        public GlTextureSet(int samples, int width, int height) {
            this.width = width;
            this.height = height;
            this.textures = IntStream.range(1, samples + 1).mapToObj(i -> new GlTexture(i, width, height)).toList();
        }

        public GlTexture getTexture(int sample) {
            return this.textures.get(sample);
        }

        public boolean sizeChanged(int width, int height) {
            return this.width != width || this.height != height;
        }

        public void drawToScreen(class_332 context, int currentSample) {
            for (int i = 0; i < this.textures.size(); ++i) {
                this.textures.get((i + currentSample) % this.textures.size()).drawToScreen(context);
            }
        }

        @Override
        public void close() {
            this.textures.forEach(GlTexture::close);
        }
    }

    private class GlTexture
    implements AutoCloseable {
        private final class_6367 output;
        private final int sample;
        private boolean prepared;

        public GlTexture(int sample, int width, int height) {
            this.sample = sample;
            this.output = new class_6367(width, height, true, class_310.field_1703);
            this.output.field_1480 = width;
            this.output.field_1477 = height;
        }

        public void sample() {
            class_276 input = class_310.method_1551().method_1522();
            GlStateManager._glBindFramebuffer((int)36008, (int)input.field_1476);
            GlStateManager._glBindFramebuffer((int)36009, (int)this.output.field_1476);
            GlStateManager._glBlitFrameBuffer((int)0, (int)0, (int)input.field_1482, (int)input.field_1481, (int)0, (int)0, (int)this.output.field_1482, (int)this.output.field_1481, (int)16384, (int)9728);
            GlStateManager._glBindFramebuffer((int)36160, (int)0);
            input.method_1235(true);
            this.prepared = true;
        }

        public void reset() {
            this.prepared = false;
        }

        public void drawToScreen(class_332 context) {
            float alpha = Math.min(1.0f, (float)this.sample * 0.002f * MotionBlurScreenEffect.this.motionBlur);
            if (this.prepared && alpha > 0.0f) {
                RenderUtil.drawBuffer((class_276)this.output, 1.0f, 1.0f, 1.0f, alpha);
            }
        }

        @Override
        public void close() {
            this.output.method_1238();
        }
    }
}

