/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.render.shader;

import ivorius.psychedelicraft.Psychedelicraft;
import ivorius.psychedelicraft.client.PsychedelicraftClient;
import ivorius.psychedelicraft.client.SodiumCompat;
import ivorius.psychedelicraft.client.render.RenderPhase;
import ivorius.psychedelicraft.client.render.shader.BuiltGemoetryShader;
import ivorius.psychedelicraft.client.render.shader.FloatSupplier;
import ivorius.psychedelicraft.client.render.shader.ShaderContext;
import ivorius.psychedelicraft.client.render.shader.UniformCollection;
import ivorius.psychedelicraft.entity.drug.Drug;
import ivorius.psychedelicraft.util.MathUtils;
import ivorius.psychedelicraft.util.UntrustedIdentifier;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_156;
import net.minecraft.class_281;
import net.minecraft.class_284;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3532;
import net.minecraft.class_3679;
import net.minecraft.class_3695;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class GeometryShader
implements IdentifiableResourceReloadListener {
    private static final String GEO_DIRECTORY = "shaders/geometry/";
    private static final Pattern PS_VARIABLE_PATTERN = Pattern.compile("(^|\\n)ps_([a-z]+ +[a-zA-Z0-9]+) +([^;]+);");
    private static final class_2960 BASIC = Psychedelicraft.id("basic");
    private static final class_2960 ID = Psychedelicraft.id("geometry_shaders");
    public static final GeometryShader INSTANCE = new GeometryShader();
    private class_2960 name;
    private class_281.class_282 type;
    private final class_310 client = class_310.method_1551();
    @Nullable
    private class_3300 manager = this.client.method_1478();
    private final Map<class_2960, Optional<String>> loadedPrograms = new HashMap<class_2960, Optional<String>>();
    private final Map<String, Supplier<Integer>> samplers = (Map)class_156.method_654(new HashMap(), map -> map.put("PS_SurfaceFractalSampler", () -> {
        class_2960 id = class_1059.field_5275;
        if (this.client.field_1724 != null) {
            id = this.client.method_1541().method_3351().method_3339(ShaderContext.hallucinations().getFractalAppearance()).method_45852();
        }
        return this.client.method_1531().method_4619(id).method_4624();
    }));

    public class_2960 getFabricId() {
        return ID;
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 synchronizer, class_3300 manager, class_3695 prepareProfiler, class_3695 applyProfiler, Executor prepareExecutor, Executor applyExecutor) {
        this.loadedPrograms.clear();
        this.manager = manager;
        return CompletableFuture.completedFuture(null);
    }

    public void setup(class_281.class_282 type, String domain, String name) {
        this.setup(type, UntrustedIdentifier.of(domain, name));
    }

    public void setup(class_281.class_282 type, class_2960 name) {
        this.name = name;
        this.type = type;
    }

    public boolean isEnabled() {
        return RenderPhase.current() != RenderPhase.NORMAL && this.client.field_1687 != null && this.client.field_1724 != null;
    }

    public boolean isWorld() {
        return (RenderPhase.current() == RenderPhase.WORLD || RenderPhase.current() == RenderPhase.CLOUDS) && this.client.field_1687 != null && this.client.field_1724 != null;
    }

    public BuiltGemoetryShader.Builder createShaderBuilder(int program, int lastUniformId, int lastSamplerId) {
        BuiltGemoetryShader.Builder builder = new BuiltGemoetryShader.Builder(program, lastUniformId, lastSamplerId);
        this.samplers.forEach(builder::addSampler);
        this.addUniforms(builder, builder::addUniform);
        return builder;
    }

    public void addUniforms(final class_3679 program, final Consumer<class_284> register) {
        this.addUniforms(new UniformCollection(){

            @Override
            public void vec1(String name, FloatSupplier value) {
                register.accept(new BoundUniform(name, class_284.method_1299((String)"float"), 1, program, uniform -> uniform.method_1251(value.getAsFloat())));
            }

            @Override
            public void vec3(String name, Supplier<Vector3f> value) {
                register.accept(new BoundUniform(name, class_284.method_1299((String)"float") + 2, 3, program, uniform -> uniform.method_34413((Vector3f)value.get())));
            }

            @Override
            public void vec4(String name, Supplier<Vector4f> value) {
                register.accept(new BoundUniform(name, class_284.method_1299((String)"float") + 3, 4, program, uniform -> uniform.method_35652((Vector4f)value.get())));
            }
        });
    }

    public void addUniforms(UniformCollection uniformHolder) {
        uniformHolder.vec1("PS_SurfaceFractalStrength", () -> this.isEnabled() ? class_3532.method_15363((float)ShaderContext.hallucinations().get(Drug.FRACTALS), (float)0.0f, (float)1.0f) : 0.0f);
        uniformHolder.vec4("PS_Pulses", () -> this.isEnabled() ? ShaderContext.hallucinations().getPulseColor(ShaderContext.tickDelta(), RenderPhase.current() == RenderPhase.SKY) : MathUtils.ZERO);
        uniformHolder.vec4("PS_SurfaceFractalCoords", () -> {
            if (this.isEnabled() && ShaderContext.hallucinations().get(Drug.FRACTALS) > 0.0f) {
                class_1058 sprite = this.client.method_1541().method_3351().method_3339(ShaderContext.hallucinations().getFractalAppearance());
                SodiumCompat.markSpriteActive(sprite);
                return new Vector4f(sprite.method_4594(), sprite.method_4593(), sprite.method_4577(), sprite.method_4575());
            }
            return MathUtils.ZERO;
        });
        uniformHolder.vec3("PS_PlayerPosition", () -> ShaderContext.position().method_46409());
        uniformHolder.vec1("PS_WorldTicks", () -> ShaderContext.ticks());
        uniformHolder.vec4("PS_WavesMatrix", () -> {
            if (this.isWorld() && RenderPhase.current() != RenderPhase.CLOUDS) {
                return new Vector4f(ShaderContext.hallucinations().get(Drug.SMALL_WAVES), ShaderContext.hallucinations().get(Drug.BIG_WAVES), ShaderContext.hallucinations().get(Drug.WIGGLE_WAVES), ShaderContext.hallucinations().get(Drug.BUBBLING_WAVES));
            }
            return MathUtils.ZERO;
        });
        uniformHolder.vec1("PS_DistantWorldDeformation", () -> this.isWorld() ? ShaderContext.hallucinations().get(Drug.DISTANT_WAVES) : 0.0f);
        uniformHolder.vec1("PS_FractalFractureStrength", () -> this.isWorld() ? ShaderContext.hallucinations().get(Drug.SHATTERING_WAVES) : 0.0f);
        uniformHolder.vec1("PS_lsdBlendRatio", () -> this.isWorld() && RenderPhase.current() != RenderPhase.CLOUDS ? ShaderContext.modifier(Drug.RAINBOW_WAVES) : (RenderPhase.current() == RenderPhase.SKY ? ShaderContext.modifier(Drug.RAINBOW_WAVES) * 1.1f : 0.0f));
    }

    public Map<String, Supplier<Integer>> getSamplers() {
        return this.samplers;
    }

    public String injectShaderSources(@Nullable String source) {
        if (source == null) {
            return null;
        }
        if (source.indexOf("PSYCHEDELICRAFT") != -1) {
            Psychedelicraft.LOGGER.info("Skipping already-processed shader " + String.valueOf(this.name));
            return source;
        }
        if (source.indexOf("void main()") == -1) {
            return source;
        }
        if (this.type == class_281.class_282.field_1530) {
            return this.loadProgram(this.name.method_45134(p -> GEO_DIRECTORY + p + ".gvsh")).or(() -> this.loadProgram(BASIC.method_45134(p -> GEO_DIRECTORY + p + ".gvsh"))).map(geometryShaderSources -> this.combineSources(source, (String)geometryShaderSources)).orElse(source);
        }
        if (this.type == class_281.class_282.field_1531) {
            return this.loadProgram(this.name.method_45134(p -> p + ".gfsh")).or(() -> this.loadProgram(BASIC.method_45134(p -> GEO_DIRECTORY + p + ".gfsh"))).map(geometryShaderSources -> this.combineSources(source, (String)geometryShaderSources)).orElse(source);
        }
        Psychedelicraft.LOGGER.info("Skipping unknown shader " + String.valueOf(this.name));
        return source;
    }

    private String combineSources(String vertexSources, String geometrySources) {
        this.writeSources(vertexSources, "before");
        if (this.name.method_12836().equalsIgnoreCase("sodium")) {
            if (vertexSources.indexOf("out vec4 v_Color") != -1 || vertexSources.indexOf("in vec4 v_Color") != -1) {
                geometrySources = ((String)geometrySources).replaceAll("vertexColor", "v_Color");
            }
            if (vertexSources.indexOf("_vert_position") != -1 && vertexSources.indexOf("in vec3 Position") == -1 && vertexSources.indexOf("in vec4 Position") == -1) {
                geometrySources = ((String)geometrySources).replaceAll("/\\*replaceme\\*/Position", "_vert_position");
            }
            if (vertexSources.indexOf("out float v_FragDistance") != -1 || vertexSources.indexOf("in float v_FragDistance") != -1) {
                geometrySources = ((String)geometrySources).replaceAll("vertexDistance", "v_FragDistance");
            }
        }
        if (this.name.method_12832().startsWith("iris/")) {
            if (vertexSources.indexOf("in vec3 Position") == -1 && vertexSources.indexOf("in vec4 Position") == -1) {
                geometrySources = ((String)geometrySources).replaceAll("/\\*replaceme\\*/Position", "cameraPosition");
            }
            if (vertexSources.indexOf("uniform vec3 cameraPosition") == -1) {
                geometrySources = "uniform vec3 cameraPosition;" + (String)geometrySources;
            }
        }
        geometrySources = PS_VARIABLE_PATTERN.matcher((CharSequence)geometrySources).replaceAll(match -> {
            String fieldSlug = Arrays.stream(match.group(3).split(",")).map(String::trim).filter(field -> !vertexSources.contains((CharSequence)field)).collect(Collectors.joining(", "));
            return fieldSlug.isEmpty() ? "/* " + match.group(0) + "*/" : match.group(2) + " " + fieldSlug + ";";
        });
        String newline = System.lineSeparator();
        return this.writeSources(vertexSources.replace("void main()", "void i_parent_shaders_main()" + newline) + newline + "/*PSYCHEDELICRAFT START*/" + newline + (String)geometrySources + newline + "/*PSYCHEDELICRAFT END*/", "merged");
    }

    private String writeSources(String sources, String suffex) {
        if (!((Boolean)PsychedelicraftClient.getConfig().exportShaderSources.get()).booleanValue()) {
            return sources;
        }
        Path output = FabricLoader.getInstance().getGameDir().resolve("logs/shader_compilation/" + this.type.name().toLowerCase(Locale.ROOT) + "/" + this.name.method_12836() + "/" + this.name.method_12832() + "_" + suffex);
        try {
            Files.createDirectories(output.getParent(), new FileAttribute[0]);
            Files.deleteIfExists(output);
        }
        catch (IOException e) {
            Psychedelicraft.LOGGER.error("Could not remove stale shader sources file {} {}", (Object)output, (Object)e);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(output, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            writer.append(sources);
            writer.flush();
        }
        catch (IOException e) {
            Psychedelicraft.LOGGER.error("Could not write shader sources to file {} {}", (Object)output, (Object)e);
        }
        return sources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<String> loadProgram(class_2960 id) {
        GeometryShader geometryShader = this;
        synchronized (geometryShader) {
            if (((Boolean)PsychedelicraftClient.getConfig().forceShaderRecompiles.get()).booleanValue()) {
                return this.manager.method_14486(id).map(res -> {
                    String string;
                    block8: {
                        InputStream stream = res.method_14482();
                        try {
                            string = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                            if (stream == null) break block8;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (stream != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IOException e) {
                                return null;
                            }
                        }
                        stream.close();
                    }
                    return string;
                });
            }
            Optional<String> source = this.loadedPrograms.getOrDefault(id, Optional.empty());
            if (source.isEmpty()) {
                source = this.manager.method_14486(id).map(res -> {
                    String string;
                    block8: {
                        InputStream stream = res.method_14482();
                        try {
                            string = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                            if (stream == null) break block8;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (stream != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IOException e) {
                                return null;
                            }
                        }
                        stream.close();
                    }
                    return string;
                });
                this.loadedPrograms.put(id, source);
            }
            return source;
        }
    }

    static class BoundUniform
    extends class_284 {
        private final Consumer<class_284> valueGetter;

        public BoundUniform(String name, int dataType, int count, class_3679 program, Consumer<class_284> valueGetter) {
            super(name, dataType, count, program);
            this.valueGetter = valueGetter;
        }

        public void method_1300() {
            this.valueGetter.accept(this);
            super.method_1300();
        }
    }
}

