/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.compat.tia;

import io.github.mattidragon.tlaapi.api.gui.GuiBuilder;
import io.github.mattidragon.tlaapi.api.gui.TextureConfig;
import io.github.mattidragon.tlaapi.api.recipe.TlaIngredient;
import io.github.mattidragon.tlaapi.api.recipe.TlaStack;
import ivorius.psychedelicraft.block.entity.DryingTableBlockEntity;
import ivorius.psychedelicraft.client.screen.DryingTableScreen;
import ivorius.psychedelicraft.compat.tia.PSRecipe;
import ivorius.psychedelicraft.compat.tia.RecipeCategory;
import ivorius.psychedelicraft.recipe.DryingRecipe;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3544;

class DryingEmiRecipe
implements PSRecipe {
    private static final TextureConfig SUN = TextureConfig.builder().size(25, 25).texture(DryingTableScreen.TEXTURE).uv(177, 20).build();
    private static final TextureConfig ARROW_FILL = TextureConfig.builder().size(25, 20).texture(DryingTableScreen.TEXTURE).uv(177, 42).build();
    private final DryingRecipe recipe;
    private final List<TlaIngredient> input;
    private final List<TlaStack> output;

    public DryingEmiRecipe(DryingRecipe recipe) {
        this.recipe = recipe;
        TlaIngredient input = TlaIngredient.ofIngredient((class_1856)recipe.input());
        this.input = Stream.generate(() -> input).limit(9L).toList();
        this.output = List.of(TlaStack.of((class_1799)recipe.method_8110(class_310.method_1551().field_1687.method_30349())));
    }

    @Override
    public RecipeCategory getCategory() {
        return RecipeCategory.DRYING_TABLE;
    }

    public class_2960 getId() {
        return this.recipe.method_8114();
    }

    public List<TlaIngredient> getInputs() {
        return this.input;
    }

    public List<TlaStack> getOutputs() {
        return this.output;
    }

    public List<TlaIngredient> getCatalysts() {
        return List.of();
    }

    public void buildGui(GuiBuilder widgets) {
        int y = 12;
        widgets.addArrow(60, 18 + y, false);
        int sOff = 0;
        for (int i = 0; i < 9; ++i) {
            int s = i + sOff;
            widgets.addSlot(s >= 0 && s < this.input.size() ? this.input.get(s) : TlaIngredient.EMPTY, i % 3 * 18, i / 3 * 18 + y).markInput();
        }
        widgets.addSlot(this.output.get(0), 92, 14 + y).makeLarge().markOutput();
        widgets.addText((class_2561)class_2561.method_43469((String)"psychedelicraft.recipe.experience", (Object[])new Object[]{Float.valueOf(this.recipe.experience())}), 58, 55, -1, true);
        widgets.addTexture(SUN, 95, 0);
        long cookingTime = DryingTableBlockEntity.getCookingTime(this.recipe.cookTime(), false);
        widgets.addAnimatedTexture(ARROW_FILL, 60, 18 + y, (int)cookingTime, true, false, false).addTooltip(new class_2561[]{class_2561.method_43469((String)"psychedelicraft.recipe.drying_time", (Object[])new Object[]{class_3544.method_15439((int)((int)cookingTime))})});
    }
}

