/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.compat.tia;

import io.github.mattidragon.tlaapi.api.gui.CustomTlaWidget;
import io.github.mattidragon.tlaapi.api.gui.GuiBuilder;
import io.github.mattidragon.tlaapi.api.gui.TlaBounds;
import io.github.mattidragon.tlaapi.api.gui.WidgetConfig;
import ivorius.psychedelicraft.client.screen.AbstractFluidContraptionScreen;
import ivorius.psychedelicraft.item.component.ItemFluids;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_332;

final class FluidBoxWidget
implements CustomTlaWidget {
    private final List<ItemFluids> fluids;
    private final TlaBounds bounds;
    private final int capacity;
    private final List<TlaBounds> exclusionZones = new ArrayList<TlaBounds>();

    public static FluidBoxWidget create(ItemFluids fluids, int capacity, int x, int y, int width, int height, GuiBuilder builder) {
        return FluidBoxWidget.create(List.of(fluids), capacity, x, y, width, height, builder);
    }

    public static FluidBoxWidget create(List<ItemFluids> fluids, int capacity, int x, int y, int width, int height, GuiBuilder builder) {
        return new FluidBoxWidget(fluids, capacity, x, y, width, height, builder);
    }

    private FluidBoxWidget(List<ItemFluids> fluids, int capacity, int x, int y, int width, int height, GuiBuilder builder) {
        this.fluids = fluids;
        this.capacity = capacity;
        this.bounds = new TlaBounds(x, y, width, height);
        builder.addCustomWidget((CustomTlaWidget)this);
    }

    public TlaBounds getBounds() {
        return this.bounds;
    }

    public void addExclusion(TlaBounds bounds) {
        this.exclusionZones.add(bounds);
    }

    public void addExclusion(WidgetConfig config) {
        this.exclusionZones.add(config.getBounds());
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        ItemFluids fluids = this.fluids.get((int)(System.currentTimeMillis() / 3000L) % this.fluids.size()).ofAmount(this.capacity);
        int width = this.bounds.width();
        int height = this.bounds.height();
        AbstractFluidContraptionScreen.drawTank(context, fluids, this.capacity, 0, 0, width, height);
        for (TlaBounds exclusion : this.exclusionZones) {
            if (!exclusion.contains(mouseX, mouseY)) continue;
            return;
        }
        AbstractFluidContraptionScreen.drawTankTooltip(context, fluids, 0L, 0, 0, width, height, mouseX - this.bounds.left(), mouseY - this.bounds.top(), List.of());
    }
}

