/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.compat.tia;

import io.github.mattidragon.tlaapi.api.gui.GuiBuilder;
import io.github.mattidragon.tlaapi.api.plugin.PluginContext;
import io.github.mattidragon.tlaapi.api.recipe.TlaIngredient;
import io.github.mattidragon.tlaapi.api.recipe.TlaStack;
import ivorius.psychedelicraft.PSTags;
import ivorius.psychedelicraft.compat.tia.FluidStageUtil;
import ivorius.psychedelicraft.compat.tia.PSRecipe;
import ivorius.psychedelicraft.compat.tia.RecipeCategory;
import ivorius.psychedelicraft.compat.tia.RecipeUtil;
import ivorius.psychedelicraft.fluid.Processable;
import ivorius.psychedelicraft.fluid.SimpleFluid;
import ivorius.psychedelicraft.item.PSItems;
import ivorius.psychedelicraft.item.component.ItemFluids;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.IntStream;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3544;

class FluidStagesEmiRecipe
implements PSRecipe {
    private final class_2960 id;
    private final RecipeCategory category;
    private final List<TlaIngredient> catalysts;
    private final List<Stage> stages;

    public static BiConsumer<RecipeCategory, PluginContext> generate() {
        return (category, context) -> context.addGenerator(client -> FluidStageUtil.combineSimilarProcesses(SimpleFluid.REGISTRY.method_10220().filter(fluid -> fluid instanceof Processable).flatMap(fluid -> ((Processable)((Object)fluid)).getProcesses().filter(process -> !process.transitions().isEmpty())), process -> new FluidStagesEmiRecipe((RecipeCategory)category, (Processable.Process)process), processes -> new FluidStagesEmiRecipe((RecipeCategory)category, List.copyOf(processes))).toList());
    }

    private FluidStagesEmiRecipe(RecipeCategory category, Processable.Process process) {
        this.category = category;
        this.id = process.id();
        ItemFluids def = process.fluid().getDefaultStack();
        this.stages = process.transitions().stream().map(transition -> new Stage((Processable.Transition)transition, RecipeUtil.toIngredient(transition.input().apply(def)), RecipeUtil.toIngredient(transition.output().apply(def)), Stage.getStackForProcess(transition.type()))).toList();
        this.catalysts = List.of(TlaIngredient.ofItemTag(process.fluid().getPreferredContainerTag()));
    }

    private FluidStagesEmiRecipe(RecipeCategory category, List<Processable.Process> processes) {
        this.category = category;
        Processable.Process process = processes.get(0);
        this.id = process.id().method_45138("/");
        this.stages = IntStream.range(0, process.transitions().size()).mapToObj(i -> {
            Processable.Transition transition = process.transitions().get(i);
            return new Stage(transition, TlaIngredient.join(processes.stream().map(p -> RecipeUtil.toIngredient(p.transitions().get(i).input().apply(p.fluid().getDefaultStack()))).distinct().toList()), TlaIngredient.join(processes.stream().map(p -> RecipeUtil.toIngredient(p.transitions().get(i).output().apply(p.fluid().getDefaultStack()))).distinct().toList()), Stage.getStackForProcess(transition.type()));
        }).toList();
        this.catalysts = processes.stream().map(Processable.Process::fluid).distinct().map(SimpleFluid::getPreferredContainerTag).distinct().map(TlaIngredient::ofItemTag).toList();
    }

    @Override
    public RecipeCategory getCategory() {
        return this.category;
    }

    public class_2960 getId() {
        return this.id;
    }

    public List<TlaIngredient> getInputs() {
        return List.of(this.stages.get(0).input());
    }

    public List<TlaStack> getOutputs() {
        return List.copyOf(this.stages.get(this.stages.size() - 1).output().getStacks());
    }

    public List<TlaIngredient> getCatalysts() {
        return this.catalysts;
    }

    public void buildGui(GuiBuilder widgets) {
        int totalWidth = this.stages.size() * 65 + 8;
        int left = (this.category.getDisplayWidth() - totalWidth) / 2;
        for (int i = 0; i < this.stages.size(); ++i) {
            Stage stage = this.stages.get(i);
            stage.buildGui(left + i * 65, i, widgets, i == this.stages.size() - 1);
        }
    }

    record Stage(Processable.Transition transition, TlaIngredient input, TlaIngredient output, TlaIngredient container) {
        public void buildGui(int x, int y, GuiBuilder widgets, boolean last) {
            widgets.addSlot(this.input, x, y).markInput();
            widgets.addSlot(this.container, x + 19, y).markCatalyst();
            int ticks = Math.max(1, this.transition.time() * this.transition.multiplier());
            widgets.addAnimatedArrow(x + 40, y, ticks < 20 ? 1 : ticks / 20).addTooltip(new class_2561[]{class_2561.method_43469((String)"gui.psychedelicraft.recipe.fluid_process", (Object[])new Object[]{class_2561.method_43471((String)("fluid.status." + this.transition.type().method_15434())), class_3544.method_15439((int)ticks)})});
            widgets.addText((class_2561)class_2561.method_43470((String)(this.transition.multiplier() + "x")), x + 45, y + 9, -1, true);
            if (last) {
                widgets.addSlot(this.output, x + 65, y).markOutput();
            }
        }

        private static TlaIngredient getStackForProcess(Processable.ProcessType type) {
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case Processable.ProcessType.SEPARATE, Processable.ProcessType.FERMENT, Processable.ProcessType.ACETIFY, Processable.ProcessType.COOL -> TlaStack.of((class_1935)PSItems.MASH_TUB).asIngredient();
                case Processable.ProcessType.PURIFY -> TlaStack.of((class_1935)PSItems.BUNSEN_BURNER).asIngredient();
                case Processable.ProcessType.MATURE -> TlaIngredient.ofItemTag(PSTags.Items.BARRELS);
                case Processable.ProcessType.DISTILL -> TlaStack.of((class_1935)PSItems.DISTILLERY).asIngredient();
                case Processable.ProcessType.IDLE -> TlaStack.of((class_1935)PSItems.BOTTLE).asIngredient();
            };
        }
    }
}

