/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.datagen.providers.recipe;

import ivorius.psychedelicraft.PSTags;
import ivorius.psychedelicraft.datagen.providers.recipe.FluidRecipeJsonBuilder;
import ivorius.psychedelicraft.datagen.providers.recipe.RecipeJsonBuilderCompat;
import ivorius.psychedelicraft.fluid.SimpleFluid;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.recipe.MixingRecipe;
import ivorius.psychedelicraft.recipe.PSRecipes;
import ivorius.psychedelicraft.recipe.ingredient.FluidIngredient;
import ivorius.psychedelicraft.recipe.ingredient.OptionalFluidIngredient;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1792;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_193;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2371;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_6862;
import net.minecraft.class_7798;
import net.minecraft.class_7800;
import org.jetbrains.annotations.Nullable;

public class MixingRecipeJsonBuilder
extends class_7798
implements FluidRecipeJsonBuilder {
    private final class_7800 category;
    private final ItemFluids output;
    private final class_2371<class_1856> inputs = class_2371.method_10211();
    private final Map<String, class_184> criteria = new LinkedHashMap<String, class_184>();
    private final class_161.class_162 advancementBuilder = class_161.class_162.method_51698();
    @Nullable
    private String group;
    private class_1856 receptical = class_1856.method_8106(PSTags.Items.DRINK_RECEPTICALS);

    public MixingRecipeJsonBuilder(class_7800 category, ItemFluids output) {
        this.category = category;
        this.output = output;
    }

    public static MixingRecipeJsonBuilder create(class_7800 category, ItemFluids output) {
        return new MixingRecipeJsonBuilder(category, output);
    }

    public static MixingRecipeJsonBuilder create(class_7800 category, SimpleFluid output, int amount) {
        return new MixingRecipeJsonBuilder(category, output.getDefaultStack(amount));
    }

    public MixingRecipeJsonBuilder input(class_6862<class_1792> tag) {
        return this.input(class_1856.method_8106(tag));
    }

    public MixingRecipeJsonBuilder input(class_1935 input) {
        return this.input(input, 1);
    }

    public MixingRecipeJsonBuilder input(class_1935 input, int count) {
        return this.input(class_1856.method_8091((class_1935[])new class_1935[]{input}), count);
    }

    public MixingRecipeJsonBuilder input(class_1856 ingredient) {
        return this.input(ingredient, 1);
    }

    public MixingRecipeJsonBuilder input(class_1856 ingredient, int count) {
        for (int i = 0; i < count; ++i) {
            this.inputs.add((Object)ingredient);
        }
        return this;
    }

    public MixingRecipeJsonBuilder receptical(class_6862<class_1792> tag) {
        return this.receptical(tag, (class_3611)class_3612.field_15910);
    }

    public MixingRecipeJsonBuilder receptical(class_1935 receptical) {
        return this.receptical(receptical, (class_3611)class_3612.field_15910);
    }

    public MixingRecipeJsonBuilder receptical(class_6862<class_1792> tag, class_3611 fluid) {
        this.receptical = new OptionalFluidIngredient(Optional.of(FluidIngredient.builder().fluid(fluid).build()), Optional.of(class_1856.method_8106(tag))).toVanilla();
        return this;
    }

    public MixingRecipeJsonBuilder receptical(class_1935 receptical, class_3611 fluid) {
        this.receptical = new OptionalFluidIngredient(Optional.of(FluidIngredient.builder().fluid(fluid).build()), Optional.of(class_1856.method_8091((class_1935[])new class_1935[]{receptical}))).toVanilla();
        return this;
    }

    public MixingRecipeJsonBuilder criterion(String name, class_184 criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public MixingRecipeJsonBuilder group(@Nullable String group) {
        this.group = group;
        return this;
    }

    @Override
    public ItemFluids getOutputFluids() {
        return this.output;
    }

    public void method_17972(Consumer<class_2444> exporter, class_2960 recipeId) {
        recipeId = recipeId.method_48331("_from_mixing");
        this.validate(recipeId);
        class_161.class_162 builder = this.advancementBuilder.method_709("has_the_recipe", (class_184)class_2119.method_27847((class_2960)recipeId)).method_703(class_170.class_171.method_753((class_2960)recipeId)).method_704(class_193.field_1257);
        this.criteria.forEach((arg_0, arg_1) -> ((class_161.class_162)builder).method_709(arg_0, arg_1));
        exporter.accept(RecipeJsonBuilderCompat.createProvider(PSRecipes.FILL_RECEPTICAL, new MixingRecipe(recipeId, Objects.requireNonNullElse(this.group, ""), MixingRecipeJsonBuilder.method_46202((class_7800)this.category), this.output, this.receptical, this.inputs), builder, recipeId.method_45138("recipes/" + this.category.method_46203() + "/")));
    }

    private void validate(class_2960 recipeId) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(recipeId));
        }
    }
}

