/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.entity.drug;

import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import ivorius.psychedelicraft.entity.drug.Attribute;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public interface DrugAttributeFunctions {
    public static final DrugAttributeFunctions EMPTY = attribute -> attribute;

    public Func get(Attribute var1);

    public static Builder builder() {
        return new Builder();
    }

    public static DrugAttributeFunctions empty() {
        return EMPTY;
    }

    public static class Builder {
        private final Impl functions = new Impl(new HashMap<Attribute, Func>());

        private Builder() {
        }

        public Builder put(Attribute attribute, Float2FloatFunction function) {
            return this.put(attribute, (float strength, int ticks) -> function.get(strength));
        }

        public Builder put(Attribute attribute, float scale) {
            return this.put(attribute, (float strength, int ticks) -> strength * scale);
        }

        public Builder put(Attribute attribute, Func function) {
            this.functions.functions().put(attribute, function);
            return this;
        }

        public Builder add(Attribute attribute, Function<Func, Func> function) {
            this.functions.functions().put(attribute, function.apply(this.functions.get(attribute)));
            return this;
        }

        public DrugAttributeFunctions build() {
            return new Impl(Map.copyOf(this.functions.functions()));
        }

        private record Impl(Map<Attribute, Func> functions) implements DrugAttributeFunctions
        {
            @Override
            public Func get(Attribute attribute) {
                return this.functions.getOrDefault(attribute, attribute);
            }
        }
    }

    public static interface Func {
        public float apply(float var1, int var2);
    }
}

