/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.entity.drug;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import ivorius.psychedelicraft.PSSounds;
import ivorius.psychedelicraft.Psychedelicraft;
import ivorius.psychedelicraft.entity.drug.Drug;
import ivorius.psychedelicraft.entity.drug.DrugAttributeFunctions;
import ivorius.psychedelicraft.entity.drug.type.AlcoholDrug;
import ivorius.psychedelicraft.entity.drug.type.AtropineDrug;
import ivorius.psychedelicraft.entity.drug.type.BathSaltsDrug;
import ivorius.psychedelicraft.entity.drug.type.BrownShroomsDrug;
import ivorius.psychedelicraft.entity.drug.type.CaffeineDrug;
import ivorius.psychedelicraft.entity.drug.type.CannabisDrug;
import ivorius.psychedelicraft.entity.drug.type.CocaineDrug;
import ivorius.psychedelicraft.entity.drug.type.HarmoniumDrug;
import ivorius.psychedelicraft.entity.drug.type.KavaDrug;
import ivorius.psychedelicraft.entity.drug.type.LsdDrug;
import ivorius.psychedelicraft.entity.drug.type.MorphineDrug;
import ivorius.psychedelicraft.entity.drug.type.PeyoteDrug;
import ivorius.psychedelicraft.entity.drug.type.PowerDrug;
import ivorius.psychedelicraft.entity.drug.type.RedShroomsDrug;
import ivorius.psychedelicraft.entity.drug.type.SimpleDrug;
import ivorius.psychedelicraft.entity.drug.type.SleepDeprivationDrug;
import ivorius.psychedelicraft.entity.drug.type.TobaccoDrug;
import ivorius.psychedelicraft.entity.drug.type.WarmthDrug;
import java.util.function.Function;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5321;
import net.minecraft.class_7923;

public record DrugType<T extends Drug>(class_2960 id, Function<DrugType<T>, T> constructor, Function<DrugType<T>, MapCodec<T>> codecFunction, DrugAttributeFunctions functions) {
    public static final class_2378<DrugType<?>> REGISTRY = FabricRegistryBuilder.createSimple((class_5321)class_5321.method_29180((class_2960)Psychedelicraft.id("drugs"))).buildAndRegister();
    public static final DrugType<AlcoholDrug> ALCOHOL = DrugType.register("alcohol", AlcoholDrug.FUNCTIONS, SimpleDrug::createCodec, (DrugType<T> type) -> new AlcoholDrug((DrugType<AlcoholDrug>)type, 1.0, 2.0E-4));
    public static final DrugType<CannabisDrug> CANNABIS = DrugType.register("cannabis", CannabisDrug.FUNCTIONS, SimpleDrug::createCodec, (DrugType<T> type) -> new CannabisDrug(1.0, 2.0E-4));
    public static final DrugType<BrownShroomsDrug> BROWN_SHROOMS = DrugType.register("brown_shrooms", BrownShroomsDrug.FUNCTIONS, SimpleDrug::createCodec, (DrugType<T> type) -> new BrownShroomsDrug(1.0, 2.0E-4));
    public static final DrugType<RedShroomsDrug> RED_SHROOMS = DrugType.register("red_shrooms", RedShroomsDrug.FUNCTIONS, SimpleDrug::createCodec, (DrugType<T> type) -> new RedShroomsDrug(1.0, 2.0E-4));
    public static final DrugType<TobaccoDrug> TOBACCO = DrugType.register("tobacco", TobaccoDrug.FUNCTIONS, SimpleDrug::createCodec, (DrugType<T> type) -> new TobaccoDrug(1.0, 0.003));
    public static final DrugType<CocaineDrug> COCAINE = DrugType.register("coccaine", CocaineDrug.FUNCTIONS, SimpleDrug::createCodec, (DrugType<T> type) -> new CocaineDrug(1.0, 3.0E-4));
    public static final DrugType<CaffeineDrug> CAFFEINE = DrugType.register("caffeine", CaffeineDrug.functions(1.0f), SimpleDrug::createCodec, (DrugType<T> type) -> new CaffeineDrug((DrugType<CaffeineDrug>)type, 1.0, 2.0E-4));
    public static final DrugType<CaffeineDrug> SUGAR = DrugType.register("sugar", CaffeineDrug.functions(0.0f), SimpleDrug::createCodec, (DrugType<T> type) -> new CaffeineDrug((DrugType<CaffeineDrug>)type, 1.0, 2.0E-4));
    public static final DrugType<BathSaltsDrug> BATH_SALTS = DrugType.register("bath_salts", BathSaltsDrug.FUNCTIONS, SimpleDrug::createCodec, (DrugType<T> type) -> new BathSaltsDrug(1.0, 1.2E-4));
    public static final DrugType<SleepDeprivationDrug> SLEEP_DEPRIVATION = DrugType.register("sleep_deprivation", SleepDeprivationDrug.FUNCTIONS, SleepDeprivationDrug.CODEC, (DrugType<T> type) -> new SleepDeprivationDrug());
    public static final DrugType<LsdDrug> LSD = DrugType.register("lsd", LsdDrug.FUNCTIONS, SimpleDrug::createCodec, (DrugType<T> type) -> new LsdDrug((DrugType<LsdDrug>)type, 1.0, 3.0E-4));
    public static final DrugType<AtropineDrug> ATROPINE = DrugType.register("atropine", AtropineDrug.FUNCTIONS, SimpleDrug::createCodec, (DrugType<T> type) -> new AtropineDrug(1.0, 3.0E-4));
    public static final DrugType<MorphineDrug> MORPHINE = DrugType.register("morphine", MorphineDrug.MORPHINE_FUNCTIONS, SimpleDrug::createCodec, (DrugType<T> type) -> new MorphineDrug((DrugType<MorphineDrug>)type, 1.0, 3.0E-4));
    public static final DrugType<MorphineDrug> METHAMPHETAMINE = DrugType.register("methamphetamine", MorphineDrug.METH_FUNCTIONS, SimpleDrug::createCodec, (DrugType<T> type) -> new MorphineDrug((DrugType<MorphineDrug>)type, 1.0, 3.0E-4));
    public static final DrugType<KavaDrug> KAVA = DrugType.register("kava", KavaDrug.FUNCTIONS, SimpleDrug::createCodec, (DrugType<T> type) -> new KavaDrug(1.0, 2.0E-4));
    public static final DrugType<WarmthDrug> WARMTH = DrugType.register("warmth", WarmthDrug.FUNCTIONS, SimpleDrug::createCodec, (DrugType<T> type) -> new WarmthDrug(1.0, 0.004));
    public static final DrugType<PeyoteDrug> PEYOTE = DrugType.register("peyote", PeyoteDrug.FUNCTIONS, SimpleDrug::createCodec, (DrugType<T> type) -> new PeyoteDrug(1.0, 2.0E-4));
    public static final DrugType<SimpleDrug> ZERO = DrugType.register("zero", DrugAttributeFunctions.empty(), SimpleDrug::createCodec, (DrugType<T> type) -> new SimpleDrug((DrugType<? extends SimpleDrug>)type, 1.0, 1.0E-4));
    public static final DrugType<PowerDrug> POWER = DrugType.register("power", PowerDrug.FUNCTIONS, SimpleDrug::createCodec, (DrugType<T> type) -> new PowerDrug(0.95, 1.0E-4));
    public static final DrugType<HarmoniumDrug> HARMONIUM = DrugType.register("harmonium", DrugAttributeFunctions.empty(), SimpleDrug::createCodec, (DrugType<T> type) -> new HarmoniumDrug(1.0, 3.0E-4));

    public T create() {
        return (T)((Drug)this.constructor.apply(this));
    }

    public Codec<T> codec() {
        return this.codecFunction.apply(this).codec();
    }

    public class_3414 soundEvent() {
        return class_7923.field_41172.method_17966(this.id.method_45138("drug.")).orElse(class_3417.field_42593);
    }

    static <T extends Drug> DrugType<T> register(String name, DrugAttributeFunctions functions, MapCodec<T> codec, Function<DrugType<T>, T> constructor) {
        return DrugType.register(name, functions, (DrugType<T> t) -> codec, constructor);
    }

    static <T extends Drug> DrugType<T> register(String name, DrugAttributeFunctions functions, Function<DrugType<T>, MapCodec<T>> codec, Function<DrugType<T>, T> constructor) {
        DrugType<T> type = new DrugType<T>(Psychedelicraft.id(name), constructor, codec, functions);
        PSSounds.register("drug." + name);
        return (DrugType)class_2378.method_10230(REGISTRY, (class_2960)type.id(), type);
    }
}

