/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.entity.drug;

import net.minecraft.class_1702;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public interface LockableHungerManager {
    default public void lockHunger(int hunger, float saturation, boolean full, float strength) {
        this.setLockedState(new State(new Ratio(hunger, strength), new Ratio(saturation, strength), full));
    }

    default public void lockHunger(boolean full, float ratio) {
        this.lockHunger(this.getHungerManager().method_7586(), this.getHungerManager().method_7589(), full, ratio);
    }

    default public void unlockHunger() {
        this.setLockedState(null);
    }

    public float getActualSaturationLevel();

    public int getActualFoodLevel();

    public void setShanksShaking(boolean var1);

    default public void makePermanent() {
        if (this.getLockedState() != null) {
            class_1702 hunger = this.getHungerManager();
            float saturation = hunger.method_7589();
            int food = hunger.method_7586();
            this.unlockHunger();
            hunger.method_7581(saturation);
            hunger.method_7580(food);
        }
    }

    public class_1702 getHungerManager();

    @Nullable
    public State getLockedState();

    public void setLockedState(State var1);

    public record State(Ratio hunger, Ratio saturation, boolean full) {
        static State fromNbt(class_2487 compound) {
            return new State(Ratio.fromNbt(compound.method_10562("hunger")), Ratio.fromNbt(compound.method_10562("saturation")), compound.method_10577("full"));
        }

        public class_2487 toNbt() {
            class_2487 compound = new class_2487();
            compound.method_10566("hunger", (class_2520)this.hunger.toNbt());
            compound.method_10566("saturation", (class_2520)this.saturation.toNbt());
            compound.method_10556("full", this.full);
            return compound;
        }

        public void setRate(float rate) {
            this.hunger.setRate(rate);
            this.saturation.setRate(rate);
        }
    }

    public static final class Ratio {
        private float initial;
        private float rate;

        Ratio(float initial, float rate) {
            this.initial = initial;
            this.rate = rate;
        }

        public void setRate(float newRate) {
            this.rate = newRate;
        }

        public float getRate() {
            return this.rate;
        }

        static Ratio fromNbt(class_2487 compound) {
            return new Ratio(compound.method_10583("initial"), compound.method_10583("rate"));
        }

        public float toFloat(float reference) {
            this.initial = this.rate > 0.0f ? Math.max(this.initial, reference) : Math.min(this.initial, reference);
            return Math.max(0.0f, class_3532.method_16439((float)(reference > this.initial ? -this.rate : this.rate), (float)reference, (float)this.initial));
        }

        public class_2487 toNbt() {
            class_2487 compound = new class_2487();
            compound.method_10548("initial", this.initial);
            compound.method_10548("rate", this.rate);
            return compound;
        }
    }
}

