/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.entity.drug.hallucination;

import ivorius.psychedelicraft.entity.drug.DrugProperties;
import ivorius.psychedelicraft.entity.drug.hallucination.ChatBot;
import ivorius.psychedelicraft.entity.drug.hallucination.EntityHallucinationType;
import ivorius.psychedelicraft.entity.drug.hallucination.Hallucination;
import ivorius.psychedelicraft.entity.drug.hallucination.HallucinationManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class EntityHallucinationList
implements Iterable<Hallucination> {
    private final List<Hallucination> entities = new ArrayList<Hallucination>();
    private final List<Hallucination> pending = new ArrayList<Hallucination>();
    private final HallucinationManager manager;
    private int prevForcedTicks;
    private int forcedTicks;

    EntityHallucinationList(HallucinationManager manager) {
        this.manager = manager;
    }

    public DrugProperties getProperties() {
        return this.manager.getProperties();
    }

    public HallucinationManager getManager() {
        return this.manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        float hallucinationChance = this.manager.getEntityHallucinationStrength() * 0.05f;
        if (this.forcedTicks > 0) {
            this.prevForcedTicks = this.forcedTicks--;
        }
        if (hallucinationChance > 0.0f && this.manager.getProperties().asEntity().method_6051().method_43048((int)(1.0f / hallucinationChance)) == 0) {
            this.spawnHallucination();
        }
        this.swap();
        this.pending.clear();
        List<Hallucination> list = this.entities;
        synchronized (list) {
            this.entities.removeIf(hallucination -> {
                hallucination.update();
                return hallucination.isDead();
            });
        }
        this.swap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Hallucination> List<T> getHallucinations(Class<T> type) {
        List<Hallucination> list = this.entities;
        synchronized (list) {
            return this.entities.stream().filter(a -> a.getClass() == type).map(type::cast).toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swap() {
        List<Hallucination> list = this.entities;
        synchronized (list) {
            this.entities.addAll(this.pending);
            this.pending.clear();
        }
    }

    public float getForcedAlpha(float tickDelta) {
        float ticks = (float)this.manager.getProperties().getAge() + tickDelta;
        float percent = (float)class_3532.method_48781((float)tickDelta, (int)this.prevForcedTicks, (int)this.forcedTicks) / 400.0f;
        if (percent <= 0.01f) {
            return 0.0f;
        }
        float baseAlpha = Math.abs(Math.min(class_3532.method_15374((float)(percent * 1.5707964f * 2.0f)) * 2.0f, 1.0f));
        if (percent < 0.1f) {
            baseAlpha += 0.5f + class_3532.method_15374((float)(ticks / 3.0f)) / 2.0f;
            baseAlpha /= 2.0f;
        }
        return baseAlpha;
    }

    public void spawnHallucination() {
        if (this.getProperties().asEntity().method_37908().field_9236) {
            EntityHallucinationType.getCandidates(this).findFirst().ifPresent(type -> this.addHallucination((EntityHallucinationType)type, false));
        }
    }

    @Nullable
    public Hallucination addHallucination(class_2960 type, boolean force) {
        EntityHallucinationType factory;
        if (force) {
            this.forcedTicks = 400;
            this.prevForcedTicks = 400;
        }
        if ((factory = EntityHallucinationType.REGISTRY.get(type)) != null) {
            return this.addHallucination(factory, false);
        }
        return null;
    }

    public Hallucination addHallucination(EntityHallucinationType type, boolean force) {
        if (force) {
            this.forcedTicks = 400;
            this.prevForcedTicks = 400;
        }
        Hallucination hallucination = type.factory().apply(this.manager.getProperties().asEntity());
        this.pending.add(hallucination);
        return hallucination;
    }

    public int getNumberOfHallucinations(Predicate<Hallucination> test) {
        int count = 0;
        for (Hallucination hallucination : this) {
            if (!test.test(hallucination)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<Hallucination> iterator() {
        return this.entities.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChatBot> getChatBots() {
        List<Hallucination> list = this.entities;
        synchronized (list) {
            return this.entities.stream().flatMap(i -> i.getChatBot().stream()).toList();
        }
    }
}

