/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.fluid;

import ivorius.psychedelicraft.entity.drug.DrugType;
import ivorius.psychedelicraft.entity.drug.influence.DrugInfluence;
import ivorius.psychedelicraft.fluid.DrugFluid;
import ivorius.psychedelicraft.fluid.Processable;
import ivorius.psychedelicraft.fluid.SimpleFluid;
import ivorius.psychedelicraft.fluid.alcohol.TickRate;
import ivorius.psychedelicraft.fluid.container.Resovoir;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.util.MathUtils;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class ChemicalExtractFluid
extends DrugFluid
implements Processable,
TickRate.Tickable {
    public static final SimpleFluid.Attribute<Integer> DISTILLATION = SimpleFluid.Attribute.ofInt("distillation", 0, 2);
    final DrugFluid.Settings settings;
    private final DrugType<?> drug;
    private final DrugFluid purifiedForm;
    private static final TickRate DEFAULT_TICK_RATE = TickRate.ofMinutes(40, 1, 30, 30);

    public ChemicalExtractFluid(class_2960 id, DrugFluid.Settings settings, DrugType<?> drug, DrugFluid purifiedForm) {
        super(id, settings.drinkable());
        this.settings = settings;
        this.drug = drug;
        this.purifiedForm = purifiedForm;
    }

    @Override
    protected void getDrugInfluencesPerLiter(ItemFluids stack, Consumer<DrugInfluence> consumer) {
        super.getDrugInfluencesPerLiter(stack, consumer);
        consumer.accept(new DrugInfluence(this.drug, 0, 0.03, 0.0, Math.pow(96.0, DISTILLATION.get(stack).intValue())));
    }

    @Override
    public int getProcessingTime(Resovoir tank, Processable.ProcessType type) {
        if (type == Processable.ProcessType.PURIFY) {
            int distillation = DISTILLATION.get(tank.getContents());
            return this.getTickRate().ticksPerDistillation() * (1 + distillation);
        }
        return -1;
    }

    @Override
    public TickRate getDefaultTickRate() {
        return DEFAULT_TICK_RATE;
    }

    @Override
    public void process(Processable.Context context, Processable.ProcessType type, Processable.ByProductConsumer output) {
        if (type == Processable.ProcessType.PURIFY) {
            int amount;
            Resovoir tank = context.getPrimaryTank();
            ItemFluids fluids = tank.drain(amount = Math.max(1, tank.getContents().amount() / 10));
            if (DISTILLATION.get(fluids) < 2) {
                output.accept(DISTILLATION.cycle(fluids));
            } else {
                output.accept(this.purifiedForm.getDefaultStack(1).ofAmount(amount));
            }
        }
    }

    @Override
    public Stream<Processable.Process> getProcesses() {
        int distillRate = this.getTickRate().ticksPerDistillation();
        return Stream.of(new Processable.Process(this, this.getId().method_48331("_reducing"), DISTILLATION.steps().map(step -> new Processable.Transition(Processable.ProcessType.PURIFY, distillRate * (1 + (Integer)step.method_15442()), 1, from -> DISTILLATION.set((ItemFluids)from, (Integer)step.method_15442()), to -> DISTILLATION.set((ItemFluids)to, (Integer)step.method_15441()))).toList()), new Processable.Process(this, this.getId().method_48331("_purifying"), DISTILLATION.steps().map(step -> new Processable.Transition(Processable.ProcessType.PURIFY, distillRate * 3, 1, from -> DISTILLATION.set((ItemFluids)from, (Integer)2).ofAmount(2), to -> this.purifiedForm.getDefaultStack(1))).toList()));
    }

    @Override
    public class_2561 getName(ItemFluids stack) {
        int distillation = DISTILLATION.get(stack);
        return class_2561.method_43469((String)(this.getTranslationKey() + ".distilled." + distillation), (Object[])new Object[]{distillation});
    }

    @Override
    public int getColor(ItemFluids stack) {
        return MathUtils.mixColors(super.getColor(stack), -1, (float)DISTILLATION.get(stack).intValue() / 16.0f);
    }

    @Override
    public int getHash(ItemFluids stack) {
        return Objects.hash(this, DISTILLATION.get(stack));
    }
}

