/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.fluid.alcohol;

import ivorius.psychedelicraft.fluid.AlcoholicFluid;
import ivorius.psychedelicraft.fluid.alcohol.AlcoholicFluidState;
import ivorius.psychedelicraft.item.component.ItemFluids;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_2096;

public record StatePredicate(class_2096.class_2100 fermentationRange, class_2096.class_2100 maturationRange, class_2096.class_2100 distillationRange, TriState vinegar, AlcoholicFluidState state) implements Predicate<ItemFluids>
{
    public static final StatePredicate ANY = StatePredicate.builder().build();
    public static final StatePredicate BASE = StatePredicate.builder().vinegar(false).distills(0).ferments(0).maturation(0).build();
    public static final StatePredicate VINEGAR = StatePredicate.builder().vinegar(true).build();
    public static final StatePredicate FERMENTED_1 = StatePredicate.builder().vinegar(false).maturation(0).distills(0).ferments(1).build();
    public static final StatePredicate FERMENTED_2 = StatePredicate.builder().vinegar(false).maturation(0).distills(0).ferments(2).build();
    public static final StatePredicate FERMENTED_DISTILLED = StatePredicate.builder().vinegar(false).minFerments(1).minDistills(1).maturation(0).build();
    public static final StatePredicate FERMENTED_MATURED = StatePredicate.builder().vinegar(false).minFerments(1).minMaturity(1).distills(0).build();
    public static final StatePredicate FERMENTED_MATURED_DISTILLED = StatePredicate.builder().vinegar(false).minFerments(1).minMaturity(1).minDistills(1).build();

    @Override
    public boolean test(ItemFluids stack) {
        return this.test(AlcoholicFluid.FERMENTATION.get(stack), AlcoholicFluid.DISTILLATION.get(stack), AlcoholicFluid.MATURATION.get(stack), AlcoholicFluid.VINEGAR.get(stack));
    }

    @Override
    public boolean test(AlcoholicFluidState state) {
        return this.test(state.fermentation(), state.distillation(), state.maturation(), state.vinegar());
    }

    public boolean test(int fermentation, int distillation, int maturation, boolean vinegar) {
        return this.fermentationRange.method_9054(fermentation) && this.distillationRange.method_9054(distillation) && this.maturationRange.method_9054(maturation) && this.vinegar.orElse(vinegar) == vinegar;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private class_2096.class_2100 fermentationRange = class_2096.class_2100.field_9708;
        private class_2096.class_2100 maturationRange = class_2096.class_2100.field_9708;
        private class_2096.class_2100 distillationRange = class_2096.class_2100.field_9708;
        private TriState vinegar = TriState.DEFAULT;

        public Builder vinegar(boolean vinegar) {
            this.vinegar = TriState.of((boolean)vinegar);
            return this;
        }

        public Builder minFerments(int fermented) {
            return this.ferments(class_2096.class_2100.method_9053((int)fermented));
        }

        public Builder ferments(int fermentation) {
            return this.ferments(class_2096.class_2100.method_9058((int)fermentation));
        }

        public Builder ferments(class_2096.class_2100 range) {
            this.fermentationRange = range;
            return this;
        }

        public Builder maturation(int maturation) {
            return this.maturation(class_2096.class_2100.method_9058((int)maturation));
        }

        public Builder minMaturity(int maturity) {
            return this.maturation(class_2096.class_2100.method_9053((int)maturity));
        }

        public Builder maturation(class_2096.class_2100 range) {
            this.maturationRange = range;
            return this;
        }

        public Builder minDistills(int distills) {
            return this.distillation(class_2096.class_2100.method_9053((int)distills));
        }

        public Builder distills(int distillations) {
            return this.distillation(class_2096.class_2100.method_9058((int)distillations));
        }

        public Builder distillation(class_2096.class_2100 range) {
            this.distillationRange = range;
            return this;
        }

        public StatePredicate build() {
            AlcoholicFluidState.Builder stateBuilder = AlcoholicFluidState.builder();
            if (this.fermentationRange.method_9038() != null) {
                stateBuilder.fermentation((Integer)this.fermentationRange.method_9038());
            }
            if (this.maturationRange.method_9038() != null) {
                stateBuilder.maturation((Integer)this.maturationRange.method_9038());
            }
            if (this.distillationRange.method_9038() != null) {
                stateBuilder.distillation((Integer)this.distillationRange.method_9038());
            }
            if (this.vinegar == TriState.TRUE) {
                stateBuilder.vinegar();
            }
            return new StatePredicate(this.fermentationRange, this.maturationRange, this.distillationRange, this.vinegar, stateBuilder.build());
        }
    }
}

