/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.fluid.alcohol;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.psychedelicraft.Psychedelicraft;
import ivorius.psychedelicraft.config.TickRates;
import ivorius.psychedelicraft.fluid.SimpleFluid;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_5321;

public record TickRate(int ticksPerFermentation, int ticksPerDistillation, int ticksPerMaturation, int ticksUntilAcetification) {
    public static final int MINUTE = 1200;
    public static final TickRate DEFAULT = TickRate.ofMinutes(40, 40, 30, 30);
    public static final Codec<TickRate> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.fieldOf("ticksPerFermentation").forGetter(TickRate::ticksPerFermentation), (App)Codec.INT.fieldOf("ticksPerDistillation").forGetter(TickRate::ticksPerDistillation), (App)Codec.INT.fieldOf("ticksPerMaturation").forGetter(TickRate::ticksPerMaturation), (App)Codec.INT.fieldOf("ticksUntilAcetification").forGetter(TickRate::ticksUntilAcetification)).apply((Applicative)i, TickRate::new));

    public static TickRate ofMinutes(int f, int d, int m, int a) {
        return new TickRate(f * 1200, d * 1200, m * 1200, a * 1200);
    }

    public static Map<class_5321<SimpleFluid>, TickRate> getDefaults() {
        return SimpleFluid.REGISTRY.method_40270().filter(i -> i.comp_349() instanceof Tickable && i.method_40230().isPresent()).collect(Collectors.toMap(i -> (class_5321)i.method_40230().orElseThrow(), i -> ((Tickable)i.comp_349()).getDefaultTickRate()));
    }

    public static interface Tickable {
        public TickRate getDefaultTickRate();

        default public TickRate getTickRate() {
            return ((TickRates)Psychedelicraft.getConfig().fluidAttributes.get()).values().getOrDefault(((SimpleFluid)((Object)this)).getRegistryEntry().method_40230().orElseThrow(), this.getDefaultTickRate());
        }
    }
}

