/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.psychedelicraft.item.PSItems;
import ivorius.psychedelicraft.item.PaperBagItem;
import ivorius.psychedelicraft.item.component.PSComponents;
import ivorius.psychedelicraft.item.component.TooltipAppender;
import ivorius.psychedelicraft.util.compat.PacketCodec;
import ivorius.psychedelicraft.util.compat.PacketCodecs;
import ivorius.psychedelicraft.util.compat.StackCompat;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2540;
import net.minecraft.class_2561;

public record BagContentsComponent(class_1799 stack, int count) implements TooltipAppender
{
    public static final BagContentsComponent EMPTY = new BagContentsComponent(class_1799.field_8037, 0);
    public static final int FULL_COUNT = 16000;
    public static final Codec<BagContentsComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1799.field_24671.fieldOf("stack").forGetter(BagContentsComponent::stack), (App)Codec.INT.fieldOf("count").forGetter(BagContentsComponent::count)).apply((Applicative)instance, BagContentsComponent::of));
    public static final PacketCodec<class_2540, BagContentsComponent> PACKET_CODEC = PacketCodec.tuple(PacketCodecs.ITEM_STACK, BagContentsComponent::stack, PacketCodecs.INTEGER, BagContentsComponent::count, BagContentsComponent::of);

    public static BagContentsComponent of(class_1799 stack, int count) {
        if (count <= 0 || stack.method_7960()) {
            return EMPTY;
        }
        return new BagContentsComponent(stack, count);
    }

    public static BagContentsComponent get(class_1799 stack) {
        return StackCompat.getOrDefault(stack, PSComponents.BAG_CONTENTS, EMPTY);
    }

    public static BagContentsComponent set(class_1799 stack, Builder builder) {
        return StackCompat.set(stack, PSComponents.BAG_CONTENTS, builder.build());
    }

    public static class_1799 withdraw(class_1799 stack, int count) {
        BagContentsComponent contents = BagContentsComponent.get(stack);
        if (contents.isEmpty()) {
            return class_1799.field_8037;
        }
        Builder builder = new Builder(contents);
        class_1799 result = builder.split(count);
        if (!result.method_7960()) {
            BagContentsComponent.set(stack, builder);
        }
        return result;
    }

    public static int getMaxCountForItem(class_1792 item) {
        if (item == PSItems.BOTTLE || item == PSItems.MOLOTOV_COCKTAIL) {
            return 1;
        }
        return 64000;
    }

    @Override
    public void appendTooltip(class_1836 context, Consumer<class_2561> tooltip) {
        if (this.count > 0) {
            tooltip.accept((class_2561)class_2561.method_43470((String)(this.count() + " x ")).method_10852(this.stack().method_7964()));
        }
    }

    public boolean isEmpty() {
        return this.count <= 0 || this.stack.method_7960();
    }

    public boolean isFull() {
        return this.count <= BagContentsComponent.getMaxCountForItem(this.stack.method_7909());
    }

    public static class Builder {
        private class_1799 stack;
        private int count;

        public Builder(BagContentsComponent contents) {
            this.stack = contents.stack();
            this.count = contents.count();
        }

        public boolean canAdd(class_1799 stack) {
            if (stack.method_7909() instanceof PaperBagItem) {
                return false;
            }
            if (this.stack.method_7960()) {
                return true;
            }
            return (this.stack.method_7960() || class_1799.method_31577((class_1799)this.stack, (class_1799)stack)) && this.count < BagContentsComponent.getMaxCountForItem(stack.method_7909());
        }

        public boolean add(class_1799 stack) {
            if (this.canAdd(stack)) {
                this.stack = stack.method_46651(1);
                this.count += stack.method_7971(BagContentsComponent.getMaxCountForItem(stack.method_7909()) - this.count).method_7947();
                return true;
            }
            return false;
        }

        public class_1799 split(int count) {
            class_1799 dispensed = this.stack.method_46651(Math.min(this.count, count));
            this.count -= dispensed.method_7947();
            return dispensed;
        }

        public BagContentsComponent build() {
            return new BagContentsComponent(this.stack, this.count);
        }
    }
}

