/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.psychedelicraft.item.component.FluidCapacity;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.item.component.PSComponents;
import ivorius.psychedelicraft.item.component.TooltipAppender;
import ivorius.psychedelicraft.recipe.FluidMound;
import ivorius.psychedelicraft.util.compat.PacketCodec;
import ivorius.psychedelicraft.util.compat.PacketCodecs;
import ivorius.psychedelicraft.util.compat.StackCompat;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;

public record ItemFluidsMixture(List<ItemFluids> fluids) implements TooltipAppender
{
    private static final ItemFluidsMixture EMPTY = new ItemFluidsMixture(List.of());
    public static final Codec<ItemFluidsMixture> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemFluids.CODEC.listOf().fieldOf("fluids").forGetter(ItemFluidsMixture::fluids)).apply((Applicative)instance, ItemFluidsMixture::of));
    public static final PacketCodec<class_2540, ItemFluidsMixture> PACKET_CODEC = PacketCodec.tuple(ItemFluids.PACKET_CODEC.collect(PacketCodecs.toList()), ItemFluidsMixture::fluids, ItemFluidsMixture::of);

    public static ItemFluidsMixture of(List<ItemFluids> fluids) {
        return (fluids = ItemFluidsMixture.removeEmpty(fluids)).isEmpty() ? EMPTY : new ItemFluidsMixture(fluids);
    }

    @NotNull
    public static ItemFluidsMixture of(class_1799 stack) {
        ItemFluidsMixture fluids = StackCompat.get(stack, PSComponents.FLUIDS_MIXTURE);
        return fluids == null ? EMPTY : fluids;
    }

    public static class_1799 set(class_1799 stack, List<ItemFluids> fluids) {
        int capacity = FluidCapacity.get(stack);
        if (capacity > 0) {
            ItemFluidsMixture mixture = ItemFluidsMixture.of(fluids);
            if (mixture.fluids.size() < 2) {
                StackCompat.remove(stack, PSComponents.FLUIDS_MIXTURE);
                return ItemFluids.set(stack, mixture.getFirstFluid());
            }
            stack = ItemFluids.getItemForFluids(stack, mixture.getFirstFluid());
            StackCompat.set(stack, PSComponents.FLUIDS_MIXTURE, mixture);
        }
        return stack;
    }

    private static List<ItemFluids> removeEmpty(List<ItemFluids> fluids) {
        return FluidMound.of(fluids).getFluids();
    }

    public boolean isEmpty() {
        return this.fluids.isEmpty();
    }

    public ItemFluids getFirstFluid() {
        return this.isEmpty() ? ItemFluids.EMPTY : this.fluids.get(0);
    }

    @Override
    public void appendTooltip(class_1836 context, Consumer<class_2561> tooltip) {
        if (this.isEmpty()) {
            return;
        }
        int total = this.fluids().stream().mapToInt(ItemFluids::amount).sum();
        tooltip.accept((class_2561)class_2561.method_43471((String)"psychedelicraft.container.mixture").method_27692(class_124.field_1063));
        this.fluids().forEach(fluid -> tooltip.accept((class_2561)class_2561.method_43469((String)"psychedelicraft.container.mixture.fluid", (Object[])new Object[]{ItemFluidsMixture.getPercentage(fluid.amount(), total), fluid.getName()})));
    }

    static int getPercentage(int amount, int total) {
        return class_3532.method_15375((float)(100.0f * ((float)amount / (float)total)));
    }
}

