/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.recipe.PSRecipes;
import ivorius.psychedelicraft.recipe.RecipeUtils;
import ivorius.psychedelicraft.recipe.ingredient.OptionalFluidIngredient;
import ivorius.psychedelicraft.util.PacketCodecUtils;
import ivorius.psychedelicraft.util.compat.IngredientCompat;
import ivorius.psychedelicraft.util.compat.PacketCodec;
import ivorius.psychedelicraft.util.compat.PacketCodecs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1867;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_7710;
import net.minecraft.class_8566;

public class FluidAwareShapelessRecipe
extends class_1867 {
    public static final MapCodec<FluidAwareShapelessRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2960.field_25139.fieldOf("id").forGetter(class_1867::method_8114), (App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(class_1867::method_8112), (App)class_7710.field_40252.fieldOf("category").orElse((Object)class_7710.field_40251).forGetter(class_1867::method_45441), (App)class_1799.field_24671.fieldOf("result").forGetter(recipe -> recipe.output), (App)OptionalFluidIngredient.LIST_CODEC.fieldOf("ingredients").forGetter(recipe -> recipe.ingredients), (App)IngredientCompat.ALLOW_EMPTY_CODEC.optionalFieldOf("destroy", (Object)class_1856.method_35226()).forGetter(recipe -> recipe.destructedIngredient)).apply((Applicative)instance, FluidAwareShapelessRecipe::new));
    public static final PacketCodec<class_2540, FluidAwareShapelessRecipe> PACKET_CODEC = PacketCodec.tuple(PacketCodecs.IDENTIFIER, class_1867::method_8114, PacketCodecs.STRING, class_1867::method_8112, RecipeUtils.CRAFTING_RECIPE_CATEGORY_PACKET_CODEC, class_1867::method_45441, PacketCodecs.ITEM_STACK, recipe -> recipe.output, OptionalFluidIngredient.PACKET_CODEC.collect(PacketCodecUtils.toDefaultedList()), recipe -> recipe.ingredients, PacketCodecs.INGREDIENT, recipe -> recipe.destructedIngredient, FluidAwareShapelessRecipe::new);
    private final class_1799 output;
    private final class_2371<OptionalFluidIngredient> ingredients;
    private final List<OptionalFluidIngredient> consumedFluids;
    private final class_1856 destructedIngredient;

    public FluidAwareShapelessRecipe(class_2960 id, String group, class_7710 category, class_1799 output, class_2371<OptionalFluidIngredient> input, class_1856 destructedIngredient) {
        super(id, group, category, output, input.stream().map(CustomIngredient::toVanilla).collect(Collectors.toCollection(class_2371::method_10211)));
        this.output = output;
        this.ingredients = input;
        this.consumedFluids = this.ingredients.stream().filter(i -> i.fluid().isPresent()).toList();
        this.destructedIngredient = destructedIngredient;
    }

    public class_2371<OptionalFluidIngredient> getFluidAwareIngredients() {
        return this.ingredients;
    }

    public class_1865<?> method_8119() {
        return PSRecipes.CRAFTING_SHAPELESS_FLUID;
    }

    public boolean method_17730(class_8566 inventory, class_1937 world) {
        ArrayList<OptionalFluidIngredient> unmatchedInputs = new ArrayList<OptionalFluidIngredient>((Collection<OptionalFluidIngredient>)this.ingredients);
        long matches = RecipeUtils.stacks((class_1263)inventory).filter(stack -> unmatchedInputs.stream().filter(ingredient -> ingredient.test((class_1799)stack)).findFirst().map(unmatchedInputs::remove).orElse(false)).count();
        return matches == (long)this.ingredients.size() && unmatchedInputs.isEmpty();
    }

    public class_2371<class_1799> getRemainder(class_8566 inventory) {
        class_2371 defaultedList = class_2371.method_10213((int)inventory.method_5439(), (Object)class_1799.field_8037);
        boolean destroyed = false;
        for (int i = 0; i < defaultedList.size(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            ItemFluids.Transaction t = ItemFluids.Transaction.begin(stack);
            if (!t.fluids().isEmpty() && this.consumedFluids.stream().filter(ingredient -> ingredient.test(stack)).map(OptionalFluidIngredient::fluid).flatMap(Optional::stream).anyMatch(fluid -> {
                t.withdraw(fluid.level().orElse(t.fluids().amount()));
                return true;
            })) {
                defaultedList.set(i, (Object)t.toItemStack());
                continue;
            }
            class_1799 remainder = stack.getRecipeRemainder();
            if (remainder.method_7960()) continue;
            if (!destroyed && this.destructedIngredient.method_8093(remainder)) {
                destroyed = true;
                continue;
            }
            defaultedList.set(i, (Object)remainder);
        }
        return defaultedList;
    }
}

