/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.util;

import it.unimi.dsi.fastutil.doubles.Double2DoubleFunction;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import net.minecraft.class_3532;
import net.minecraft.class_5253;
import net.minecraft.class_5819;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public interface MathUtils {
    public static final Vector4f ZERO = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
    public static final Vector4f TEMP_VECTOR = new Vector4f();

    public static float nearValue(float from, float to, float delta, float adjustmentRate) {
        return MathUtils.approach(class_3532.method_16439((float)delta, (float)from, (float)to), to, adjustmentRate);
    }

    public static float approach(float value, float target, float adjustmentRate) {
        if (value > target) {
            return Math.max(value - adjustmentRate, target);
        }
        if (value < target) {
            return Math.min(value + adjustmentRate, target);
        }
        return value;
    }

    public static double nearValue(double from, double to, double delta, double adjustmentRate) {
        return MathUtils.approach(class_3532.method_16436((double)delta, (double)from, (double)to), to, adjustmentRate);
    }

    public static double approach(double value, double target, double adjustmentRate) {
        if (value > target) {
            return Math.max(value - adjustmentRate, target);
        }
        if (value < target) {
            return Math.min(value + adjustmentRate, target);
        }
        return value;
    }

    public static Vector3f unpackRgb(int c) {
        return new Vector3f(MathUtils.r(c), MathUtils.g(c), MathUtils.b(c));
    }

    public static Vector4f unpackArgb(int c) {
        return new Vector4f(MathUtils.a(c), MathUtils.r(c), MathUtils.g(c), MathUtils.b(c));
    }

    public static float a(int c) {
        return (float)class_5253.class_5254.method_27762((int)c) / 255.0f;
    }

    public static float r(int c) {
        return (float)class_5253.class_5254.method_27765((int)c) / 255.0f;
    }

    public static float g(int c) {
        return (float)class_5253.class_5254.method_27766((int)c) / 255.0f;
    }

    public static float b(int c) {
        return (float)class_5253.class_5254.method_27767((int)c) / 255.0f;
    }

    public static int withAlpha(int color, float alpha) {
        return color & 0xFFFFFF | ((int)(alpha * 255.0f) & 0xFF) << 24;
    }

    public static int mixColors(int left, int right, float progress) {
        return class_5253.class_5254.method_27764((int)((int)(class_3532.method_16439((float)MathUtils.a(left), (float)MathUtils.a(right), (float)progress) * 255.0f)), (int)((int)(class_3532.method_16439((float)MathUtils.r(left), (float)MathUtils.r(right), (float)progress) * 255.0f)), (int)((int)(class_3532.method_16439((float)MathUtils.g(left), (float)MathUtils.g(right), (float)progress) * 255.0f)), (int)((int)(class_3532.method_16439((float)MathUtils.b(left), (float)MathUtils.b(right), (float)progress) * 255.0f)));
    }

    @Deprecated
    public static int packArgb(float a, float r, float g, float b) {
        return class_5253.class_5254.method_27764((int)((int)(a * 255.0f)), (int)((int)(r * 255.0f)), (int)((int)(g * 255.0f)), (int)((int)(b * 255.0f)));
    }

    public static Vector4fc mixColorsDynamic(Vector3fc color, Vector4f colorBase, float alpha) {
        if (alpha > 0.0f) {
            float max = alpha + colorBase.w;
            return colorBase.set(class_3532.method_16439((float)(alpha / max), (float)colorBase.x, (float)color.x()), class_3532.method_16439((float)(alpha / max), (float)colorBase.y, (float)color.y()), class_3532.method_16439((float)(alpha / max), (float)colorBase.z, (float)color.z()), class_3532.method_15363((float)max, (float)0.0f, (float)1.0f));
        }
        return colorBase;
    }

    public static Vector3f lerp(float delta, Vector3f a, Vector3fc b) {
        return a.set(class_3532.method_16439((float)delta, (float)a.x(), (float)b.x()), class_3532.method_16439((float)delta, (float)a.y(), (float)b.y()), class_3532.method_16439((float)delta, (float)a.z(), (float)b.z()));
    }

    public static Vector3f lerp(float delta, Vector3fc a, Vector3fc b, Vector3f out) {
        return out.set(class_3532.method_16439((float)delta, (float)a.x(), (float)b.x()), class_3532.method_16439((float)delta, (float)a.y(), (float)b.y()), class_3532.method_16439((float)delta, (float)a.z(), (float)b.z()));
    }

    public static float randomColor(class_5819 random, int ticksExisted, float base, float sway, float ... speed) {
        for (float s : speed) {
            base *= 1.0f + class_3532.method_15374((float)((float)ticksExisted * s)) * sway;
        }
        return base;
    }

    public static float progress(float metric, float delta) {
        return 1.0f - delta / (1.0f + metric);
    }

    public static float progress(float metric) {
        return MathUtils.progress(metric, 1.0f);
    }

    public static float mixEaseInOut(float v1, float v2, float delta) {
        return MathUtils.cubicMix(v1, v1, v2, v2, delta);
    }

    public static float easeZeroToOne(float delta) {
        return MathUtils.cubicMix(0.0f, 0.0f, 1.0f, 1.0f, class_3532.method_15363((float)delta, (float)0.0f, (float)1.0f));
    }

    public static float project(float value, float min, float max) {
        return class_3532.method_15363((float)class_3532.method_37960((float)value, (float)min, (float)max), (float)0.0f, (float)1.0f);
    }

    public static Vector3d cubicMix(Vector3d v1, Vector3d v2, Vector3d v3, Vector3d v4, double delta, Vector3d dest) {
        return dest.set(MathUtils.cubicMix(v1.x, v2.x, v3.x, v4.x, delta), MathUtils.cubicMix(v1.y, v2.y, v3.y, v4.y, delta), MathUtils.cubicMix(v1.z, v2.z, v3.z, v4.z, delta));
    }

    public static float cubicMix(float v1, float v2, float v3, float v4, float delta) {
        return (float)class_3532.method_16438((double)delta, (double)delta, (double)delta, (double)v1, (double)v2, (double)v2, (double)v3, (double)v2, (double)v3, (double)v3, (double)v4);
    }

    public static double cubicMix(double v1, double v2, double v3, double v4, double delta) {
        return class_3532.method_16438((double)delta, (double)delta, (double)delta, (double)v1, (double)v2, (double)v2, (double)v3, (double)v2, (double)v3, (double)v3, (double)v4);
    }

    public static Vector3f apply(Vector3f vector, Float2FloatFunction function) {
        return vector.set(function.get(vector.x), function.get(vector.y), function.get(vector.z));
    }

    public static Vector4f apply(Vector4f vector, Float2FloatFunction function) {
        return vector.set(function.get(vector.x), function.get(vector.y), function.get(vector.z), function.get(vector.w));
    }

    public static Vector3d apply(Vector3d vector, Double2DoubleFunction function) {
        return new Vector3d(function.applyAsDouble(vector.x), function.applyAsDouble(vector.y), function.applyAsDouble(vector.z));
    }
}

