/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.util;

import com.mojang.datafixers.util.Function8;
import io.netty.buffer.ByteBuf;
import ivorius.psychedelicraft.util.compat.PacketCodec;
import ivorius.psychedelicraft.util.compat.PacketCodecs;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_2096;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_6016;
import net.minecraft.class_6017;

public interface PacketCodecUtils {
    public static final PacketCodec<ByteBuf, Optional<Integer>> OPTIONAL_INT = PacketCodecs.optional(PacketCodecs.INTEGER);
    public static final PacketCodec<ByteBuf, Optional<Long>> OPTIONAL_VAR_LONG = PacketCodecs.optional(PacketCodecs.VAR_LONG);
    public static final PacketCodec<ByteBuf, class_2096.class_2100> INT_RANGE = PacketCodec.ofStatic((buffer, range) -> {
        OPTIONAL_INT.encode((ByteBuf)buffer, Optional.ofNullable((Integer)range.method_9038()));
        OPTIONAL_INT.encode((ByteBuf)buffer, Optional.ofNullable((Integer)range.method_9042()));
    }, buffer -> {
        Optional<Integer> min = OPTIONAL_INT.decode((ByteBuf)buffer);
        Optional<Integer> max = OPTIONAL_INT.decode((ByteBuf)buffer);
        if (min.isPresent() && max.isPresent()) {
            return class_2096.class_2100.method_35287((int)min.get(), (int)max.get());
        }
        if (min.isPresent()) {
            return class_2096.class_2100.method_9053((int)min.get());
        }
        if (max.isPresent()) {
            return class_2096.class_2100.method_35289((int)max.get());
        }
        return class_2096.class_2100.field_9708;
    });
    public static final PacketCodec<class_2540, class_6017> INT_PROVIDER_VALUE_CODEC = PacketCodec.ofStatic((buff, t) -> {}, buff -> class_6016.field_29942);

    public static <T extends Enum<T>> PacketCodec<class_2540, T> ofEnum(Class<T> type) {
        return PacketCodec.ofStatic(class_2540::method_10817, b -> b.method_10818(type));
    }

    public static <B extends ByteBuf, V> PacketCodec.ResultFunction<B, V, class_2371<V>> toDefaultedList() {
        return PacketCodecs.toCollection(class_2371::method_37434);
    }

    public static <B extends ByteBuf, C, T1, T2, T3, T4, T5, T6, T7, T8> PacketCodec<B, C> tuple(final PacketCodec<? super B, T1> codec1, final Function<C, T1> from1, final PacketCodec<? super B, T2> codec2, final Function<C, T2> from2, final PacketCodec<? super B, T3> codec3, final Function<C, T3> from3, final PacketCodec<? super B, T4> codec4, final Function<C, T4> from4, final PacketCodec<? super B, T5> codec5, final Function<C, T5> from5, final PacketCodec<? super B, T6> codec6, final Function<C, T6> from6, final PacketCodec<? super B, T7> codec7, final Function<C, T7> from7, final PacketCodec<? super B, T8> codec8, final Function<C, T8> from8, final Function8<T1, T2, T3, T4, T5, T6, T7, T8, C> to) {
        return new PacketCodec<B, C>(){

            @Override
            public C decode(B b) {
                return to.apply(codec1.decode(b), codec2.decode(b), codec3.decode(b), codec4.decode(b), codec5.decode(b), codec6.decode(b), codec7.decode(b), codec8.decode(b));
            }

            @Override
            public void encode(B b, C c) {
                codec1.encode(b, from1.apply(c));
                codec2.encode(b, from2.apply(c));
                codec3.encode(b, from3.apply(c));
                codec4.encode(b, from4.apply(c));
                codec5.encode(b, from5.apply(c));
                codec6.encode(b, from6.apply(c));
                codec7.encode(b, from7.apply(c));
                codec8.encode(b, from8.apply(c));
            }
        };
    }
}

