/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.util.compat;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.EncoderException;
import ivorius.psychedelicraft.util.compat.PacketCodec;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.IntFunction;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2378;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_4615;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.joml.Vector3f;

public interface PacketCodecs {
    public static final PacketCodec<ByteBuf, String> STRING = PacketCodec.ofStatic((buff, s) -> new class_2540(buff).method_10814(s), buff -> new class_2540(buff).method_19772());
    public static final PacketCodec<ByteBuf, Integer> INTEGER = PacketCodec.ofStatic(ByteBuf::writeInt, ByteBuf::readInt);
    public static final PacketCodec<ByteBuf, Float> FLOAT = PacketCodec.ofStatic(ByteBuf::writeFloat, ByteBuf::readFloat);
    public static final PacketCodec<ByteBuf, Double> DOUBLE = PacketCodec.ofStatic(ByteBuf::writeDouble, ByteBuf::readDouble);
    public static final PacketCodec<ByteBuf, Long> VAR_LONG = PacketCodec.ofStatic(ByteBuf::writeLong, ByteBuf::readLong);
    public static final PacketCodec<ByteBuf, Boolean> BOOL = PacketCodec.ofStatic(ByteBuf::writeBoolean, ByteBuf::readBoolean);
    public static final PacketCodec<ByteBuf, Vector3f> VECTOR3F = PacketCodec.tuple(FLOAT, Vector3f::x, FLOAT, Vector3f::y, FLOAT, Vector3f::z, Vector3f::new);
    public static final PacketCodec<class_2540, class_2520> NBT_ELEMENT = PacketCodec.ofStatic((buffer, nbt) -> {
        if (nbt == null) {
            buffer.writeByte(0);
        } else {
            try {
                class_2507.method_10631((class_2520)nbt, (DataOutput)new ByteBufOutputStream((ByteBuf)buffer));
            }
            catch (IOException e) {
                throw new EncoderException((Throwable)e);
            }
        }
    }, buffer -> {
        try {
            ByteBufInputStream input = new ByteBufInputStream((ByteBuf)buffer);
            byte type = input.readByte();
            if (type == 0) {
                return null;
            }
            class_2519.method_39875((DataInput)input);
            return class_4615.method_23265((int)type).method_23262((DataInput)input, 0, class_2505.field_11556);
        }
        catch (IOException e) {
            throw new EncoderException((Throwable)e);
        }
    });
    public static final PacketCodec<ByteBuf, class_2960> IDENTIFIER = STRING.xmap(class_2960::new, class_2960::toString);
    public static final PacketCodec<class_2540, class_1856> INGREDIENT = PacketCodec.ofStatic((buff, i) -> i.method_8088(buff), class_1856::method_8086);
    public static final PacketCodec<class_2540, class_1799> ITEM_STACK = PacketCodec.ofStatic(class_2540::method_10793, class_2540::method_10819);
    public static final PacketCodec<class_2540, Optional<class_1799>> OPTIONAL_ITEM_STACK = PacketCodecs.optional(ITEM_STACK);

    public static <T> PacketCodec<ByteBuf, T> registryValue(class_5321<? extends class_2378<T>> key) {
        return IDENTIFIER.xmap(id -> ((class_2378)class_7923.field_41167.method_29107(key)).method_10223(id), obj -> ((class_2378)class_7923.field_41167.method_29107(key)).method_10221(obj));
    }

    public static <Buff extends ByteBuf, V> PacketCodec<Buff, Optional<V>> optional(PacketCodec<? super Buff, V> valueCodec) {
        return PacketCodec.ofStatic((buffer, value) -> {
            buffer.writeBoolean(value.isPresent());
            if (value.isPresent()) {
                valueCodec.encode(buffer, value.get());
            }
        }, buffer -> buffer.readBoolean() ? Optional.of(valueCodec.decode(buffer)) : Optional.empty());
    }

    public static <B extends ByteBuf, V> PacketCodec.ResultFunction<B, V, List<V>> toList() {
        return PacketCodecs.toCollection(ArrayList::new);
    }

    public static <K, V> PacketCodec<class_2540, Map<K, V>> map(IntFunction<Map<K, V>> maker, PacketCodec<? super class_2540, K> keyCodec, PacketCodec<? super class_2540, V> valueCodec) {
        return PacketCodec.ofStatic((buffer, value) -> buffer.method_34063(value, keyCodec::encode, valueCodec::encode), buffer -> buffer.method_34069(maker, keyCodec::decode, valueCodec::decode));
    }

    public static <Buff extends ByteBuf, T, Result extends Collection<T>> PacketCodec.ResultFunction<Buff, T, Result> toCollection(final IntFunction<Result> factory) {
        return new PacketCodec.ResultFunction<Buff, T, Result>(){

            @Override
            public void encode(Buff buffer, Result value, PacketCodec<? super Buff, T> elementCodec) {
                buffer.writeInt(value.size());
                for (Object t : value) {
                    elementCodec.encode(buffer, t);
                }
            }

            @Override
            public Result decode(Buff buffer, PacketCodec<? super Buff, T> elementCodec) {
                int size = buffer.readInt();
                Collection c = (Collection)factory.apply(size);
                for (int i = 0; i < size; ++i) {
                    c.add(elementCodec.decode(buffer));
                }
                return c;
            }
        };
    }
}

