/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.world.gen.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import ivorius.psychedelicraft.fluid.SimpleFluid;
import ivorius.psychedelicraft.item.component.FluidCapacity;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.world.gen.loot.PSLootFunctionTypes;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_117;
import net.minecraft.class_120;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_44;
import net.minecraft.class_47;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import net.minecraft.class_5658;

public class SetFluidsLootFunction
extends class_120 {
    private final List<SimpleFluid> fluid;
    private final Map<String, class_5658> attributes;

    protected SetFluidsLootFunction(class_5341[] conditions, Collection<SimpleFluid> fluid, Map<String, class_5658> attributes) {
        super(conditions);
        this.fluid = fluid.stream().distinct().toList();
        this.attributes = attributes;
    }

    public class_5339 method_29321() {
        return PSLootFunctionTypes.SET_FLUIDS;
    }

    protected class_1799 method_522(class_1799 stack, class_47 context) {
        ItemFluids fluids = this.fluid.get(context.method_294().method_43048(this.fluid.size())).getDefaultStack(FluidCapacity.get(stack));
        HashMap<String, Integer> atrs = new HashMap<String, Integer>(fluids.attributes());
        this.attributes.forEach((attribute, value) -> atrs.put((String)attribute, value.method_366(context)));
        return ItemFluids.set(stack, fluids.withAttributes(atrs));
    }

    public static Builder builder(SimpleFluid fluid) {
        return SetFluidsLootFunction.builder(Set.of(fluid));
    }

    public static Builder builder(Set<SimpleFluid> fluid) {
        return new Builder(fluid);
    }

    public static class Builder
    extends class_120.class_121<Builder> {
        private final Set<SimpleFluid> fluid;
        private final Map<String, class_5658> attributes = new HashMap<String, class_5658>();

        public Builder(Set<SimpleFluid> fluid) {
            this.fluid = fluid;
        }

        public Builder attribute(SimpleFluid.Attribute<Integer> attribute, class_5658 value) {
            this.attributes.put(attribute.name(), value);
            return this;
        }

        public Builder attribute(SimpleFluid.Attribute<Boolean> attribute, boolean value) {
            this.attributes.put(attribute.name(), (class_5658)class_44.method_32448((float)(value ? 1.0f : 0.0f)));
            return this;
        }

        protected Builder getThisBuilder() {
            return this;
        }

        public class_117 method_515() {
            return new SetFluidsLootFunction(this.method_526(), this.fluid, this.attributes);
        }
    }

    public static class Serializer
    extends class_120.class_123<SetFluidsLootFunction> {
        public void toJson(JsonObject json, SetFluidsLootFunction function, JsonSerializationContext context) {
            super.method_529(json, (class_120)function, context);
            JsonArray fluids = new JsonArray();
            function.fluid.forEach(f -> fluids.add(f.getId().toString()));
            json.add("fluid", (JsonElement)fluids);
            JsonObject attributes = new JsonObject();
            function.attributes.forEach((attribute, value) -> attributes.add(attribute, context.serialize(value)));
            json.add("attributes", (JsonElement)attributes);
        }

        public SetFluidsLootFunction fromJson(JsonObject json, JsonDeserializationContext context, class_5341[] conditions) {
            List<SimpleFluid> fluid = class_3518.method_15261((JsonObject)json, (String)"fluid").asList().stream().map(i -> (SimpleFluid)SimpleFluid.REGISTRY.method_10223(class_2960.method_12829((String)i.getAsString()))).distinct().toList();
            Map<String, class_5658> attributes = class_3518.method_15281((JsonObject)json, (String)"attributes", (JsonObject)new JsonObject()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, i -> (class_5658)context.deserialize((JsonElement)i.getValue(), class_5658.class)));
            return new SetFluidsLootFunction(conditions, fluid, attributes);
        }
    }
}

