/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.block.entity;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import ivorius.psychedelicraft.PSSounds;
import ivorius.psychedelicraft.advancement.PSCriteria;
import ivorius.psychedelicraft.block.PipeInsertable;
import ivorius.psychedelicraft.block.entity.PSBlockEntities;
import ivorius.psychedelicraft.block.entity.SyncedBlockEntity;
import ivorius.psychedelicraft.fluid.container.Resovoir;
import ivorius.psychedelicraft.item.component.Impurities;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.recipe.FluidMound;
import ivorius.psychedelicraft.recipe.HardeningRecipe;
import ivorius.psychedelicraft.recipe.PSRecipes;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3902;
import net.minecraft.class_3913;
import net.minecraft.class_3919;
import net.minecraft.class_8786;

public class TrayBlockEntity
extends SyncedBlockEntity
implements PipeInsertable {
    static final int MAX_CAPACITY = 50;
    private final Resovoir fluid = new Resovoir(50, (tank, level) -> {});
    private FluidMound impurities = FluidMound.of();
    private Impurities cuts = Impurities.EMPTY;
    private boolean dirty;
    private int timeToHarden = -1;
    public final class_3913 propertyDelegate = new class_3919(2);
    private Optional<HardeningRecipe> matchingRecipe = Optional.empty();
    private Optional<class_1799> craftingResult = Optional.empty();

    public TrayBlockEntity(class_2338 pos, class_2680 state) {
        super(PSBlockEntities.TRAY, pos, state);
    }

    public int getLevel() {
        return class_3532.method_15340((int)this.fluid.getContents().amount(), (int)0, (int)50);
    }

    public boolean isHardened() {
        return this.getCraftingResult().isPresent();
    }

    public Optional<class_1799> getCraftingResult() {
        return this.craftingResult;
    }

    public void tick(class_3218 world) {
        if (this.getLevel() >= 50 && !this.isHardened()) {
            if (this.matchingRecipe.isEmpty()) {
                this.matchingRecipe = world.method_8433().method_8132(PSRecipes.TRAY, (class_1263)new HardeningRecipe.Input(world.field_9229, this.fluid.getContents(), this.impurities, this.cuts), (class_1937)world).map(class_8786::comp_1933);
            }
            this.matchingRecipe.ifPresent(recipe -> {
                if (this.timeToHarden < 0) {
                    this.timeToHarden = recipe.hardeningTime();
                }
                if (--this.timeToHarden <= 0) {
                    world.method_8396(null, this.method_11016(), PSSounds.BLOCK_TRAY_HARDEN, class_3419.field_15245, 1.0f, 1.0f);
                    this.craftingResult = Optional.of(recipe.craft(new HardeningRecipe.Input(world.field_9229, this.fluid.getContents(), this.impurities, this.cuts), world.method_30349()));
                    this.impurities = FluidMound.of();
                    this.fluid.clear();
                    this.matchingRecipe = Optional.empty();
                    this.cuts = Impurities.EMPTY;
                    for (class_3222 player : world.method_18467(class_3222.class, class_238.method_30048((class_243)this.method_11016().method_46558(), (double)17.0, (double)17.0, (double)17.0))) {
                        PSCriteria.TRAY_HARDEN.trigger((class_1657)player);
                    }
                } else {
                    world.method_8396(null, this.method_11016(), PSSounds.BLOCK_TRAY_HARDEN, class_3419.field_15245, 0.2f, 1.0f);
                }
                this.dirty = true;
            });
        }
        if (this.dirty) {
            this.method_5431();
            this.dirty = false;
        }
    }

    @Override
    public boolean acceptsConnectionFrom(class_1936 world, class_2680 state, class_2338 pos, class_2680 neighborState, class_2338 neighborPos, class_2350 direction, boolean input) {
        return input && direction == class_2350.field_11036;
    }

    @Override
    public Either<PipeInsertable.PipeFluids, class_3902> tryInsert(class_3218 world, class_2680 state, class_2338 pos, class_2350 direction, PipeInsertable.PipeFluids fluids) {
        if (direction != class_2350.field_11033 || this.isHardened() || this.timeToHarden > 0) {
            return PipeInsertable.reject(fluids);
        }
        FluidMound remainder = FluidMound.of(fluids.fluids());
        PipeInsertable.PipeFluids copy = PipeInsertable.PipeFluids.of(fluids.fluids(), fluids.impurities(), fluids.temperature());
        copy.splitCondensate().getFluids().forEach(fluid -> {
            int maxDeposited;
            int amountDeposited;
            if (this.getLevel() < 50 && this.canAccept(world, (ItemFluids)fluid) && this.fluid.getContents().canCombine((ItemFluids)fluid) && (amountDeposited = this.fluid.deposit((ItemFluids)fluid)) > 0) {
                remainder.remove(fluid.ofAmount(amountDeposited));
                fluid = fluid.ofAmount(fluid.amount() - amountDeposited);
                this.dirty = true;
            }
            if (this.canAcceptImpurity(world, (ItemFluids)fluid) && (maxDeposited = class_3532.method_15340((int)(fluid.amount() - this.impurities.getAmount((ItemFluids)fluid)), (int)0, (int)50)) > 0) {
                fluid = fluid.ofAmount(maxDeposited);
                remainder.remove((ItemFluids)fluid);
                this.impurities.add((ItemFluids)fluid);
                this.dirty = true;
            }
        });
        this.cuts = Impurities.combine(copy.impurities(), this.cuts);
        this.matchingRecipe = Optional.empty();
        if (remainder.isEmpty()) {
            return PipeInsertable.STATUS_ACCEPT_ALL;
        }
        return PipeInsertable.reject(fluids.withFluids(remainder));
    }

    private boolean canAccept(class_3218 world, ItemFluids fluids) {
        return !fluids.isEmpty() && world.method_8433().method_30027(PSRecipes.TRAY).stream().anyMatch(recipe -> ((HardeningRecipe)recipe.comp_1933()).isCoreFluid(fluids));
    }

    private boolean canAcceptImpurity(class_3218 world, ItemFluids fluids) {
        return !fluids.isEmpty() && world.method_8433().method_30027(PSRecipes.TRAY).stream().anyMatch(recipe -> ((HardeningRecipe)recipe.comp_1933()).isCoreFluid(this.fluid.getContents()) && ((HardeningRecipe)recipe.comp_1933()).isValidImpurity(fluids));
    }

    public void method_11007(class_2487 compound) {
        super.method_11007(compound);
        FluidMound.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.impurities).result().ifPresent(nbt -> compound.method_10566("impurities", nbt));
        compound.method_10569("timeToHarden", this.timeToHarden);
        compound.method_10566("fluid", (class_2520)this.fluid.toNbt());
        this.craftingResult.flatMap(s -> class_1799.field_24671.encodeStart((DynamicOps)class_2509.field_11560, s).result()).ifPresent(nbt -> compound.method_10566("craftingResult", nbt));
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        this.impurities = FluidMound.CODEC.decode((DynamicOps)class_2509.field_11560, (Object)compound.method_10580("impurities")).result().map(Pair::getFirst).orElseGet(FluidMound::of);
        this.timeToHarden = compound.method_10550("timeToHarden");
        this.fluid.fromNbt(compound.method_10562("fluid"));
        this.craftingResult = Optional.of(class_1799.method_7915((class_2487)compound.method_10562("craftingResult"))).filter(s -> !s.method_7960());
        this.matchingRecipe = Optional.empty();
    }
}

