/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.block.entity.contents;

import com.mojang.datafixers.util.Either;
import ivorius.psychedelicraft.PSSounds;
import ivorius.psychedelicraft.Psychedelicraft;
import ivorius.psychedelicraft.block.PipeInsertable;
import ivorius.psychedelicraft.block.ShapeUtil;
import ivorius.psychedelicraft.block.entity.BurnerBlockEntity;
import ivorius.psychedelicraft.block.entity.contents.SmallContents;
import ivorius.psychedelicraft.fluid.container.Resovoir;
import ivorius.psychedelicraft.item.component.FluidCapacity;
import ivorius.psychedelicraft.item.component.Impurities;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.item.component.ItemFluidsMixture;
import ivorius.psychedelicraft.recipe.BunsenBurnerRecipe;
import ivorius.psychedelicraft.recipe.FluidMound;
import ivorius.psychedelicraft.recipe.ItemMound;
import ivorius.psychedelicraft.recipe.PSRecipes;
import ivorius.psychedelicraft.util.compat.StackCompat;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3902;
import net.minecraft.class_5328;

public class LargeContents
extends SmallContents {
    public static final class_2960 ID = Psychedelicraft.id("large");
    static final int MAX_INGREDIENTS = 4;
    static final int[] CONTAINER_SLOT_ID = new int[]{0};
    static final int[] INGREDIENT_SLOT_ID = new int[]{1, 2, 3, 4};
    static final class_265 SHAPE = ShapeUtil.createCenteredShape(5.0, 18.0, 5.0);
    private ItemMound ingredients = new ItemMound();

    public LargeContents(BurnerBlockEntity entity, int capacity, class_1799 stack) {
        super(entity, capacity, stack);
    }

    @Override
    public class_265 getOutlineShape() {
        return SHAPE;
    }

    @Override
    protected void loadContents(class_1799 stack) {
        ItemFluids.allOf(stack).forEach(this::deposit);
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    public ItemMound getIngredients() {
        return this.ingredients;
    }

    @Override
    public class_1271<BurnerBlockEntity.Contents> interact(class_1799 stack, class_1657 player, class_1268 hand, class_2350 side) {
        class_1271<BurnerBlockEntity.Contents> result = super.interact(stack, player, hand, side);
        if (result.method_5467().method_23665()) {
            return result;
        }
        if (this.ingredients.size() < 4 && this.ingredients.getCount(stack.method_7909()) < 5 && this.isValidIngredient(stack)) {
            if (!player.method_37908().field_9236) {
                this.ingredients.addStack(StackCompat.splitUnlessCreative(stack, 1, player));
                player.method_6122(hand, stack);
                this.entity.playSound(null, PSSounds.BLOCK_BUNSEN_BURNER_FILL);
            }
            return class_1271.method_22427((Object)this);
        }
        return class_1271.method_22431((Object)this);
    }

    @Override
    protected class_1271<BurnerBlockEntity.Contents> interactWithFluidVessel(class_1799 stack, class_1657 player, class_1268 hand, class_2350 side) {
        ItemFluids.Transaction t;
        Resovoir tank;
        if (!ItemFluids.of(stack).isEmpty()) {
            ItemFluids.Transaction t2 = ItemFluids.Transaction.begin(stack);
            if (this.deposit(t2)) {
                this.entity.playSound(player, class_3417.field_14826);
                if (!player.method_37908().field_9236) {
                    player.method_6122(hand, class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)t2.toItemStack()));
                }
                return class_1271.method_22427((Object)this);
            }
            return class_1271.method_22431((Object)this);
        }
        ItemFluidsMixture mixture = ItemFluidsMixture.of(stack);
        if (!mixture.isEmpty()) {
            if (!player.method_37908().field_9236) {
                player.method_6122(hand, class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)ItemFluidsMixture.set(stack.method_46651(1), mixture.fluids().stream().map(this::deposit).toList())));
            }
            this.entity.playSound(player, class_3417.field_14826);
            return class_1271.method_22427((Object)this);
        }
        Resovoir resovoir = tank = player.method_5715() ? this.getLastTank() : this.getPrimaryTank();
        if (!tank.getContents().isEmpty() && tank.withdraw(t = ItemFluids.Transaction.begin(stack.method_46651(1)), FluidCapacity.get(stack)) > 0) {
            if (!player.method_37908().field_9236) {
                player.method_6122(hand, class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)t.toItemStack()));
            }
            this.entity.playSound(player, class_3417.field_14779);
            return class_1271.method_22427((Object)this);
        }
        return class_1271.method_22431((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean deposit(ItemFluids.Transaction t) {
        List list = this.auxiliaryTanks;
        synchronized (list) {
            Resovoir auxTank;
            int maxToInsert = Math.max(0, this.capacity - this.getTotalFluidVolume());
            int transferred = 0;
            for (Resovoir auxTank2 : this.auxiliaryTanks) {
                transferred = auxTank2.deposit(t, maxToInsert);
                if (transferred <= 0) continue;
                return true;
            }
            if (this.auxiliaryTanks.size() < 4 && (transferred = (auxTank = this.createTank()).deposit(t, maxToInsert)) > 0) {
                this.auxiliaryTanks.add(auxTank);
                this.entity.method_5431();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ItemFluids deposit(ItemFluids stack) {
        List list = this.auxiliaryTanks;
        synchronized (list) {
            Resovoir auxTank;
            if (stack.isEmpty()) {
                return stack;
            }
            int maxToInsert = Math.min(stack.amount(), Math.max(0, this.capacity - this.getTotalFluidVolume()));
            ItemFluids toInsert = stack.ofAmount(maxToInsert);
            int transferred = 0;
            for (Resovoir auxTank2 : this.auxiliaryTanks) {
                transferred = auxTank2.deposit(toInsert);
                if (transferred <= 0) continue;
                return stack.ofAmount(stack.amount() - transferred);
            }
            if (this.auxiliaryTanks.size() < 4 && (transferred = (auxTank = this.createTank()).deposit(toInsert)) > 0) {
                this.auxiliaryTanks.add(auxTank);
                this.entity.method_5431();
                return stack.ofAmount(stack.amount() - transferred);
            }
            return stack;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Either<PipeInsertable.PipeFluids, class_3902> tryInsert(class_3218 world, class_2680 state, class_2338 pos, class_2350 direction, PipeInsertable.PipeFluids fluids) {
        if (direction != class_2350.field_11033) {
            return PipeInsertable.reject(fluids);
        }
        FluidMound mound = FluidMound.of(fluids.fluids());
        List list = this.auxiliaryTanks;
        synchronized (list) {
            fluids.fluids().getFluids().forEach(fluid -> {
                Resovoir auxTank;
                int transferred;
                for (Resovoir auxTank2 : this.auxiliaryTanks) {
                    int transferred2 = auxTank2.deposit((ItemFluids)fluid);
                    if (transferred2 <= 0) continue;
                    mound.remove(fluid.ofAmount(transferred2));
                    return;
                }
                if (this.auxiliaryTanks.size() < 4 && (transferred = (auxTank = this.createTank()).deposit((ItemFluids)fluid)) > 0) {
                    this.auxiliaryTanks.add(auxTank);
                    mound.remove(fluid.ofAmount(transferred));
                    this.entity.method_5431();
                }
            });
        }
        return PipeInsertable.reject(PipeInsertable.PipeFluids.of(mound, fluids.impurities(), fluids.temperature()));
    }

    private boolean isValidIngredient(class_1799 stack) {
        return FluidCapacity.get(stack) == 0 && this.entity.method_10997().method_8433().method_30027(PSRecipes.CHEMISTRY).stream().anyMatch(recipe -> ((BunsenBurnerRecipe)recipe.comp_1933()).method_8117().stream().anyMatch(i -> i.method_8093(stack)));
    }

    @Override
    public ItemMound getCraftingIngredients() {
        return new ItemMound(this.ingredients);
    }

    @Override
    public void onCraft(BunsenBurnerRecipe.Input input) {
        this.ingredients = input.input();
    }

    @Override
    public void produceProducts(class_3218 world, class_2338 pipePos, BunsenBurnerRecipe.Product product) {
        if (!product.items().isEmpty()) {
            this.ingredients.addStack(product.items().remove(0));
        }
        ItemFluids fluid = product.fluids().split(400);
        this.getPrimaryTank().drain(fluid.amount());
        if (!PipeInsertable.tryInsert(world, pipePos, class_2350.field_11036, PipeInsertable.PipeFluids.of(fluid, new Impurities(product.impurities()), 15)).equals((Object)STATUS_ACCEPT_ALL)) {
            this.onFluidWasted(world);
        }
    }

    @Override
    public void method_5448() {
        super.method_5448();
        this.ingredients.clear();
    }

    @Override
    public void toNbt(class_2487 compound) {
        super.toNbt(compound);
        compound.method_10566("ingredients", (class_2520)this.ingredients.toNbt());
    }

    @Override
    public void fromNbt(class_2487 compound) {
        super.fromNbt(compound);
        this.ingredients = new ItemMound(compound.method_10562("ingredients"));
    }

    @Override
    public int[] method_5494(class_2350 side) {
        return INGREDIENT_SLOT_ID;
    }

    @Override
    public boolean method_5492(int slot, class_1799 stack, class_2350 dir) {
        return slot >= 0 && slot < 4;
    }

    @Override
    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return slot >= 0 && slot < 4;
    }

    @Override
    public int method_5439() {
        return 5;
    }

    @Override
    public boolean method_5442() {
        return this.ingredients.isEmpty() && super.method_5442();
    }

    @Override
    public class_1799 method_5438(int slot) {
        if (slot >= this.ingredients.size()) {
            return class_1799.field_8037;
        }
        return this.ingredients.getStack(slot);
    }

    @Override
    public class_1799 method_5434(int slot, int amount) {
        return this.ingredients.removeStack(slot, amount);
    }

    @Override
    public class_1799 method_5441(int slot) {
        return this.ingredients.removeStack(slot, Integer.MAX_VALUE);
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        if (this.ingredients.size() < 4) {
            this.ingredients.addStack(stack);
        }
    }

    @Override
    public List<class_1799> getDroppedStacks(class_1799 container) {
        class_2371<class_1799> stacks = this.ingredients.convertToItemStacks();
        if (!container.method_7960()) {
            stacks.add((Object)container);
        }
        return stacks;
    }
}

