/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client;

import com.google.gson.GsonBuilder;
import com.minelittlepony.common.util.registry.RegistryTypeAdapter;
import com.minelittlepony.common.util.settings.Config;
import com.minelittlepony.common.util.settings.HeirarchicalJsonConfigAdapter;
import com.minelittlepony.common.util.settings.Setting;
import ivorius.psychedelicraft.entity.drug.DrugType;
import java.nio.file.Path;
import net.minecraft.class_3532;
import org.joml.Vector2f;

public class PSClientConfig
extends Config {
    public final Setting<Float> dofFocalPointNear = this.value("visual", "dofFocalPointNear", Float.valueOf(0.2f)).addComment("Sets the distance from the camera of the near focal point when doing depth of field").addComment("Default: 0.2");
    public final Setting<Float> dofFocalBlurNear = this.value("visual", "dofFocalBlurNear", Float.valueOf(0.0f)).addComment("Sets blurring amount at the near focal point").addComment("Default: 0");
    public final Setting<Float> dofFocalPointFar = this.value("visual", "dofFocalPointFar", Float.valueOf(128.0f)).addComment("Sets the distance from the camera of the far focal point when doing depth of field").addComment("Default: 128 (up to render distance)");
    public final Setting<Float> dofFocalBlurFar = this.value("visual", "dofFocalBlurFar", Float.valueOf(0.0f)).addComment("Sets blurring amount at the far focal point").addComment("Default: 0");
    public final Setting<Boolean> shader2DEnabled = this.value("visual", "shader2DEnabled", true).addComment("Enables and disables all 2D (screen) shader effects.").addComment("e.g. Blurring, double vision, sunflare, etc").addComment("Default: true");
    public final Setting<Boolean> shader3DEnabled = this.value("visual", "shader3DEnabled", true).addComment("Enables and disables all 3D (geometric) shader effects.").addComment("e.g. Waves").addComment("Default: true");
    public final Setting<Boolean> doHeatDistortion = this.value("visual", "doHeatDistortion", true).addComment("Sets whether to apply a distortion effect when the player is in arid environments").addComment("Default: true");
    public final Setting<Boolean> doWaterDistortion = this.value("visual", "doWaterDistortion", true).addComment("Sets whether to apply a distortion effect when the player is submerged").addComment("Default: true");
    public final Setting<Boolean> doMotionBlur = this.value("visual", "doMotionBlur", true).addComment("Sets whether drug effects are allowed can cause motion blur effects").addComment("Default: true");
    public final Setting<Float> sunFlareIntensity = this.value("visual", "sunFlareIntensity", Float.valueOf(0.25f)).addComment("Controls the intensity of the sunglare. Set to 0 to disable the sun flare entirely").addComment("Default: 0.25");
    public final Setting<Boolean> waterOverlayEnabled = this.value("visual", "waterOverlayEnabled", true).addComment("Sets whether a water splash effect should appear when the player gets wet or is outside in the rain").addComment("Default: true");
    public final Setting<Boolean> hurtOverlayEnabled = this.value("visual", "hurtOverlayEnabled", true).addComment("Sets whether the edges of the screen flash red whenever the player is hurt").addComment("Default: true");
    public final Setting<Vector2f> digitalEffectPixelRescale = this.value("visual", "digitalEffectPixelRescale", new Vector2f(0.05f, 0.05f)).addComment("Scaling ratio for the zero drug's effect").addComment("Default: {x: 0.05, y: 0.05}");
    private transient float[] digitalEffectPixelRescaleF;
    public final Setting<Boolean> drugsBackgroundMusic = this.value("audio", "drugsBackgroundMusic", true).addComment("Enables and disables background music to play when certain drugs are active.").addComment("Default: True");
    public final Setting<Float> drugsBackgroundMusicThreshold = this.value("audio", "drugsBackgroundMusicThreshold", Float.valueOf(0.01f)).addComment("The threshold value for when background music should start playing. Music only plays if the drug strength is greater than this value").addComment("Default: 0.01").addComment("Minimum: 0.01, Maximum: 1");
    public final Setting<Boolean> irisSupport = this.value("compatibility", "irisSupport", true).addComment("Enables and disables shader injections for iris. Turn this off if you're having troubles").addComment("Default: True");
    public final Setting<Boolean> sodiumSupport = this.value("compatibility", "sodiumSupport", true).addComment("Enables and disables shader injections for sodium. Turn this off if you're having troubles").addComment("Default: True");
    public final Setting<Boolean> exportShaderSources = this.value("debug", "printsShaderSources", false).addComment("Enabled printing of shader vertex and fragment sources for easier debugging").addComment("(May impact performance)").addComment("Default: False");
    public final Setting<Boolean> forceShaderRecompiles = this.value("debug", "forceShaderRecompiles", false).addComment("Forces geometry shaders to be read every time").addComment("(May impact performance)").addComment("Default: False");

    public PSClientConfig(Path path) {
        super((Config.Adapter)new HeirarchicalJsonConfigAdapter(new GsonBuilder().registerTypeAdapter(DrugType.class, (Object)RegistryTypeAdapter.of(DrugType.REGISTRY))), path);
        this.digitalEffectPixelRescale.onChanged(i -> {
            this.digitalEffectPixelRescaleF = null;
        });
    }

    public float[] getDigitalEffectPixelResize() {
        if (this.digitalEffectPixelRescaleF == null) {
            this.digitalEffectPixelRescaleF = new float[]{((Vector2f)this.digitalEffectPixelRescale.get()).x, ((Vector2f)this.digitalEffectPixelRescale.get()).y};
        }
        return this.digitalEffectPixelRescaleF;
    }

    public float getBGMThreshold() {
        return class_3532.method_15363((float)((Float)this.drugsBackgroundMusicThreshold.get()).floatValue(), (float)0.01f, (float)1.0f);
    }
}

