/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.render.shader;

import com.google.gson.JsonSyntaxException;
import com.mojang.logging.LogUtils;
import ivorius.psychedelicraft.Psychedelicraft;
import ivorius.psychedelicraft.client.PSClientConfig;
import ivorius.psychedelicraft.client.PsychedelicraftClient;
import ivorius.psychedelicraft.client.render.DrugRenderer;
import ivorius.psychedelicraft.client.render.GLStateProxy;
import ivorius.psychedelicraft.client.render.RenderPhase;
import ivorius.psychedelicraft.client.render.shader.LoadedShader;
import ivorius.psychedelicraft.client.render.shader.PostEffectRenderer;
import ivorius.psychedelicraft.client.render.shader.ShaderContext;
import ivorius.psychedelicraft.client.render.shader.UniformBinding;
import ivorius.psychedelicraft.entity.drug.Drug;
import ivorius.psychedelicraft.entity.drug.DrugType;
import ivorius.psychedelicraft.entity.drug.hallucination.HallucinationManager;
import ivorius.psychedelicraft.util.MathUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import net.minecraft.class_4013;
import org.joml.Vector4fc;
import org.slf4j.Logger;

public class ShaderLoader
implements class_4013,
IdentifiableResourceReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ShaderLoader POST_EFFECTS = new ShaderLoader(DrugRenderer.INSTANCE.getPostEffects()).addShader("heat_distortion", UniformBinding.start().program("heat_distortion", (setter, tickDelta, screenWidth, screenHeight, pass) -> {
        float water = DrugRenderer.INSTANCE.getEnvironmentalEffects().getWaterDistortion();
        float strength = Math.max(DrugRenderer.INSTANCE.getEnvironmentalEffects().getHeatDistortion(), water);
        if (strength <= 0.0f) {
            return;
        }
        setter.set("pixelSize", 1.0f / (float)screenWidth, 1.0f / (float)screenHeight);
        setter.set("strength", strength);
        setter.set("ticks", ShaderContext.ticks() * (water > 0.0f ? 0.03f : 0.15f));
        pass.run();
    })).addShader("simple_effects", UniformBinding.start().bind((setter, tickDelta, screenWidth, screenHeight, pass) -> {
        setter.set("ticks", ShaderContext.ticks());
        pass.run();
    }).program("simple_effects", (setter, tickDelta, screenWidth, screenHeight, pass) -> {
        HallucinationManager h = ShaderContext.hallucinations();
        if (setter.setIfNonZero("quickColorRotation", h.get(Drug.FAST_COLOR_ROTATION)) | setter.setIfNonZero("slowColorRotation", h.get(Drug.SLOW_COLOR_ROTATION)) | setter.setIfNonZero("desaturation", h.get(Drug.DESATURATION_HALLUCINATION_STRENGTH)) | setter.setIfNonZero("colorIntensification", h.get(Drug.SUPER_SATURATION_HALLUCINATION_STRENGTH)) | setter.setIfNonZero("inversion", h.get(Drug.INVERSION_HALLUCINATION_STRENGTH)) | h.getPulseColor(tickDelta, RenderPhase.current() == RenderPhase.SKY).w() > 0.0f | h.getContrastColorization(tickDelta).w() > 0.0f) {
            pass.run();
        }
    }).program("simple_effects_depth", (setter, tickDelta, screenWidth, screenHeight, pass) -> {
        HallucinationManager h = ShaderContext.hallucinations();
        Vector4fc worldColorization = h.getContrastColorization(tickDelta);
        if (h.get(Drug.FAST_COLOR_ROTATION) > 0.0f | h.get(Drug.SLOW_COLOR_ROTATION) > 0.0f | h.get(Drug.DESATURATION_HALLUCINATION_STRENGTH) > 0.0f | h.get(Drug.SUPER_SATURATION_HALLUCINATION_STRENGTH) > 0.0f | h.get(Drug.INVERSION_HALLUCINATION_STRENGTH) > 0.0f | worldColorization.w() > 0.0f) {
            setter.set("colorSafeMode", GLStateProxy.isColorSafeMode() ? 1.0f : 0.0f);
            setter.set("worldColorization", worldColorization);
            pass.run();
        }
    })).addShader("ps_blur", UniformBinding.start().program("ps_blur", (setter, tickDelta, screenWidth, screenHeight, pass) -> {
        float[] blur = ShaderContext.hallucinations().getBlur();
        if (blur[0] > 0.0f || blur[1] > 0.0f) {
            setter.set("pixelSize", 1.0f / (float)screenWidth, 1.0f / (float)screenHeight);
            setter.set("hBlur", blur[0]);
            setter.set("vBlur", blur[1]);
            setter.set("repeats", (float)class_3532.method_15386((float)Math.max(blur[0], blur[1])));
            pass.run();
        }
    })).addShader("depth_of_field", UniformBinding.start().program("depth_of_field", (setter, tickDelta, screenWidth, screenHeight, pass) -> {
        PSClientConfig config = PsychedelicraftClient.getConfig();
        float zNear = 0.05f;
        float zFar = ShaderContext.viewDistace();
        float focalPointNear = ((Float)config.dofFocalPointNear.get()).floatValue() / zFar;
        float focalPointFar = ((Float)config.dofFocalPointFar.get()).floatValue() / zFar;
        float focalBlurFar = ((Float)config.dofFocalBlurFar.get()).floatValue();
        float focalBlurNear = ((Float)config.dofFocalBlurNear.get()).floatValue();
        setter.set("pixelSize", 1.0f / (float)screenWidth, 1.0f / (float)screenHeight);
        setter.set("focalPointNear", Math.min(focalPointNear, focalPointFar));
        setter.set("focalPointFar", Math.max(focalPointNear, focalPointFar) * 0.9f);
        setter.set("depthRange", zNear, zFar);
        float maxDof = Math.max(focalBlurFar, focalBlurNear);
        for (int n = 0; n < class_3532.method_15386((float)maxDof); ++n) {
            float curBlurNear = class_3532.method_15363((float)(focalBlurNear - (float)n), (float)0.0f, (float)1.0f);
            float curBlurFar = class_3532.method_15363((float)(focalBlurFar - (float)n), (float)0.0f, (float)1.0f);
            if (!(curBlurNear > 0.0f) && !(curBlurFar > 0.0f)) continue;
            setter.set("focalBlurNear", curBlurNear);
            setter.set("focalBlurFar", curBlurFar);
            for (int i = 0; i < 2; ++i) {
                setter.set("vertical", (float)i);
                pass.run();
            }
        }
    })).addShader("ps_bloom", UniformBinding.start().program("ps_bloom", (setter, tickDelta, screenWidth, screenHeight, pass) -> {
        float bloom = ShaderContext.hallucinations().get(Drug.BLOOM_HALLUCINATION_STRENGTH);
        if (bloom > 0.0f) {
            setter.set("pixelSize", 1.0f / (float)screenWidth * 2.0f, 1.0f / (float)screenHeight * 2.0f);
            for (int n = 0; n < class_3532.method_15386((float)bloom); ++n) {
                setter.set("totalAlpha", Math.min(1.0f, bloom - (float)n));
                for (int i = 0; i < 2; ++i) {
                    setter.set("vertical", (float)i);
                    pass.run();
                }
            }
        }
    })).addShader("ps_colored_bloom", UniformBinding.start().program("ps_colored_bloom", (setter, tickDelta, screenWidth, screenHeight, pass) -> {
        Vector4fc color = ShaderContext.hallucinations().getColorBloom(tickDelta, RenderPhase.current() == RenderPhase.SKY);
        if (color.w() <= 0.0f) {
            return;
        }
        setter.set("bloomColor", color.x(), color.y(), color.z());
        setter.set("pixelSize", 1.0f / (float)screenWidth, 1.0f / (float)screenHeight);
        for (int n = 0; n < class_3532.method_15386((float)color.w()); ++n) {
            setter.set("totalAlpha", Math.max(1.0f, color.w() - (float)n));
            for (int i = 0; i < 2; ++i) {
                setter.set("vertical", (float)i);
                pass.run();
            }
        }
    })).addShader("double_vision", UniformBinding.start().program("double_vision", (setter, tickDelta, screenWidth, screenHeight, pass) -> {
        float strength = ShaderContext.modifier(Drug.DOUBLE_VISION);
        if (strength > 0.0f) {
            setter.set("totalAlpha", strength);
            setter.set("distance", class_3532.method_15374((float)(ShaderContext.ticks() / 20.0f)) * 0.05f * strength);
            setter.set("stretch", 1.0f + strength);
            pass.run();
        }
    })).addShader("ps_blur_noise", UniformBinding.start().program("ps_blur_noise", (setter, tickDelta, screenWidth, screenHeight, pass) -> {
        float strength = ShaderContext.drug(DrugType.POWER) * 0.6f;
        if (strength <= 0.0f) {
            return;
        }
        setter.set("pixelSize", 1.0f / (float)screenWidth, 1.0f / (float)screenHeight);
        setter.set("strength", strength);
        setter.set("seed", new Random((long)((double)ShaderContext.ticks() * 1000.0)).nextFloat() * 9.0f + 1.0f);
        pass.run();
    })).addShader("underwater_overlay", UniformBinding.start().program("distortion_map", (setter, tickDelta, screenWidth, screenHeight, pass) -> {
        float strength = DrugRenderer.INSTANCE.getEnvironmentalEffects().getWaterScreenDistortion();
        if (strength > 0.0f) {
            setter.set("totalAlpha", strength);
            setter.set("strength", strength * 0.2f);
            setter.set("texTranslation0", 0.0f, ShaderContext.ticks() * 0.005f);
            setter.set("texTranslation1", 0.5f, ShaderContext.ticks() * 0.007f);
            pass.run();
        }
    })).addShader("digital", UniformBinding.start().program("digital_depth", (setter, tickDelta, screenWidth, screenHeight, pass) -> {
        float digital = ShaderContext.drug(DrugType.ZERO);
        if (digital <= 0.0f) {
            return;
        }
        float[] maxDownscale = PsychedelicraftClient.getConfig().getDigitalEffectPixelResize();
        float downscale = MathUtils.mixEaseInOut(0.0f, 0.95f, Math.min(digital * 3.0f, 1.0f));
        float textProgress = MathUtils.easeZeroToOne((digital - 0.2f) * 5.0f);
        float binaryProgress = MathUtils.easeZeroToOne((digital - 0.8f) * 10.0f);
        setter.set("newResolution", (float)screenWidth * (1.0f + (maxDownscale[0] - 1.0f) * (downscale += digital * 0.05f)), (float)screenHeight * (1.0f + (maxDownscale[1] - 1.0f) * downscale));
        setter.set("totalAlpha", 1.0f);
        setter.set("textProgress", textProgress + binaryProgress);
        setter.set("maxColors", digital > 0.4f ? Math.max(256.0f / ((digital - 0.4f) * 640.0f + 1.0f), 2.0f) : -1.0f);
        setter.set("saturation", 1.0f - MathUtils.easeZeroToOne((digital - 0.6f) * 5.0f));
        setter.set("depthRange", 0.05f, ShaderContext.viewDistace());
        pass.run();
    }));
    private final class_310 client = class_310.method_1551();
    private static final class_2960 ID = Psychedelicraft.id("post_effect_shaders");
    private final Map<class_2960, UniformBinding.Set> activeShaderIds = new HashMap<class_2960, UniformBinding.Set>();
    private final PostEffectRenderer renderer;

    public ShaderLoader(PostEffectRenderer renderer) {
        this.renderer = renderer;
    }

    public ShaderLoader addShader(class_2960 id, UniformBinding.Set bindings) {
        this.activeShaderIds.put(id, bindings);
        return this;
    }

    public ShaderLoader addShader(String id, UniformBinding.Set bindings) {
        return this.addShader(Psychedelicraft.id("shaders/post/" + id + ".json"), bindings);
    }

    public class_2960 getFabricId() {
        return ID;
    }

    public void method_14491(class_3300 manager) {
        this.renderer.onShadersLoaded(this.activeShaderIds.entrySet().stream().map(this::loadShader).filter(Objects::nonNull).toList());
    }

    public LoadedShader loadShader(Map.Entry<class_2960, UniformBinding.Set> entry) {
        try {
            return new LoadedShader(this.client, entry.getKey(), entry.getValue());
        }
        catch (IOException e) {
            LOGGER.warn("Failed to load shader: {}", (Object)entry.getKey(), (Object)e);
        }
        catch (JsonSyntaxException e) {
            LOGGER.warn("Failed to parse shader: {}", (Object)entry.getKey(), (Object)e);
        }
        return null;
    }
}

