/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.command;

import com.google.common.collect.Streams;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import ivorius.psychedelicraft.Psychedelicraft;
import ivorius.psychedelicraft.entity.drug.Drug;
import ivorius.psychedelicraft.entity.drug.DrugProperties;
import ivorius.psychedelicraft.entity.drug.DrugType;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

class DrugCommand {
    private static final class_2960 ALL = Psychedelicraft.id("all");
    public static final SimpleCommandExceptionType INVALID_DRUG_NAME = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.drug.nodrug"));
    private static final SuggestionProvider<class_2168> DRUG_NAME_SUGGESTIONS = (context, builder) -> class_2172.method_9270((Iterable)DrugType.REGISTRY.method_10235(), (SuggestionsBuilder)builder);

    DrugCommand() {
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registries) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"drug").requires(source -> source.method_9259(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9308()).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"lock").then(class_2170.method_9247((String)"all").then(class_2170.method_9244((String)"locked", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> DrugCommand.lockDrugs((CommandContext<class_2168>)ctx, ALL))))).then(class_2170.method_9244((String)"drug", (ArgumentType)class_2232.method_9441()).suggests(DRUG_NAME_SUGGESTIONS).then(class_2170.method_9244((String)"locked", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> DrugCommand.lockDrugs((CommandContext<class_2168>)ctx, class_2232.method_9443((CommandContext)ctx, (String)"drug"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"get").executes(DrugCommand::getAllDrugs)).then(class_2170.method_9244((String)"drug", (ArgumentType)class_2232.method_9441()).suggests(DRUG_NAME_SUGGESTIONS).executes(DrugCommand::getDrugs)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").then(class_2170.method_9247((String)"all").then(class_2170.method_9244((String)"value", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)1.0)).executes(ctx -> DrugCommand.setDrugs((CommandContext<class_2168>)ctx, ALL))))).then(class_2170.method_9244((String)"drug", (ArgumentType)class_2232.method_9441()).suggests(DRUG_NAME_SUGGESTIONS).then(class_2170.method_9244((String)"value", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)1.0)).executes(ctx -> DrugCommand.setDrugs((CommandContext<class_2168>)ctx, class_2232.method_9443((CommandContext)ctx, (String)"drug"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").then(class_2170.method_9247((String)"all").then(class_2170.method_9244((String)"value", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)1.0)).executes(ctx -> DrugCommand.addToDrugs((CommandContext<class_2168>)ctx, ALL))))).then(class_2170.method_9244((String)"drug", (ArgumentType)class_2232.method_9441()).suggests(DRUG_NAME_SUGGESTIONS).then(class_2170.method_9244((String)"value", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)1.0)).executes(ctx -> DrugCommand.addToDrugs((CommandContext<class_2168>)ctx, class_2232.method_9443((CommandContext)ctx, (String)"drug"))))))));
    }

    private static int getAllDrugs(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = class_2186.method_9315(context, (String)"target");
        DrugProperties properties = DrugProperties.of((class_1657)player);
        List<Drug> drugs = properties.getAllDrugs().stream().filter(drug -> drug.getActiveValue() > 0.0).toList();
        if (drugs.isEmpty()) {
            source.method_9226(() -> class_2561.method_43469((String)"commands.drug.success.get.sober", (Object[])new Object[]{player.method_5477()}), true);
        } else {
            source.method_9226(() -> class_2561.method_43469((String)"commands.drug.success.get", (Object[])new Object[]{player.method_5477(), drugs.size()}), true);
            drugs.forEach(drug -> {
                double value = drug.getActiveValue();
                source.method_9226(() -> class_2561.method_43470((String)(DrugType.REGISTRY.method_10221(drug.getType()).method_12832() + ": " + value)), true);
            });
        }
        return 0;
    }

    private static int getDrugs(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = class_2186.method_9315(context, (String)"target");
        class_2960 drugName = class_2232.method_9443(context, (String)"drug");
        DrugProperties properties = DrugProperties.of((class_1657)player);
        DrugType.REGISTRY.method_17966(drugName).ifPresentOrElse(drugType -> {
            float value = properties.isDrugActive((DrugType<?>)drugType) ? properties.getDrugValue((DrugType<?>)drugType) : 0.0f;
            source.method_9226(() -> class_2561.method_43469((String)("commands.drug.success.get." + (player == source.method_9228() ? "self" : "other")), (Object[])new Object[]{player.method_5477(), drugName.method_12832(), Float.valueOf(value)}), true);
        }, () -> source.method_9226(() -> class_2561.method_43469((String)"commands.drug.fail.get", (Object[])new Object[]{drugName}), true));
        return 0;
    }

    private static int lockDrugs(CommandContext<class_2168> context, class_2960 drugName) throws CommandSyntaxException {
        boolean locked = BoolArgumentType.getBool(context, (String)"locked");
        DrugCommand.applyDrugChange(context, drugName, (properties, type) -> properties.getDrug(type).setLocked(locked), (player, type) -> {
            if (type == UpdateType.NONE) {
                DrugCommand.sendFeedback((class_2168)context.getSource(), player, false, "none", drugName);
            } else if (type == UpdateType.ALL) {
                DrugCommand.sendFeedback((class_2168)context.getSource(), player, true, (locked ? "lock" : "unlock") + ".all", new Object[0]);
            } else {
                DrugCommand.sendFeedback((class_2168)context.getSource(), player, true, locked ? "lock" : "unlock", drugName);
            }
        });
        return 0;
    }

    private static int setDrugs(CommandContext<class_2168> context, class_2960 drugName) throws CommandSyntaxException {
        double value = DoubleArgumentType.getDouble(context, (String)"value");
        DrugCommand.applyDrugChange(context, drugName, (properties, type) -> properties.setDrugValue((DrugType<?>)type, value), (player, type) -> {
            if (type == UpdateType.NONE) {
                DrugCommand.sendFeedback((class_2168)context.getSource(), player, false, "set", drugName);
            } else if (type == UpdateType.ALL) {
                DrugCommand.sendFeedback((class_2168)context.getSource(), player, true, "set.all", value);
            } else {
                DrugCommand.sendFeedback((class_2168)context.getSource(), player, true, "set", drugName.method_12832(), value);
            }
        });
        return 0;
    }

    private static int addToDrugs(CommandContext<class_2168> context, class_2960 drugName) throws CommandSyntaxException {
        double value = DoubleArgumentType.getDouble(context, (String)"value");
        DrugCommand.applyDrugChange(context, drugName, (properties, type) -> properties.addToDrug((DrugType<?>)type, value), (player, type) -> {
            if (type == UpdateType.NONE) {
                DrugCommand.sendFeedback((class_2168)context.getSource(), player, false, "add", drugName);
            } else if (type == UpdateType.ALL) {
                DrugCommand.sendFeedback((class_2168)context.getSource(), player, true, "add.all", value);
            } else {
                DrugCommand.sendFeedback((class_2168)context.getSource(), player, true, "add", drugName.method_12832(), value);
            }
        });
        return 0;
    }

    static void applyDrugChange(CommandContext<class_2168> context, class_2960 drugName, BiConsumer<DrugProperties, DrugType<?>> change, FeedbackConsumer feedback) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(context, (String)"target");
        DrugProperties properties = DrugProperties.of((class_1657)player);
        if ("all".equals(drugName.method_12832())) {
            DrugType.REGISTRY.forEach(type -> change.accept(properties, (DrugType<?>)type));
            feedback.accept(player, UpdateType.ALL);
        } else {
            DrugType.REGISTRY.method_17966(drugName).ifPresentOrElse(type -> {
                change.accept(properties, (DrugType<?>)type);
                feedback.accept(player, UpdateType.ONE);
            }, () -> feedback.accept(player, UpdateType.NONE));
        }
        properties.markDirty();
    }

    private static void sendFeedback(class_2168 source, class_3222 player, boolean succeeded, String key, Object ... arguments) {
        if (source.method_9228() == player) {
            source.method_9226(() -> class_2561.method_43469((String)("commands.drug." + (succeeded ? "success" : "fail") + "." + key + ".self"), (Object[])arguments), true);
        } else {
            if (succeeded && source.method_9225().method_8450().method_8355(class_1928.field_19400)) {
                player.method_43496((class_2561)class_2561.method_43469((String)("commands.drug." + key + ".changed"), (Object[])arguments));
            }
            source.method_9226(() -> class_2561.method_43469((String)("commands.drug." + (succeeded ? "success" : "fail") + "." + key + ".other"), (Object[])Streams.concat((Stream[])new Stream[]{Stream.of(player.method_5476()), Arrays.stream(arguments)}).toArray()), true);
        }
    }

    static interface FeedbackConsumer {
        public void accept(class_3222 var1, UpdateType var2);
    }

    static enum UpdateType {
        ALL,
        ONE,
        NONE;

    }
}

