/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.entity.drug;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.sollace.fabwork.api.packets.Packet;
import ivorius.psychedelicraft.PSDamageTypes;
import ivorius.psychedelicraft.PSSounds;
import ivorius.psychedelicraft.ParticleHelper;
import ivorius.psychedelicraft.Psychedelicraft;
import ivorius.psychedelicraft.advancement.PSCriteria;
import ivorius.psychedelicraft.block.PSBlocks;
import ivorius.psychedelicraft.entity.LivingEntityDuck;
import ivorius.psychedelicraft.entity.RealityRiftEntity;
import ivorius.psychedelicraft.entity.drug.Attribute;
import ivorius.psychedelicraft.entity.drug.Drug;
import ivorius.psychedelicraft.entity.drug.DrugPropertiesContainer;
import ivorius.psychedelicraft.entity.drug.DrugType;
import ivorius.psychedelicraft.entity.drug.Stomach;
import ivorius.psychedelicraft.entity.drug.hallucination.HallucinationManager;
import ivorius.psychedelicraft.entity.drug.influence.DrugInfluence;
import ivorius.psychedelicraft.entity.drug.influence.DrugInfluenceInstance;
import ivorius.psychedelicraft.entity.drug.sound.DrugMusicManager;
import ivorius.psychedelicraft.entity.effect.PSEffects;
import ivorius.psychedelicraft.item.PacifierItem;
import ivorius.psychedelicraft.network.Channel;
import ivorius.psychedelicraft.network.MsgDrugProperties;
import ivorius.psychedelicraft.particle.DrugDustParticleEffect;
import ivorius.psychedelicraft.particle.PSParticles;
import ivorius.psychedelicraft.util.NbtSerialisable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_8110;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class DrugProperties
implements NbtSerialisable {
    public static final UUID DRUG_EFFECT = UUID.fromString("2da054e7-0fe0-4fb4-bf2c-a185a5f72aa1");
    public static final int MAX_CARDIAC_ARREST_TIME = 2000;
    public static final int RECOVERY_COOLDOWN = 20;
    private static final Codec<Map<DrugType<?>, Drug>> DRUGS_CODEC = Codec.unboundedMap((Codec)DrugType.REGISTRY.method_39673(), Drug.CODEC);
    private final Map<DrugType<?>, Drug> drugs = DrugType.REGISTRY.method_10220().collect(Collectors.toMap(Function.identity(), DrugType::create));
    private final List<DrugInfluenceInstance> influences = new ArrayList<DrugInfluenceInstance>();
    private boolean initial;
    private boolean dirty;
    private final HallucinationManager hallucinations = new HallucinationManager(this);
    private final DrugMusicManager soundManager = new DrugMusicManager(this);
    private int timeBreathingSmoke;
    @Nullable
    private Vector3f breathSmokeColor;
    private final class_1657 entity;
    private final Stomach stomach;
    private float teethGrindingRate;
    private int pacifierSqueakDelay = -1;
    private int cancerCountdown = -1;
    private boolean prevHadCancer = false;
    private int prevCardiacArrestTicks;
    private int cardiacArrestTicks;
    private int cardiacArrestRegenCooldown;
    private int strokeIntensity;
    private int strokeRecoveryCooldown;

    public DrugProperties(class_1657 entity) {
        this.entity = entity;
        this.stomach = new Stomach(this);
    }

    public static DrugProperties of(class_1657 player) {
        return ((DrugPropertiesContainer)player).getDrugProperties();
    }

    public static Stream<DrugProperties> stream(class_1297 entity) {
        if (entity instanceof DrugPropertiesContainer) {
            DrugPropertiesContainer c = (DrugPropertiesContainer)entity;
            return Stream.of(c.getDrugProperties());
        }
        return Stream.empty();
    }

    public static Optional<DrugProperties> of(class_1297 entity) {
        if (entity instanceof DrugPropertiesContainer) {
            DrugPropertiesContainer c = (DrugPropertiesContainer)entity;
            return Optional.of(c.getDrugProperties());
        }
        return Optional.empty();
    }

    public class_1657 asEntity() {
        return this.entity;
    }

    public class_1282 damageOf(class_5321<class_8110> type) {
        return PSDamageTypes.create(this.entity.method_37908(), type);
    }

    public Stomach getStomach() {
        return this.stomach;
    }

    public void markDirty() {
        this.dirty = true;
    }

    public HallucinationManager getHallucinations() {
        return this.hallucinations;
    }

    public DrugMusicManager getMusicManager() {
        return this.soundManager;
    }

    public <T extends Drug> T getDrug(DrugType<T> type) {
        return (T)this.drugs.computeIfAbsent(type, DrugType::create);
    }

    public float getDrugValue(DrugType<?> type) {
        return (float)this.getDrug(type).getActiveValue();
    }

    public boolean isDrugActive(DrugType<?> type) {
        return this.getDrugValue(type) > 1.0E-5f;
    }

    public boolean isTripping() {
        float f = this.getModifier(Drug.MOVEMENT_HALLUCINATION_STRENGTH) + this.getModifier(Drug.CONTEXTUAL_HALLUCINATION_STRENGTH) + this.getModifier(Drug.COLOR_HALLUCINATION_STRENGTH);
        return f > 0.7f;
    }

    public void addToDrug(DrugType<?> type, double effect) {
        this.getDrug(type).addToDesiredValue(effect);
        PSCriteria.DRUG_EFFECTS_CHANGED.trigger(this);
        this.markDirty();
    }

    public void addToDrug(DrugType<?> type, double effect, DrugInfluenceInstance influence) {
        this.getDrug(type).addToDesiredValue(effect, influence);
        PSCriteria.DRUG_EFFECTS_CHANGED.trigger(this);
        this.markDirty();
    }

    public void setDrugValue(DrugType<?> type, double effect) {
        this.getDrug(type).setDesiredValue(effect);
        PSCriteria.DRUG_EFFECTS_CHANGED.trigger(this);
        this.markDirty();
    }

    public void addToDrug(DrugInfluence influence) {
        this.influences.add(new DrugInfluenceInstance(influence));
        this.markDirty();
    }

    public void addAll(Iterable<DrugInfluence> influences) {
        influences.forEach(influence -> this.influences.add(new DrugInfluenceInstance((DrugInfluence)influence)));
        this.markDirty();
    }

    public Collection<Drug> getAllDrugs() {
        return this.drugs.values();
    }

    public Set<DrugType<?>> getAllDrugNames() {
        return this.drugs.keySet();
    }

    public void startBreathingSmoke(int time, Vector3f color) {
        this.breathSmokeColor = color;
        this.timeBreathingSmoke = time + 10;
        this.markDirty();
        this.entity.method_37908().method_43129(this.entity, (class_1297)this.entity, PSSounds.ENTITY_PLAYER_BREATH, class_3419.field_15248, 0.02f, 1.5f);
    }

    public boolean cureAll() {
        boolean changed = this.cancerCountdown != -1 || this.teethGrindingRate > 0.0f || this.breathSmokeColor != null || this.timeBreathingSmoke != 0 || this.pacifierSqueakDelay != -1 || this.cardiacArrestTicks != 0 || this.strokeIntensity != 0 || this.influences.stream().anyMatch(i -> !i.isOf(DrugType.SUGAR) && i.isOf(DrugType.SLEEP_DEPRIVATION)) || this.drugs.values().stream().anyMatch(i -> i.getType() != DrugType.SUGAR && i.getType() != DrugType.SLEEP_DEPRIVATION && i.getActiveValue() > 0.1);
        this.cancerCountdown = -1;
        this.teethGrindingRate = 0.0f;
        this.breathSmokeColor = null;
        this.timeBreathingSmoke = 0;
        this.pacifierSqueakDelay = -1;
        this.prevCardiacArrestTicks = 0;
        this.cardiacArrestTicks = 0;
        this.cardiacArrestRegenCooldown = 0;
        this.strokeIntensity = 0;
        this.strokeRecoveryCooldown = 0;
        this.influences.clear();
        this.drugs.values().forEach(i -> i.setDesiredValue(0.0));
        this.markDirty();
        return changed |= this.stomach.reset();
    }

    public boolean hasCancer() {
        return this.cancerCountdown > -1;
    }

    public float getCancerProgression() {
        return !this.hasCancer() || this.cancerCountdown >= 10000 ? 0.0f : 1.0f - (float)this.cancerCountdown / 10000.0f;
    }

    public boolean rollCancerDance() {
        if (this.entity.method_37908().field_9236) {
            return false;
        }
        if (this.cancerCountdown < 0) {
            if (this.entity.method_37908().field_9229.method_43048(1000000000) == 0) {
                this.cancerCountdown = 10000 + this.entity.method_37908().field_9229.method_43048(1000);
                this.markDirty();
                PSCriteria.CANCER.trigger(this.entity);
                return true;
            }
        } else {
            this.cancerCountdown = Math.max(10, -1 - this.entity.method_37908().field_9229.method_43048(10));
            this.markDirty();
        }
        return false;
    }

    public void increaseTeethGrindingSideEffect() {
        if (this.entity.field_6012 % 10 == 0) {
            this.teethGrindingRate = class_3532.method_15363((float)(this.teethGrindingRate + 0.001f), (float)0.0f, (float)100.0f);
        }
    }

    public void increaseCardiacArrestSideEffect() {
        ++this.cardiacArrestTicks;
        this.cardiacArrestRegenCooldown = 20;
        this.markDirty();
    }

    public float getCardiacArrestProgress(float delta) {
        return class_3532.method_15363((float)(class_3532.method_16439((float)delta, (float)this.prevCardiacArrestTicks, (float)this.cardiacArrestTicks) / 2000.0f), (float)0.0f, (float)1.0f);
    }

    public boolean rollStroke() {
        if (this.getCardiacArrestProgress(1.0f) > 0.25f) {
            return false;
        }
        int baseDamage = 1;
        ++this.strokeIntensity;
        this.strokeRecoveryCooldown = 20;
        PSDamageTypes.damage(this.entity.method_37908(), (class_1297)this.entity, this.damageOf(PSDamageTypes.STROKE), Math.min(baseDamage + this.strokeIntensity, 10));
        return this.entity.method_29504();
    }

    public boolean isBreathingSmoke() {
        return this.timeBreathingSmoke > 0;
    }

    public int getAge() {
        return this.entity.field_6012;
    }

    public void onTick() {
        if (this.entity.field_6012 % 5 == 0 && this.influences.removeIf(influence -> influence.update(this))) {
            this.markDirty();
        }
        if (this.strokeRecoveryCooldown > 0 && --this.strokeRecoveryCooldown <= 0) {
            this.strokeIntensity = 0;
        }
        if (this.cancerCountdown >= 0 && this.cancerCountdown <= 10 && --this.cancerCountdown == 0) {
            this.prevHadCancer = false;
            this.cancerCountdown = -1;
            PSDamageTypes.damage(this.entity.method_37908(), (class_1297)this.entity, this.damageOf(PSDamageTypes.CANCER), 2.1474836E9f);
        }
        this.prevCardiacArrestTicks = this.cardiacArrestTicks;
        if (this.getModifier(Drug.HEART_BEAT_SPEED) <= 0.5f) {
            int tries = 10 + this.entity.method_37908().field_9229.method_43048(50);
            for (int i = 0; i < tries; ++i) {
                if (this.entity.method_37908().field_9229.method_43048(2) != 0) continue;
                this.increaseCardiacArrestSideEffect();
            }
        } else if (this.cardiacArrestTicks > 0 && this.getModifier(Drug.HEART_BEAT_SPEED) > 0.8f && this.getModifier(Drug.HEART_BEAT_SPEED) < 2.8f) {
            this.cardiacArrestTicks = (int)((float)this.cardiacArrestTicks * 0.5f);
        }
        if (this.cardiacArrestTicks > 0 && (this.cardiacArrestRegenCooldown <= 0 || --this.cardiacArrestRegenCooldown <= 0)) {
            --this.cardiacArrestTicks;
        }
        this.drugs.values().forEach(drug -> drug.update(this));
        this.stomach.onTick();
        this.soundManager.update();
        class_5819 random = this.entity.method_6051();
        if (this.entity.method_37908().field_9236) {
            this.hallucinations.update();
            if (this.entity.method_24828() && random.method_43057() < this.getModifier(Drug.JUMP_CHANCE)) {
                ((LivingEntityDuck)this.entity).invokeJump();
            }
            if (!this.entity.field_6252 && random.method_43057() < this.getModifier(Drug.PUNCH_CHANCE)) {
                this.entity.method_6104(class_1268.field_5808);
            }
        } else {
            if (random.method_43057() < this.getModifier(Drug.DROWSYNESS)) {
                this.entity.method_7322(0.05f);
            }
            if (!this.entity.method_6059((class_1291)PSEffects.TEETH_GRINDING.comp_349()) && this.getDrugValue(DrugType.METHAMPHETAMINE) <= 0.001f && this.teethGrindingRate > 1.0f && this.entity.field_6012 % 200 == 0) {
                float f = random.method_43057();
                int n = this.entity.method_6113() ? 2 : 1;
                if (f * (float)n < this.teethGrindingRate / 100.0f) {
                    PSCriteria.SIDE_EFFECT.trigger(this.entity);
                    this.entity.method_6092(new class_1293((class_1291)PSEffects.TEETH_GRINDING.comp_349(), 1000));
                    if (!PacifierItem.consumePacifier((class_1309)this.entity)) {
                        this.teethGrindingRate = Math.max(0.0f, this.teethGrindingRate - 1.0E-5f);
                        this.entity.method_5643(this.damageOf(PSDamageTypes.TEETH_GRINDING), 1.0f);
                    } else {
                        this.pacifierSqueakDelay = 5 + this.entity.method_6051().method_43048(15);
                        this.entity.method_37908().method_43128(null, this.entity.method_23317(), this.entity.method_23318(), this.entity.method_23321(), PSSounds.ENTITY_PLAYER_PACIFIER_SQUEAK, this.entity.method_5634(), (float)this.entity.method_6051().method_43385(1.0, (double)0.2f), (float)this.entity.method_6051().method_43385(1.0, (double)0.2f));
                        this.entity.method_37908().method_33596((class_1297)this.entity, class_5712.field_28164, this.entity.method_24515());
                        PSCriteria.SUCK_PACIFIER.trigger(this.entity);
                    }
                }
            }
            if (this.pacifierSqueakDelay > 0 && --this.pacifierSqueakDelay == 0) {
                this.entity.method_37908().method_43128(null, this.entity.method_23317(), this.entity.method_23318(), this.entity.method_23321(), PSSounds.ENTITY_PLAYER_PACIFIER_SQUEAK, this.entity.method_5634(), (float)this.entity.method_6051().method_43385(1.0, (double)0.2f), (float)this.entity.method_6051().method_43385(1.0, (double)0.2f));
                this.entity.method_37908().method_33596((class_1297)this.entity, class_5712.field_28164, this.entity.method_24515());
            }
            if (this.entity.method_5809()) {
                class_2338 headPos = class_2338.method_49638((class_2374)this.entity.method_33571());
                if (this.entity.method_37908().method_8320(headPos).method_27852(PSBlocks.FLAMMABLE_GAS)) {
                    this.entity.method_37908().method_8501(headPos, class_2246.field_10036.method_9564());
                }
            }
            if ((Integer)Psychedelicraft.getConfig().randomTicksUntilRiftSpawn.get() > 0 && random.method_43048(((Integer)Psychedelicraft.getConfig().randomTicksUntilRiftSpawn.get()).intValue()) == 0) {
                RealityRiftEntity.spawn((class_1297)this.entity);
            }
            if (this.cardiacArrestTicks > 2000) {
                PSCriteria.HEART_ATTACK.trigger(this.entity);
                if (random.method_43048(200) == 0 || this.entity.method_6113()) {
                    this.cardiacArrestTicks = 0;
                    PSDamageTypes.damage(this.entity.method_37908(), (class_1297)this.entity, this.damageOf(PSDamageTypes.HEART_ATTACK), 2.1474836E9f);
                }
            }
        }
        if (this.entity.method_5805()) {
            if (this.prevHadCancer && !this.hasCancer()) {
                PSCriteria.CURE_CANCER.trigger(this.entity);
            }
            this.prevHadCancer = this.hasCancer();
        } else {
            this.prevHadCancer = false;
        }
        if (this.isBreathingSmoke()) {
            --this.timeBreathingSmoke;
            if (this.timeBreathingSmoke > 10 && this.entity.method_37908().field_9236) {
                if (random.method_43048(2) == 0) {
                    ParticleHelper.spawnParticleAtFace((class_1297)this.entity, (class_2394)new DrugDustParticleEffect(PSParticles.EXHALED_SMOKE, this.breathSmokeColor, 1.0f), random.method_43057() * 0.05f + 0.1f);
                }
                if (random.method_43048(5) == 0) {
                    ParticleHelper.spawnParticleAtFace((class_1297)this.entity, (class_2394)new DrugDustParticleEffect(PSParticles.EXHALED_SMOKE, this.breathSmokeColor, 2.5f), random.method_43057() * 0.05f + 0.1f);
                }
            }
        }
        float speed = this.getModifier(Drug.SPEED) - this.getCardiacArrestProgress(1.0f) * 0.25f;
        this.changeDrugModifierMultiply((class_1309)this.entity, class_5134.field_23719, speed);
        this.changeDrugModifierMultiply((class_1309)this.entity, class_5134.field_23723, speed);
        if (this.hasCancer() && this.entity.field_6012 % 10 == 0) {
            float progression = this.getCancerProgression();
            float saturation = this.entity.method_7344().method_7589();
            this.entity.method_7344().method_7581(saturation * (1.0f - progression));
            this.entity.method_7322(progression);
        }
        if (this.dirty) {
            this.dirty = false;
            this.sendCapabilities();
        }
    }

    public void sendCapabilities() {
        if (!this.entity.method_37908().field_9236) {
            MsgDrugProperties message = new MsgDrugProperties(this);
            Channel.UPDATE_DRUG_PROPERTIES.sendToSurroundingPlayers((Packet)message, (class_1297)this.entity);
            Channel.UPDATE_DRUG_PROPERTIES.sendToPlayer((Packet)message, (class_3222)this.entity);
        }
    }

    public class_2487 toTrackedNbt(class_2487 compound) {
        this.dirty = false;
        DRUGS_CODEC.encodeStart((DynamicOps)class_2509.field_11560, this.drugs).result().ifPresent(drugs -> compound.method_10566("Drugs", drugs));
        DrugInfluenceInstance.LIST_CODEC.encodeStart((DynamicOps)class_2509.field_11560, this.influences).result().ifPresent(influenceTagList -> compound.method_10566("drugInfluences", influenceTagList));
        compound.method_10566("stomach", (class_2520)this.stomach.toNbt());
        compound.method_10569("cancerCountdown", this.cancerCountdown);
        compound.method_10548("teethGrindingRate", this.teethGrindingRate);
        if (this.initial) {
            compound.method_10566("soundManager", (class_2520)this.soundManager.toNbt());
            this.initial = false;
        }
        return compound;
    }

    public void fromTrackedNbt(class_2487 compound) {
        this.dirty = false;
        this.drugs.clear();
        DRUGS_CODEC.decode((DynamicOps)class_2509.field_11560, (Object)compound.method_10562("Drugs")).result().map(Pair::getFirst).ifPresent(this.drugs::putAll);
        this.influences.clear();
        DrugInfluenceInstance.LIST_CODEC.decode((DynamicOps)class_2509.field_11560, (Object)compound.method_10554("drugInfluences", 10)).result().map(Pair::getFirst).ifPresent(this.influences::addAll);
        this.stomach.fromNbt(compound.method_10562("stomach"));
        this.cancerCountdown = compound.method_10573("cancerCountdown", 3) ? compound.method_10550("cancerCountdown") : -1;
        this.teethGrindingRate = compound.method_10583("teethGrindingRate");
        if (compound.method_10573("soundManager", 10)) {
            this.soundManager.fromNbt(compound.method_10562("soundManager"));
        }
    }

    @Override
    public void fromNbt(class_2487 compound) {
        this.fromTrackedNbt(compound);
        this.initial = true;
    }

    @Override
    public void toNbt(class_2487 compound) {
        this.toTrackedNbt(compound);
    }

    public void copyFrom(DrugProperties old, boolean alive) {
        if (alive) {
            this.influences.clear();
            this.influences.addAll(old.influences);
            this.drugs.clear();
            this.drugs.putAll(old.drugs);
            this.timeBreathingSmoke = old.timeBreathingSmoke;
            this.breathSmokeColor = old.breathSmokeColor;
            this.teethGrindingRate = old.teethGrindingRate;
            this.pacifierSqueakDelay = old.pacifierSqueakDelay;
            this.cancerCountdown = old.cancerCountdown;
            this.prevHadCancer = old.prevHadCancer;
        } else {
            this.cancerCountdown = -1;
            this.prevHadCancer = false;
            this.initial = true;
        }
        this.soundManager.copyFrom(old.soundManager, alive);
        this.stomach.copyFrom(old.getStomach(), alive);
        this.markDirty();
    }

    public boolean onAwoken() {
        this.drugs.values().forEach(drug -> drug.onWakeUp(this));
        this.influences.clear();
        this.stomach.reset();
        this.markDirty();
        return true;
    }

    public boolean canResetTimeBySleeping(boolean passedBaseCheck) {
        if (this.getSleepTimeModifier() > 1.0f) {
            return passedBaseCheck && this.entity.method_7297() >= 100;
        }
        return this.entity.method_6113() && this.entity.method_7297() >= 100;
    }

    public int getSleepTimer(int sleepTime) {
        return Math.min(class_3532.method_15386((float)((float)sleepTime / this.getSleepTimeModifier())), 100);
    }

    private float getSleepTimeModifier() {
        return 1.0f + class_3532.method_15363((float)((this.getDrugValue(DrugType.CAFFEINE) + this.getDrugValue(DrugType.COCAINE)) / 2.0f), (float)0.0f, (float)1.0f) - this.getDrugValue(DrugType.ALCOHOL) * 0.9f;
    }

    public float onDamaged(class_1282 source, float initial) {
        if (source.method_49708(class_8111.field_42347) || initial >= 2.1474836E9f) {
            return initial;
        }
        initial *= this.getModifier(Drug.PAIN_SUPPRESSION);
        if (this.hasCancer()) {
            initial *= 1.0f + this.getCancerProgression();
        }
        return initial;
    }

    public Optional<class_2561> trySleep(class_2338 pos) {
        return this.getAllDrugs().stream().flatMap(drug -> drug.trySleep(pos).stream()).findFirst();
    }

    public float getModifier(Attribute modifier) {
        return modifier.get(this);
    }

    private void changeDrugModifierMultiply(class_1309 entity, class_1320 attribute, double value) {
        this.changeDrugModifier(entity, attribute, value - 1.0, class_1322.class_1323.field_6331);
    }

    private void changeDrugModifier(class_1309 entity, class_1320 attribute, double value, class_1322.class_1323 operation) {
        class_1324 speedInstance = entity.method_5996(attribute);
        speedInstance.method_6200(DRUG_EFFECT);
        speedInstance.method_26835(new class_1322(DRUG_EFFECT, "Drug Effects", value, operation));
    }
}

