/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.entity.drug.type;

import ivorius.psychedelicraft.entity.drug.DrugType;
import ivorius.psychedelicraft.entity.drug.influence.DrugInfluenceInstance;
import ivorius.psychedelicraft.entity.drug.type.SimpleDrug;
import ivorius.psychedelicraft.util.MathUtils;
import net.minecraft.class_2487;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class HarmoniumDrug
extends SimpleDrug {
    private final Vector3f currentColor = new Vector3f(1.0f, 1.0f, 1.0f);

    public HarmoniumDrug(double decSpeed, double decSpeedPlus) {
        super(DrugType.HARMONIUM, decSpeed, decSpeedPlus);
    }

    @Override
    public void applyContrastColorization(Vector4f rgba) {
        MathUtils.mixColorsDynamic((Vector3fc)this.currentColor, rgba, (float)this.getActiveValue());
    }

    @Override
    public void applyColorBloom(Vector4f rgba) {
        MathUtils.mixColorsDynamic((Vector3fc)this.currentColor, rgba, (float)this.getActiveValue() * 3.0f);
    }

    @Override
    public void addToDesiredValue(double value, DrugInfluenceInstance influence) {
        super.addToDesiredValue(value, influence);
        if (!this.isLocked()) {
            influence.color.ifPresent(color -> MathUtils.lerp((float)(value + (1.0 - value) * (1.0 - this.getActiveValue())), this.currentColor, (Vector3fc)color));
        }
    }

    @Override
    public void toNbt(class_2487 tagCompound) {
        super.toNbt(tagCompound);
        tagCompound.method_10548("currentColor[0]", this.currentColor.x);
        tagCompound.method_10548("currentColor[1]", this.currentColor.y);
        tagCompound.method_10548("currentColor[2]", this.currentColor.z);
    }

    @Override
    public void fromNbt(class_2487 tagCompound) {
        super.fromNbt(tagCompound);
        this.currentColor.set(tagCompound.method_10583("currentColor[0]"), tagCompound.method_10583("currentColor[1]"), tagCompound.method_10583("currentColor[2]"));
    }
}

