/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.fluid;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import io.netty.buffer.ByteBuf;
import ivorius.psychedelicraft.PSTags;
import ivorius.psychedelicraft.Psychedelicraft;
import ivorius.psychedelicraft.block.PSBlocks;
import ivorius.psychedelicraft.block.entity.FluidProcessingBlockEntity;
import ivorius.psychedelicraft.fluid.Combustable;
import ivorius.psychedelicraft.fluid.PSFluids;
import ivorius.psychedelicraft.fluid.Processable;
import ivorius.psychedelicraft.fluid.VanillaFluid;
import ivorius.psychedelicraft.fluid.physical.FluidStateManager;
import ivorius.psychedelicraft.fluid.physical.PhysicalFluid;
import ivorius.psychedelicraft.fluid.physical.PlacedFluid;
import ivorius.psychedelicraft.item.component.FluidCapacity;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.util.compat.PacketCodec;
import ivorius.psychedelicraft.util.compat.PacketCodecs;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributeHandler;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2348;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3544;
import net.minecraft.class_3545;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class SimpleFluid
implements Combustable {
    public static final class_2960 EMPTY_KEY = Psychedelicraft.id("empty");
    public static final class_5321<class_2378<SimpleFluid>> REGISTRY_KEY = class_5321.method_29180((class_2960)Psychedelicraft.id("fluids"));
    public static final class_2378<SimpleFluid> REGISTRY = FabricRegistryBuilder.from((class_2385)new class_2348(EMPTY_KEY.toString(), REGISTRY_KEY, Lifecycle.stable(), true)).buildAndRegister();
    protected static final Map<class_2960, SimpleFluid> ALIASED_IDS = new HashMap<class_2960, SimpleFluid>();
    public static final Codec<SimpleFluid> CODEC = class_2960.field_25139.xmap(SimpleFluid::byId, SimpleFluid::getId);
    public static final PacketCodec<ByteBuf, SimpleFluid> PACKET_CODEC = PacketCodecs.IDENTIFIER.xmap(SimpleFluid::byId, SimpleFluid::getId);
    protected final class_2960 id;
    private final class_2960 symbol;
    private final boolean custom;
    private final boolean empty;
    private final Settings settings;
    private final PhysicalFluid physical;
    private final Supplier<ItemFluids> defaultStack = Suppliers.memoize(() -> ItemFluids.create(this, 1, Map.of()));
    private final class_6880.class_6883<SimpleFluid> registryEntry = REGISTRY.method_40269((Object)this);

    public static SimpleFluid byId(@Nullable class_2960 id) {
        if (id == null) {
            return PSFluids.EMPTY;
        }
        SimpleFluid fluid = ALIASED_IDS.get(id);
        if (fluid != null) {
            return fluid;
        }
        return REGISTRY.method_17966(id).orElseGet(() -> class_7923.field_41173.method_17966(id).map(SimpleFluid::of).orElse(PSFluids.EMPTY));
    }

    public static SimpleFluid of(@Nullable class_3611 fluid) {
        if (fluid == null || fluid == class_3612.field_15906) {
            return PSFluids.EMPTY;
        }
        if (fluid instanceof PlacedFluid) {
            PlacedFluid pf = (PlacedFluid)fluid;
            return pf.getType();
        }
        class_2960 id = class_7923.field_41173.method_10221((Object)VanillaFluid.toStill(fluid));
        SimpleFluid alias = ALIASED_IDS.get(id);
        if (alias != null) {
            return alias;
        }
        return (SimpleFluid)REGISTRY.method_10223(id);
    }

    protected SimpleFluid(class_2960 id, Settings settings) {
        class_2378.method_10230(REGISTRY, (class_2960)id, (Object)this);
        this.id = id;
        this.settings = settings;
        this.symbol = id.method_45134(p -> "textures/fluid/" + p + ".png");
        this.custom = true;
        this.empty = false;
        this.physical = new PhysicalFluid(id, this);
        FluidVariantAttributes.register((class_3611)this.physical.getStandingFluid(), (FluidVariantAttributeHandler)new FluidVariantAttributeHandler(){

            public class_2561 getName(FluidVariant fluidVariant) {
                return SimpleFluid.this.getName(ItemFluids.of(fluidVariant, 1));
            }
        });
    }

    protected SimpleFluid(class_2960 id, int color, PhysicalFluid physical, boolean empty) {
        this.id = id;
        this.empty = empty;
        this.settings = new Settings().color(color);
        this.symbol = id.method_45134(p -> "textures/fluid/" + p + ".png");
        this.custom = false;
        this.physical = physical;
    }

    @Deprecated
    public class_6880.class_6883<SimpleFluid> getRegistryEntry() {
        return this.registryEntry;
    }

    protected <S extends Settings> S getSettings() {
        return (S)this.settings;
    }

    public final FluidStateManager getStateManager() {
        return this.settings.stateManager;
    }

    public final boolean isEmpty() {
        return this.empty;
    }

    public final class_2960 getId() {
        return this.id;
    }

    public class_2960 getSymbol(ItemFluids stack) {
        return this.symbol;
    }

    public Optional<class_2960> getFlowTexture(ItemFluids stack) {
        return this.settings.flowTexture;
    }

    public Optional<class_2960> getStandingTexture(ItemFluids stack) {
        return this.settings.stillTexture;
    }

    public final ItemFluids getStack(class_2688<?, ?> state, int amount) {
        HashMap<String, Integer> attributes = new HashMap<String, Integer>();
        this.getStateManager().writeAttributes(state, attributes);
        return ItemFluids.create(this, amount, attributes);
    }

    public final class_3610 getFluidState(ItemFluids stack) {
        return this.getStateManager().readAttributes(this.getPhysical().getDefaultState(), stack);
    }

    public PhysicalFluid getPhysical() {
        return this.physical;
    }

    public boolean isCustomFluid() {
        return this.custom;
    }

    public int getColor(ItemFluids stack) {
        return this.settings.color;
    }

    public int getViscocity() {
        return this.settings.viscocity;
    }

    public int getCondensationTemperature() {
        return this.settings.condensationPoint;
    }

    protected String getTranslationKey() {
        return class_156.method_646((String)(this.isCustomFluid() ? "fluid" : "block"), (class_2960)this.id);
    }

    public final ItemFluids getDefaultStack() {
        return this.defaultStack.get();
    }

    public final ItemFluids getDefaultStack(int amount) {
        return this.getDefaultStack().ofAmount(amount);
    }

    public Stream<ItemFluids> getDefaultStacks(int capacity) {
        return Stream.of(this.getDefaultStack(capacity));
    }

    public String getUniqueKey(ItemFluids fluids) {
        return "";
    }

    public final Stream<class_1799> getDefaultStacks(class_1799 stack) {
        int capacity = FluidCapacity.get(stack);
        if (capacity > 0 && this.isSuitableContainer(stack)) {
            return this.getDefaultStacks(capacity).map(s -> ItemFluids.set(stack.method_7972(), s));
        }
        return Stream.of(new class_1799[0]);
    }

    public class_2561 getName(ItemFluids stack) {
        return class_2561.method_43471((String)this.getTranslationKey());
    }

    public void appendTooltip(ItemFluids stack, Consumer<class_2561> tooltip, class_1836 type) {
    }

    public void appendTankTooltip(ItemFluids stack, @Nullable class_1937 world, List<class_2561> tooltip, FluidProcessingBlockEntity tank) {
        int ticksProcessed = tank.getTimeProcessed();
        int ticksNeeded = Math.abs(tank.getTimeNeeded());
        String timeRemaining = class_3544.method_15439((int)(ticksNeeded - ticksProcessed), (float)(world == null ? 20.0f : world.method_54719().method_54748()));
        Processable.ProcessType processType = tank.getActiveProcess();
        tooltip.add((class_2561)class_2561.method_43469((String)"fluid.status", (Object[])new Object[]{processType.getStatus()}).method_27692(class_124.field_1080));
        if (processType != Processable.ProcessType.IDLE) {
            tooltip.add((class_2561)class_2561.method_43469((String)processType.getTimeLabelTranslationKey(), (Object[])new Object[]{timeRemaining}).method_27692(class_124.field_1080));
        }
    }

    public boolean isSuitableContainer(class_1799 container) {
        return container.method_31573(ConventionalItemTags.EMPTY_BUCKETS);
    }

    public class_6862<class_1792> getPreferredContainerTag() {
        return PSTags.Items.DRINK_RECEPTICALS;
    }

    public boolean hasRandomTicks() {
        return this.getFireStrength(this.getDefaultStack()) > 0.0f;
    }

    public void randomDisplayTick(class_1937 world, class_2338 pos, class_3610 state, class_5819 random) {
        if (!this.custom) {
            state.method_15768(world, pos, random);
        }
    }

    public void onRandomTick(class_1937 world, class_2338 pos, class_3610 state, class_5819 random) {
        if (this.getFireStrength(this.getDefaultStack()) > 0.0f) {
            for (class_2350 direction : class_2350.values()) {
                class_2338 side = pos.method_10093(direction);
                class_2680 above = world.method_8320(side);
                if (!above.method_26215() || above.method_27852(PSBlocks.FLAMMABLE_GAS)) continue;
                world.method_8501(side, PSBlocks.FLAMMABLE_GAS.method_9564());
            }
        }
    }

    public int getHash(ItemFluids stack) {
        return this.hashCode();
    }

    public String toString() {
        return REGISTRY.method_47983((Object)this).method_40230().map(k -> k.toString()).orElse("<unregistered>");
    }

    @Override
    public float getFireStrength(ItemFluids stack) {
        return this.settings.flammability * (float)stack.amount();
    }

    @Override
    public float getExplosionStrength(ItemFluids stack) {
        return this.settings.explosiveness * (float)stack.amount();
    }

    public static class Settings {
        private int color;
        private int viscocity = 1;
        private float explosiveness;
        private float flammability;
        private int condensationPoint = 15;
        final FluidStateManager stateManager = new FluidStateManager(new HashSet());
        private Optional<class_2960> flowTexture = Optional.empty();
        private Optional<class_2960> stillTexture = Optional.empty();

        public <T extends Settings> T condensationPoint(int temperature) {
            Preconditions.checkArgument((temperature >= 0 && temperature <= 15 ? 1 : 0) != 0);
            this.condensationPoint = temperature;
            return (T)this;
        }

        public <T extends Settings> T color(int color) {
            this.color = color;
            return (T)this;
        }

        public <T extends Settings> T viscocity(int viscocity) {
            this.viscocity = viscocity;
            return (T)this;
        }

        public <T extends Settings> T flammability(float flammability, float explosiveness) {
            this.explosiveness = explosiveness;
            this.flammability = flammability;
            return (T)this;
        }

        public <T extends Settings> T with(FluidStateManager.FluidProperty<?> property) {
            this.stateManager.properties().add(property);
            return (T)this;
        }

        public <T extends Settings> T sprites(class_2960 flowing, class_2960 still) {
            this.flowTexture = Optional.ofNullable(flowing);
            this.stillTexture = Optional.ofNullable(still);
            return (T)this;
        }
    }

    public static abstract class Attribute<T extends Comparable<T>> {
        public abstract ItemFluids set(ItemFluids var1, T var2);

        public abstract T get(ItemFluids var1);

        public final T get(class_1799 stack) {
            return this.get(ItemFluids.of(stack));
        }

        public abstract void set(Map<String, Integer> var1, T var2);

        public abstract ItemFluids cycle(ItemFluids var1);

        public final class_1799 set(class_1799 stack, T value) {
            return ItemFluids.set(stack, this.set(ItemFluids.of(stack), value));
        }

        public abstract Stream<class_3545<T, T>> steps();

        public abstract String name();

        public static Attribute<Integer> ofInt(final String name, final int min, final int max) {
            return new Attribute<Integer>(){

                @Override
                public ItemFluids set(ItemFluids fluids, Integer value) {
                    return fluids.withAttribute(name, class_3532.method_15340((int)value, (int)min, (int)max));
                }

                @Override
                public void set(Map<String, Integer> attributes, Integer value) {
                    attributes.put(name, value);
                }

                @Override
                public Integer get(ItemFluids fluids) {
                    return class_3532.method_15340((int)fluids.attributes().getOrDefault(name, 0), (int)min, (int)max);
                }

                @Override
                public Stream<class_3545<Integer, Integer>> steps() {
                    return IntStream.range(min, max).mapToObj(i -> new class_3545((Object)i, (Object)(i + 1)));
                }

                @Override
                public ItemFluids cycle(ItemFluids fluids) {
                    int value = this.get(fluids);
                    return value < max ? this.set(fluids, (Integer)(value + 1)) : fluids;
                }

                @Override
                public String name() {
                    return name;
                }
            };
        }

        public static Attribute<Boolean> ofBoolean(final String name) {
            return new Attribute<Boolean>(){

                @Override
                public ItemFluids set(ItemFluids fluids, Boolean value) {
                    return fluids.withAttribute(name, value != false ? 1 : 0);
                }

                @Override
                public void set(Map<String, Integer> attributes, Boolean value) {
                    attributes.put(name, value != false ? 1 : 0);
                }

                @Override
                public Boolean get(ItemFluids fluids) {
                    return fluids.attributes().getOrDefault(name, 0) != 0;
                }

                @Override
                public Stream<class_3545<Boolean, Boolean>> steps() {
                    return Stream.of(new class_3545((Object)false, (Object)true));
                }

                @Override
                public ItemFluids cycle(ItemFluids fluids) {
                    return this.get(fluids) == false ? this.set(fluids, (Boolean)true) : fluids;
                }

                @Override
                public String name() {
                    return name;
                }
            };
        }
    }
}

