/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.fluid.container;

import ivorius.psychedelicraft.fluid.container.VariantMarshal;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.util.NbtSerialisable;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_3532;

public class Resovoir
implements NbtSerialisable,
VariantMarshal.FabricResovoir {
    public static final Resovoir EMPTY = new Resovoir(0, (r, l) -> {}){

        @Override
        public void fromNbt(class_2487 compound) {
        }
    };
    private ItemFluids fluids;
    private final int capacity;
    private final ChangeListener changeCallback;

    public Resovoir(int capacity, ChangeListener changeCallback) {
        this(capacity, changeCallback, ItemFluids.EMPTY);
    }

    public Resovoir(int capacity, ChangeListener changeCallback, ItemFluids fluids) {
        this.capacity = capacity;
        this.changeCallback = changeCallback;
        this.fluids = fluids;
    }

    @Override
    public ItemFluids getContents() {
        return this.fluids;
    }

    public void setContents(ItemFluids fluids) {
        this.setContents(fluids, true);
    }

    public void setContents(ItemFluids fluids, boolean notify) {
        int amount = this.fluids.amount();
        this.fluids = fluids.ofAmount(Math.min(fluids.amount(), this.capacity));
        if (notify) {
            this.changeCallback.onLevelChange(this, this.fluids.amount() - amount);
        }
    }

    public long getCapacity() {
        return this.capacity;
    }

    public class_1799 deposit(class_1799 stack) {
        ItemFluids.Transaction t = ItemFluids.Transaction.begin(stack);
        this.deposit(t, t.capacity());
        return t.toItemStack();
    }

    public int deposit(ItemFluids stack) {
        if (this.fluids.amount() >= this.capacity || stack.isEmpty() || !this.fluids.canCombine(stack)) {
            return 0;
        }
        int transferred = class_3532.method_15340((int)Math.max(0, this.capacity - this.fluids.amount()), (int)0, (int)stack.amount());
        if (transferred > 0) {
            this.fluids = stack.ofAmount(this.fluids.amount() + transferred);
            this.changeCallback.onLevelChange(this, transferred);
        }
        return transferred;
    }

    public ItemFluids drain(int maxAmount) {
        ItemFluids extracted = this.fluids.ofAmount(Math.min(maxAmount, this.fluids.amount()));
        if (extracted.amount() > 0) {
            this.fluids = this.fluids.ofAmount(this.fluids.amount() - extracted.amount());
            this.changeCallback.onLevelChange(this, -extracted.amount());
        }
        return extracted;
    }

    public int deposit(ItemFluids.Transaction from, int maxAmount) {
        if (this.fluids.amount() >= this.capacity || from.fluids().isEmpty() || !this.fluids.canCombine(from.fluids())) {
            return 0;
        }
        ItemFluids transferred = from.withdraw(Math.min(Math.max(0, this.capacity - this.fluids.amount()), maxAmount));
        this.fluids = transferred.ofAmount(this.fluids.amount() + transferred.amount());
        if (transferred.amount() > 0) {
            this.changeCallback.onLevelChange(this, transferred.amount());
        }
        return transferred.amount();
    }

    public int withdraw(ItemFluids.Transaction output, int maxAmount) {
        if (this.fluids.isEmpty() || output.fluids().amount() >= output.capacity() || !this.fluids.canCombine(output.fluids())) {
            return 0;
        }
        int initialAmount = this.fluids.amount();
        this.fluids = output.deposit(this.fluids, maxAmount);
        int transferred = initialAmount - this.fluids.amount();
        if (transferred > 0) {
            this.changeCallback.onLevelChange(this, -transferred);
        }
        return transferred;
    }

    public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        ItemFluids fluids = ItemFluids.of(resource, (int)maxAmount);
        if (resource.isBlank() || !fluids.canCombine(this.fluids)) {
            return 0L;
        }
        int accepted = (int)Math.min((long)(fluids.amount() - this.capacity), maxAmount);
        transaction.addCloseCallback((sender, result) -> {
            if (result.wasCommitted()) {
                this.fluids = fluids.ofAmount(this.fluids.amount() + accepted);
                this.changeCallback.onLevelChange(this, accepted);
            }
        });
        return accepted;
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        if (maxAmount <= 0L || this.fluids.isEmpty()) {
            return 0L;
        }
        ItemFluids fluids = ItemFluids.of(resource, (int)maxAmount);
        if (!fluids.canCombine(this.fluids)) {
            return 0L;
        }
        int provided = (int)Math.min(maxAmount, (long)this.fluids.amount());
        transaction.addCloseCallback((sender, result) -> {
            if (result.wasCommitted()) {
                this.fluids = this.fluids.ofAmount(this.fluids.amount() - provided);
                this.changeCallback.onLevelChange(this, -provided);
            }
        });
        return provided;
    }

    public void clear() {
        int amount = this.fluids.amount();
        this.fluids = ItemFluids.EMPTY;
        if (amount > 0) {
            this.changeCallback.onLevelChange(this, -amount);
        }
    }

    @Override
    public void toNbt(class_2487 compound) {
        compound.method_10566("fluid", this.fluids.encode());
    }

    @Override
    public void fromNbt(class_2487 compound) {
        this.fluids = compound.method_10573("stack", 10) ? ItemFluids.of(class_1799.method_7915((class_2487)compound.method_10562("stack"))) : ItemFluids.decode(compound.method_10580("fluid"));
    }

    public static interface ChangeListener {
        public void onLevelChange(Resovoir var1, int var2);
    }
}

