/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.psychedelicraft.Psychedelicraft;
import ivorius.psychedelicraft.entity.drug.DrugType;
import ivorius.psychedelicraft.entity.drug.influence.DrugInfluence;
import ivorius.psychedelicraft.entity.drug.type.SimpleDrug;
import ivorius.psychedelicraft.item.component.PSComponents;
import ivorius.psychedelicraft.item.component.TooltipAppender;
import ivorius.psychedelicraft.util.PacketCodecUtils;
import ivorius.psychedelicraft.util.compat.PacketCodec;
import ivorius.psychedelicraft.util.compat.PacketCodecs;
import ivorius.psychedelicraft.util.compat.StackCompat;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3542;

public record Impurities(Set<Impurity> impurities) implements TooltipAppender
{
    public static final Impurities EMPTY = new Impurities(Set.of());
    public static final Codec<Impurities> CODEC = RecordCodecBuilder.create(i -> i.group((App)Impurity.CODEC.listOf().xmap(Set::copyOf, List::copyOf).fieldOf("impurities").forGetter(Impurities::impurities)).apply((Applicative)i, Impurities::new));
    public static final PacketCodec<class_2540, Impurities> PACKET_CODEC = PacketCodecUtils.ofEnum(Impurity.class).collect(PacketCodecs.toCollection(i -> new HashSet(i))).xmap(Impurities::new, Impurities::impurities);

    public Impurities {
        impurities = impurities.isEmpty() ? EnumSet.noneOf(Impurity.class) : EnumSet.copyOf(impurities);
    }

    public static Impurities get(class_1799 stack) {
        return StackCompat.getOrDefault(stack, PSComponents.IMPURITIES, EMPTY);
    }

    public static boolean isOn(class_1799 stack, Impurity impurity) {
        return Impurities.get(stack).impurities().contains((Object)impurity);
    }

    public static class_1799 set(class_1799 stack, Impurity ... impurities) {
        return Impurities.set(stack, Set.of(impurities));
    }

    public static class_1799 set(class_1799 stack, Set<Impurity> impurities) {
        StackCompat.set(stack, PSComponents.IMPURITIES, new Impurities(impurities));
        return stack;
    }

    public static class_1799 set(class_1799 stack, Impurities impurities) {
        StackCompat.set(stack, PSComponents.IMPURITIES, impurities);
        return stack;
    }

    public static Impurities combine(Impurities a, Impurities b) {
        HashSet<Impurity> combined = new HashSet<Impurity>(a.impurities());
        combined.addAll(b.impurities());
        return new Impurities(combined);
    }

    public static Impurities overlap(Impurities a, Set<Impurity> b) {
        HashSet<Impurity> combined = new HashSet<Impurity>();
        for (Impurity i : a.impurities()) {
            if (!b.contains((Object)i)) continue;
            combined.add(i);
        }
        return new Impurities(combined);
    }

    public float getEffectStrengthModifier() {
        float strength = 1.0f;
        if (this.impurities.contains((Object)Impurity.CARBON)) {
            strength *= 0.5f;
        }
        if (this.impurities.contains((Object)Impurity.PETROLIUM)) {
            strength *= 1.5f;
        }
        if (this.impurities.contains((Object)Impurity.ETHANOL)) {
            strength *= 1.5f;
        }
        if (this.impurities.contains((Object)Impurity.SILICA)) {
            strength *= 0.4f;
        }
        if (this.impurities.contains((Object)Impurity.SUGAR)) {
            strength *= 0.9f;
        }
        return strength;
    }

    public float getEffectDelayModifier() {
        float strength = 1.0f;
        if (this.impurities.contains((Object)Impurity.GASOLINE)) {
            strength *= 0.5f;
        }
        if (this.impurities.contains((Object)Impurity.PETROLIUM)) {
            strength *= 0.5f;
        }
        if (this.impurities.contains((Object)Impurity.SUGAR)) {
            strength *= 1.2f;
        }
        return strength;
    }

    public Stream<DrugType<?>> getAdditionalDrugs() {
        Stream.Builder<DrugType<SimpleDrug>> builder = Stream.builder();
        if (this.impurities.contains((Object)Impurity.ETHANOL)) {
            builder.add(DrugType.ALCOHOL);
        }
        if (this.impurities.contains((Object)Impurity.SUGAR)) {
            builder.add(DrugType.SUGAR);
        }
        return builder.build();
    }

    public List<DrugInfluence> modifyEffects(List<DrugInfluence> influences) {
        if (this.impurities.isEmpty()) {
            return influences;
        }
        float strength = this.getEffectStrengthModifier();
        float delayModifier = this.getEffectDelayModifier();
        return Stream.concat(this.getAdditionalDrugs().map(type -> new DrugInfluence(DrugType.ALCOHOL, 60, 0.1f, 1.0, 0.8f)), influences.stream()).map(i -> i.copyWithTarget(i.target() * (double)strength).copyWithDelay(Math.max(1, (int)((float)i.delay() * delayModifier)))).toList();
    }

    @Override
    public void appendTooltip(class_1836 context, Consumer<class_2561> tooltip) {
        if (!this.impurities.isEmpty()) {
            tooltip.accept(this.impurities.stream().map(i -> i.getName()).reduce(null, (a, b) -> a == null ? b : (b == null ? a : a.method_27661().method_27693(", ").method_10852(b))));
        }
    }

    public static enum Impurity implements class_3542
    {
        CARBON,
        ETHANOL,
        PETROLIUM,
        GASOLINE,
        SILICA,
        SUGAR,
        LAPIS_LAZULI;

        public static final Codec<Impurity> CODEC;
        private final String name = this.name().toLowerCase(Locale.ROOT);
        private final class_2561 displayName = class_2561.method_43471((String)class_156.method_646((String)"impurity", (class_2960)Psychedelicraft.id(this.name)));

        public String method_15434() {
            return this.name;
        }

        public class_2561 getName() {
            return this.displayName;
        }

        static {
            CODEC = class_3542.method_28140(Impurity::values);
        }
    }
}

