/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.psychedelicraft.PSDamageTypes;
import ivorius.psychedelicraft.PSSounds;
import ivorius.psychedelicraft.advancement.PSCriteria;
import ivorius.psychedelicraft.entity.drug.DrugProperties;
import ivorius.psychedelicraft.entity.drug.influence.DrugInfluence;
import ivorius.psychedelicraft.item.component.Impurities;
import ivorius.psychedelicraft.item.component.PSComponents;
import ivorius.psychedelicraft.item.component.TooltipAppender;
import ivorius.psychedelicraft.util.RaytraceUtil;
import ivorius.psychedelicraft.util.compat.PacketCodec;
import ivorius.psychedelicraft.util.compat.PacketCodecs;
import ivorius.psychedelicraft.util.compat.StackCompat;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3966;
import net.minecraft.class_3988;
import net.minecraft.class_4094;
import net.minecraft.class_4151;
import org.joml.Vector3f;

public record ItemDrugs(List<DrugInfluence> influences, Optional<Vector3f> smokeColor) implements TooltipAppender
{
    public static final Vector3f DEFAULT_SMOKE_COLOR = new Vector3f(1.0f, 1.0f, 1.0f);
    public static final ItemDrugs EMPTY = new ItemDrugs(List.of(), Optional.empty());
    public static final Codec<ItemDrugs> CODEC = RecordCodecBuilder.create(i -> i.group((App)DrugInfluence.CODEC.listOf().fieldOf("influences").forGetter(ItemDrugs::influences), (App)DrugInfluence.COLOR_CODEC.optionalFieldOf("smoke_color").forGetter(ItemDrugs::smokeColor)).apply((Applicative)i, ItemDrugs::of));
    public static final PacketCodec<class_2540, ItemDrugs> PACKET_CODEC = PacketCodec.tuple(DrugInfluence.PACKET_CODEC.collect(PacketCodecs.toList()), ItemDrugs::influences, DrugInfluence.COLOR_PACKET_CODEC, ItemDrugs::smokeColor, ItemDrugs::of);

    public ItemDrugs {
        influences = List.copyOf(influences);
    }

    public static ItemDrugs of(List<DrugInfluence> influences) {
        return ItemDrugs.of(influences, Optional.empty());
    }

    public static ItemDrugs of(List<DrugInfluence> influences, Optional<Vector3f> smokeColor) {
        return new ItemDrugs(influences, smokeColor);
    }

    public static ItemDrugs of(DrugInfluence ... influences) {
        return ItemDrugs.of(List.of(influences));
    }

    public ItemDrugs withSmoke(Vector3f smokeColor) {
        return new ItemDrugs(this.influences, Optional.of(smokeColor));
    }

    public static ItemDrugs get(class_1799 stack) {
        return StackCompat.getOrDefault(stack, PSComponents.DRUGS, EMPTY);
    }

    public void applyTo(class_1799 stack, DrugProperties properties) {
        Impurities impurities = Impurities.get(stack);
        properties.addAll(impurities.modifyEffects(this.influences));
        if (impurities.impurities().contains((Object)Impurities.Impurity.SILICA)) {
            properties.asEntity().method_5643(properties.damageOf(PSDamageTypes.GLASS_SHARD), 1.5f);
            properties.asEntity().method_5783(PSSounds.ITEM_BROKEN_GLASS_EAT, 1.0f, 1.0f);
        }
        this.smokeColor.ifPresent(smokeColor -> {
            properties.startBreathingSmoke(10 + properties.asEntity().method_37908().field_9229.method_43048(10), (Vector3f)smokeColor);
            properties.rollCancerDance();
            class_3966 hit = RaytraceUtil.raycastEntities((class_1297)properties.asEntity(), 3.0);
            if (hit != null) {
                PSCriteria.BREATHE_SMOKE_ON_ENTITY.trigger(properties.asEntity(), hit.method_17782());
                DrugProperties.of(hit.method_17782()).ifPresent(target -> {
                    target.addAll(this.influences.stream().map(i -> i.copyWithTarget(i.target() * (double)0.1f)).toList());
                    if (target.asEntity().method_37908().field_9229.method_43048(10) == 0 && target.rollCancerDance()) {
                        PSCriteria.CANCER.trigger(target.asEntity(), (class_1297)properties.asEntity());
                    }
                });
                class_1297 patt4291$temp = hit.method_17782();
                if (patt4291$temp instanceof class_1309) {
                    class_1309 l = (class_1309)patt4291$temp;
                    if (l instanceof class_1308) {
                        class_1308 mob = (class_1308)l;
                        mob.method_5966();
                    }
                    if (l instanceof class_3988) {
                        class_3988 villager = (class_3988)l;
                        villager.method_20507(100);
                    } else {
                        hit.method_17782().method_5643(properties.asEntity().method_48923().method_48802(properties.asEntity()), 0.1f);
                    }
                    if (l instanceof class_4094) {
                        class_4094 observer = (class_4094)l;
                        observer.method_18870(class_4151.field_18476, (class_1297)properties.asEntity());
                    }
                }
            }
        });
    }

    @Override
    public void appendTooltip(class_1836 context, Consumer<class_2561> tooltip) {
        if (context.method_8035() && !this.influences.isEmpty()) {
            tooltip.accept((class_2561)class_2561.method_43471((String)"psychedelicraft.item.contained_drug_effects").method_27692(class_124.field_1080));
            this.influences.forEach(influence -> tooltip.accept((class_2561)class_2561.method_43469((String)"psychedelicraft.item.contained_drug_effects.entry", (Object[])new Object[]{influence.drugType().id(), class_2561.method_43470((String)String.format(Math.abs(influence.target()) > (double)1.0E-5f ? "%.2f" : "%.0f", influence.target())), class_2561.method_43470((String)String.format(Math.abs(influence.base()) > (double)1.0E-5f ? "%.3f" : "%.0f", influence.base()))}).method_27692(class_124.field_1064)));
        }
    }
}

