/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.recipe;

import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import ivorius.psychedelicraft.item.component.FluidCapacity;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.util.PacketCodecUtils;
import ivorius.psychedelicraft.util.compat.PacketCodec;
import ivorius.psychedelicraft.util.compat.PacketCodecs;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_7709;
import net.minecraft.class_7710;

public interface RecipeUtils {
    public static final Codec<class_2371<class_1856>> SHAPELESS_RECIPE_INGREDIENTS_CODEC = class_1856.field_46096.listOf().flatXmap(ingredients -> {
        Object[] ingredients2 = (class_1856[])ingredients.stream().filter(ingredient -> !ingredient.method_8103()).toArray(class_1856[]::new);
        if (ingredients2.length == 0) {
            return DataResult.error(() -> "No ingredients for shapeless recipe");
        }
        if (ingredients2.length > 9) {
            return DataResult.error(() -> "Too many ingredients for shapeless recipe");
        }
        return DataResult.success((Object)class_2371.method_10212((Object)class_1856.field_9017, (Object[])ingredients2));
    }, DataResult::success);
    public static final PacketCodec<class_2540, class_7710> CRAFTING_RECIPE_CATEGORY_PACKET_CODEC = PacketCodecUtils.ofEnum(class_7710.class);
    public static final PacketCodec<class_2540, class_7709> COOKING_RECIPE_CATEGORY_PACKET_CODEC = PacketCodecUtils.ofEnum(class_7709.class);
    public static final PacketCodec<class_2540, class_2371<class_1856>> INGREDIENTS_PACKET_CODEC = PacketCodecs.INGREDIENT.collect(PacketCodecUtils.toDefaultedList());

    public static class_1799 copyInputFluidToResult(class_1799 result, List<class_1799> inputs) {
        return RecipeUtils.recepticals(inputs.stream()).findFirst().map(input -> {
            class_1799 copy = result.method_7972();
            copy.method_7980(input.method_7969());
            return ItemFluids.set(copy, ItemFluids.of(input));
        }).orElse(result);
    }

    public static Stream<class_1799> recepticals(Stream<class_1799> stacks) {
        return stacks.filter(stack -> FluidCapacity.get(stack) > 0);
    }

    public static Stream<Slot<class_1799>> recepticalSlots(class_1263 input) {
        return RecipeUtils.slots(input, stack -> FluidCapacity.get(stack) > 0, Function.identity());
    }

    public static Stream<class_1799> stacks(class_1263 inventory) {
        return IntStream.range(0, inventory.method_5439()).mapToObj(arg_0 -> ((class_1263)inventory).method_5438(arg_0)).filter(s -> !s.method_7960());
    }

    public static <T> Stream<Slot<T>> slots(class_1263 inventory, Predicate<class_1799> filter, Function<class_1799, T> func) {
        return IntStream.range(0, inventory.method_5439()).filter(i -> filter.test(inventory.method_5438(i))).mapToObj(i -> new Slot(inventory, func.apply(inventory.method_5438(i)), i));
    }

    public static class_2371<class_1856> union(class_2371<class_1856> list, class_1856 ... additional) {
        return class_2371.method_10212((Object)class_1856.field_9017, (Object[])((class_1856[])Stream.concat(list.stream(), Arrays.stream(additional)).toArray(class_1856[]::new)));
    }

    public static <T> class_2371<T> checkLength(class_2371<T> ingredients) {
        if (ingredients.isEmpty()) {
            throw new JsonParseException("No ingredients for shapeless recipe");
        }
        if (ingredients.size() > 9) {
            throw new JsonParseException("Too many ingredients for shapeless recipe");
        }
        return ingredients;
    }

    public static Optional<class_1799> consume(class_1263 inventory, Predicate<class_1799> filter) {
        return IntStream.range(0, inventory.method_5439()).filter(i -> filter.test(inventory.method_5438(i))).mapToObj(i -> inventory.method_5438(i).method_7971(1)).findFirst();
    }

    public static <T> T iDontCareWhich(Either<T, T> either) {
        return either.left().or(() -> either.right()).orElseThrow();
    }

    public record Slot<T>(class_1263 inventory, T content, int slot) {
        public void set(class_1799 stack) {
            this.inventory.method_5447(this.slot, stack);
        }

        public <V> V map(Function<T, V> func) {
            return func.apply(this.content);
        }
    }

    public record Entry<T>(T content, int position) {
    }
}

