/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.block.entity;

import ivorius.psychedelicraft.block.entity.FlaskBlockEntity;
import ivorius.psychedelicraft.fluid.Processable;
import ivorius.psychedelicraft.fluid.SimpleFluid;
import ivorius.psychedelicraft.fluid.container.Resovoir;
import ivorius.psychedelicraft.item.component.ItemFluids;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_7225;

public abstract class FluidProcessingBlockEntity
extends FlaskBlockEntity
implements Processable.ByProductConsumer {
    private float prevProgress;
    private int repeatCount;

    public FluidProcessingBlockEntity(class_2591<? extends FluidProcessingBlockEntity> type, class_2338 pos, class_2680 state, int capacity) {
        super(type, pos, state, capacity);
    }

    @Override
    protected int getTotalProperties() {
        return super.getTotalProperties() + 2;
    }

    public int getTimeNeeded() {
        return this.propertyDelegate.method_17390(4);
    }

    public void setTimeNeeded(int value) {
        class_1937 class_19372;
        if (value > 0 && (class_19372 = this.method_10997()) instanceof class_3218) {
            class_3218 sw = (class_3218)class_19372;
            value = Math.max(1, value / this.getTickRate(sw));
        }
        this.propertyDelegate.method_17391(4, value);
    }

    public int getTimeProcessed() {
        return this.propertyDelegate.method_17390(5);
    }

    public void setTimeProcessed(int value) {
        this.propertyDelegate.method_17391(5, value);
        this.markForUpdate();
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public void setRepeatCount(int repeats) {
        this.repeatCount = repeats;
        this.markForUpdate();
    }

    private float getProgress() {
        if (this.isActive()) {
            return (float)this.getTimeProcessed() / (float)this.getTimeNeeded();
        }
        return 0.0f;
    }

    public float getProgress(float tickDelta) {
        return class_3532.method_16439((float)tickDelta, (float)this.prevProgress, (float)this.getProgress());
    }

    public abstract Processable.ProcessType getProcessType();

    public Processable.ProcessType getActiveProcess() {
        SimpleFluid simpleFluid;
        Resovoir tank = this.getPrimaryTank();
        if (this.isActive() && (simpleFluid = tank.getContents().fluid()) instanceof Processable) {
            Processable p = (Processable)((Object)simpleFluid);
            return p.modifyProcess(tank, this.getProcessType());
        }
        return Processable.ProcessType.IDLE;
    }

    public boolean isActive() {
        return this.getTimeNeeded() != -1;
    }

    protected int getTickRate(class_3218 world) {
        return 1;
    }

    @Override
    public void clientTick(class_1937 world) {
        this.prevProgress = this.getProgress();
    }

    @Override
    public void tick(class_3218 world) {
        super.tick(world);
        Resovoir tank = this.getPrimaryTank();
        SimpleFluid simpleFluid = tank.getContents().fluid();
        if (simpleFluid instanceof Processable) {
            Processable p = (Processable)((Object)simpleFluid);
            Processable.ProcessType type = p.modifyProcess(tank, this.getProcessType());
            this.setTimeNeeded(p.getProcessingTime(tank, type));
            if (this.canProcess(world, this.getTimeNeeded())) {
                if (this.getTimeProcessed() >= this.getTimeNeeded()) {
                    p.process(this, type, this);
                    this.onProcessCompleted(world, tank);
                } else {
                    this.setTimeProcessed(this.getTimeProcessed() + 1);
                    world.method_8408(this.method_11016(), this.method_11010().method_26204());
                }
            } else {
                this.setTimeProcessed(0);
            }
        } else {
            this.setTimeNeeded(-1);
        }
    }

    protected boolean canProcess(class_3218 world, int timeNeeded) {
        return timeNeeded >= 0;
    }

    protected void onProcessCompleted(class_3218 world, Resovoir tank) {
        this.setTimeProcessed(0);
        this.setTimeNeeded(-1);
        ++this.repeatCount;
        this.markForUpdate();
    }

    @Override
    public void onLevelChange(Resovoir resovoir, int difference) {
        if (resovoir.getContents().isEmpty()) {
            this.setTimeProcessed(0);
            this.repeatCount = 0;
            this.markForUpdate();
        }
        super.onLevelChange(resovoir, difference);
    }

    @Override
    public void method_11007(class_2487 compound, class_7225.class_7874 lookup) {
        super.method_11007(compound, lookup);
        compound.method_10569("timeProcessed", this.getTimeProcessed());
        compound.method_10569("timeNeeded", this.getTimeNeeded());
        compound.method_10569("repeatCount", this.repeatCount);
    }

    @Override
    public void method_11014(class_2487 compound, class_7225.class_7874 lookup) {
        super.method_11014(compound, lookup);
        this.setTimeProcessed(compound.method_10550("timeProcessed"));
        this.setTimeNeeded(compound.method_10550("timeNeeded"));
        this.repeatCount = compound.method_10550("repeatCount");
    }

    @Override
    public void accept(class_1799 stack) {
        if (this.field_11863 != null) {
            class_2248.method_9577((class_1937)this.field_11863, (class_2338)this.method_11016(), (class_1799)stack);
        }
    }

    @Override
    public void accept(ItemFluids stack) {
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            int transferred = this.getPrimaryTank().deposit(stack);
            if (transferred < stack.amount()) {
                this.onFluidRejected(world, stack.ofAmount(stack.amount() - transferred));
            }
        }
    }

    protected void onFluidRejected(class_3218 world, ItemFluids fluids) {
        world.method_8396(null, this.method_11016(), class_3417.field_14737, class_3419.field_15245, 0.25f, 0.02f);
        world.method_14199((class_2394)class_2398.field_11202, (double)this.field_11867.method_10263() + world.method_8409().method_43385(0.5, 0.5), (double)((float)this.field_11867.method_10264() + 0.6f), (double)this.field_11867.method_10260() + world.method_8409().method_43385(0.5, 0.5), 2, 0.0, 0.0, 0.0, 0.0);
    }
}

