/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.render;

import ivorius.psychedelicraft.Psychedelicraft;
import ivorius.psychedelicraft.client.render.DrugEffectInterpreter;
import ivorius.psychedelicraft.client.render.RenderPhase;
import ivorius.psychedelicraft.client.render.effect.AlcoholOverlayScreenEffect;
import ivorius.psychedelicraft.client.render.effect.CompoundScreenEffect;
import ivorius.psychedelicraft.client.render.effect.EnvironmentalScreenEffect;
import ivorius.psychedelicraft.client.render.effect.LensFlareScreenEffect;
import ivorius.psychedelicraft.client.render.effect.MotionBlurScreenEffect;
import ivorius.psychedelicraft.client.render.effect.PowerOverlayScreenEffect;
import ivorius.psychedelicraft.client.render.effect.ScreenEffect;
import ivorius.psychedelicraft.client.render.effect.TirednessScreenEffect;
import ivorius.psychedelicraft.client.render.effect.WarmthOverlayScreenEffect;
import ivorius.psychedelicraft.client.render.shader.PostEffectRenderer;
import ivorius.psychedelicraft.client.render.shader.ShaderContext;
import ivorius.psychedelicraft.client.sound.ClientDrugMusicManager;
import ivorius.psychedelicraft.entity.drug.Drug;
import ivorius.psychedelicraft.entity.drug.DrugProperties;
import ivorius.psychedelicraft.entity.drug.hallucination.DriftingCamera;
import ivorius.psychedelicraft.entity.drug.hallucination.Hallucination;
import ivorius.psychedelicraft.entity.drug.hallucination.HallucinationManager;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_572;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_9779;
import org.joml.Quaternionf;

public class DrugRenderer {
    public static final DrugRenderer INSTANCE = new DrugRenderer();
    private final EnvironmentalScreenEffect environmentalEffects = new EnvironmentalScreenEffect();
    private final ScreenEffect screenEffects = CompoundScreenEffect.of(new LensFlareScreenEffect(), new WarmthOverlayScreenEffect(), new AlcoholOverlayScreenEffect(), new PowerOverlayScreenEffect(), this.environmentalEffects, new TirednessScreenEffect(), new MotionBlurScreenEffect());
    private final PostEffectRenderer postEffects = new PostEffectRenderer();
    private final ClientDrugMusicManager musicManager = new ClientDrugMusicManager();

    public ScreenEffect getScreenEffects() {
        return this.screenEffects;
    }

    public PostEffectRenderer getPostEffects() {
        return this.postEffects;
    }

    public EnvironmentalScreenEffect getEnvironmentalEffects() {
        return this.environmentalEffects;
    }

    public ClientDrugMusicManager getMusicManager() {
        return this.musicManager;
    }

    public void update(DrugProperties drugProperties, class_1309 entity) {
        this.getScreenEffects().update(ShaderContext.tickDelta());
        this.musicManager.update(drugProperties);
    }

    public void distortScreen(class_4587 matrices, class_4184 camera, float tickDelta) {
        if (class_310.method_1551().field_1724 == null) {
            return;
        }
        DrugProperties properties = DrugProperties.of((class_1657)class_310.method_1551().field_1724);
        float wobblyness = Math.min(1.0f, properties.getModifier(Drug.VIEW_WOBBLYNESS));
        float tick = (float)properties.asEntity().field_6012 + tickDelta;
        DriftingCamera driftingCam = properties.getHallucinations().getCamera();
        matrices.method_22907(class_7833.field_40714.rotationDegrees(camera.method_19329()));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(camera.method_19330() + 180.0f));
        class_243 cameraOffset = driftingCam.getPosition();
        class_243 prevCameraOffset = driftingCam.getPrevPosition();
        matrices.method_22904(class_3532.method_16436((double)tickDelta, (double)prevCameraOffset.field_1352, (double)cameraOffset.field_1352), class_3532.method_16436((double)tickDelta, (double)prevCameraOffset.field_1351, (double)cameraOffset.field_1351), class_3532.method_16436((double)tickDelta, (double)prevCameraOffset.field_1350, (double)cameraOffset.field_1350));
        class_243 cameraRoll = driftingCam.getRotation();
        class_243 prevCameraRoll = driftingCam.getPrevRotation();
        matrices.method_22907(new Quaternionf().rotateXYZ((float)class_3532.method_16436((double)tickDelta, (double)prevCameraRoll.field_1352, (double)cameraRoll.field_1352), (float)class_3532.method_16436((double)tickDelta, (double)prevCameraRoll.field_1351, (double)cameraRoll.field_1351), (float)class_3532.method_16436((double)tickDelta, (double)prevCameraRoll.field_1350, (double)cameraRoll.field_1350)));
        matrices.method_22907(class_7833.field_40715.rotationDegrees(camera.method_19330() + 180.0f));
        matrices.method_22907(class_7833.field_40713.rotationDegrees(camera.method_19329()));
        if (wobblyness > 0.0f) {
            float f4 = class_3532.method_27285((float)(5.0f / (wobblyness * wobblyness + 5.0f) - wobblyness * 0.04f));
            float sin1 = class_3532.method_15374((float)(tick / 150.0f * (float)Math.PI));
            float sin2 = class_3532.method_15374((float)(tick / 170.0f * (float)Math.PI));
            float sin3 = class_3532.method_15374((float)(tick / 190.0f * (float)Math.PI));
            float yz = tick * 3.0f * ((float)Math.PI / 180);
            Quaternionf rotation = new Quaternionf().rotateXYZ(0.0f, yz, yz);
            matrices.method_22907(rotation);
            matrices.method_22905(1.0f / (f4 + wobblyness * sin1 / 2.0f), 1.0f / (f4 + wobblyness * sin2 / 2.0f), 1.0f / (f4 + wobblyness * sin3 / 2.0f));
            matrices.method_22907(rotation.invert());
        }
        matrices.method_46416(DrugEffectInterpreter.getCameraShiftX(properties, tick), DrugEffectInterpreter.getCameraShiftY(properties, tick), 0.0f);
    }

    public void distortHand(class_4587 matrices) {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        float ticks = ShaderContext.ticks();
        DrugProperties.of((class_1297)client.field_1724).ifPresent(drugProperties -> {
            float shiftX = DrugEffectInterpreter.getHandShiftX(drugProperties, ticks);
            float shiftY = DrugEffectInterpreter.getHandShiftY(drugProperties, ticks);
            matrices.method_46416(shiftX, shiftY, 0.0f);
        });
    }

    public void poseModel(class_1657 player, class_572<?> model) {
        class_630 head = model.method_2838();
        class_630 leftArm = model.field_27433;
        class_630 rightArm = model.field_3401;
        DrugProperties properties = DrugProperties.of(player);
        float tick = ShaderContext.ticks();
        float shiftX = DrugEffectInterpreter.getHandShiftX(properties, tick) * 2.0f;
        leftArm.field_3654 += shiftX;
        rightArm.field_3654 -= shiftX;
        float shiftY = DrugEffectInterpreter.getHandShiftY(properties, tick);
        leftArm.field_3674 += shiftY;
        rightArm.field_3674 -= shiftY;
        head.field_3654 += DrugEffectInterpreter.getCameraShiftX(properties, tick);
        head.field_3675 += DrugEffectInterpreter.getCameraShiftY(properties, tick);
        head.field_3674 = DrugEffectInterpreter.getAlcohol(properties);
        if (model instanceof class_591) {
            class_591 pem = (class_591)model;
            pem.field_3394.method_17138(head);
            pem.field_3484.method_17138(leftArm);
            pem.field_3486.method_17138(rightArm);
        }
    }

    public void onAfterRenderWorld() {
        class_310 client = class_310.method_1551();
        RenderPhase.SCREEN.push();
        try {
            this.postEffects.render(client.method_60646().method_60637(false));
        }
        finally {
            RenderPhase.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRenderOverlay(class_332 context, class_9779 tickCounter) {
        class_310 client = class_310.method_1551();
        RenderPhase.SCREEN.push();
        try {
            this.getScreenEffects().render(context, client.method_22683(), tickCounter.method_60637(false));
        }
        finally {
            RenderPhase.pop();
        }
    }

    public void renderAllHallucinations(class_4587 matrices, class_4597 vertices, class_4184 camera, float tickDelta, DrugProperties drugProperties) {
        HallucinationManager hallucinations = drugProperties.getHallucinations();
        float alpha = class_3532.method_15363((float)(hallucinations.getEntityHallucinationStrength() * 15.0f), (float)0.0f, (float)1.0f);
        float forcedAlpha = hallucinations.getEntities().getForcedAlpha(tickDelta);
        if (forcedAlpha > 0.0f) {
            alpha += forcedAlpha;
            alpha /= 2.0f;
        }
        for (Hallucination h : hallucinations.getEntities()) {
            try {
                h.render(matrices, vertices, camera, tickDelta, alpha);
            }
            catch (Throwable t) {
                Psychedelicraft.LOGGER.fatal("Exception occured whilst rendering hallucination ", t);
                h.setDead();
                while (!matrices.method_22911()) {
                    matrices.method_22909();
                }
            }
        }
    }
}

