/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.render;

import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.util.MathUtils;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.minecraft.class_1058;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_265;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public class FluidBoxRenderer {
    public static final class_2350[] ALL = class_2350.values();
    private static final Vector4f POSITION_VECTOR = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
    private static final FluidBoxRenderer INSTANCE = new FluidBoxRenderer();
    private float scale = 1.0f;
    private int light = 0;
    private int overlay = 0;
    @Nullable
    private class_1058 sprite;
    @Nullable
    private class_4588 buffer;
    private int color = -1;
    @Nullable
    private Matrix4f position;

    public static FluidBoxRenderer getInstance() {
        return INSTANCE;
    }

    private FluidBoxRenderer() {
    }

    public FluidBoxRenderer scale(float scale) {
        this.scale = scale;
        return this;
    }

    public FluidBoxRenderer light(int light) {
        this.light = light;
        return this;
    }

    public FluidBoxRenderer overlay(int overlay) {
        this.overlay = overlay;
        return this;
    }

    public FluidBoxRenderer position(class_4587 position) {
        this.position = position.method_23760().method_23761();
        return this;
    }

    public FluidBoxRenderer texture(class_4597 vertices, ItemFluids fluids) {
        if (fluids.isEmpty()) {
            this.sprite = null;
            this.buffer = vertices.getBuffer(class_1921.method_23580((class_2960)class_1723.field_21668));
            this.color = -1;
        } else {
            FluidAppearance appearance = FluidAppearance.of(fluids);
            this.sprite = appearance.sprite();
            this.color = appearance.color();
            this.buffer = vertices.getBuffer(class_1921.method_23580((class_2960)appearance.texture()));
        }
        return this;
    }

    public FluidBoxRenderer texture(class_4597 vertices, class_1799 stack) {
        this.sprite = class_310.method_1551().method_1480().method_4012().method_3308(stack).method_4711();
        this.buffer = vertices.getBuffer(class_1921.method_23580((class_2960)class_1723.field_21668));
        this.color = -1;
        return this;
    }

    public FluidBoxRenderer draw(class_265 shape) {
        for (class_238 box : shape.method_1090()) {
            this.draw(box, ALL);
        }
        return this;
    }

    public FluidBoxRenderer draw(class_238 box, class_2350 ... directions) {
        return this.draw((float)box.field_1323, (float)box.field_1322, (float)box.field_1321, (float)box.method_17939(), (float)box.method_17940(), (float)box.method_17941(), directions);
    }

    public FluidBoxRenderer draw(float x, float y, float z, float width, float height, float length, class_2350 ... directions) {
        this.renderFluidFace(x, y, z, width, height, length, directions);
        return this;
    }

    private void vertex(float x, float y, float z, float u, float v, class_2350 direction) {
        POSITION_VECTOR.set(x, y, z, 1.0f);
        this.position.transform(POSITION_VECTOR);
        this.buffer.method_23919(FluidBoxRenderer.POSITION_VECTOR.x * this.scale, FluidBoxRenderer.POSITION_VECTOR.y * this.scale, FluidBoxRenderer.POSITION_VECTOR.z * this.scale, class_5253.class_5254.method_57174((int)this.color), u, v, this.overlay, this.light, (float)direction.method_10148(), (float)direction.method_10164(), (float)direction.method_10165());
    }

    private void renderFluidFace(float x, float y, float z, float width, float height, float length, class_2350 ... directions) {
        if (this.sprite == null) {
            return;
        }
        block8: for (class_2350 direction : directions) {
            switch (direction) {
                case field_11033: {
                    this.vertex(x, y, z, this.sprite.method_4594(), this.sprite.method_4593(), direction);
                    this.vertex(x + width, y, z, this.sprite.method_4577(), this.sprite.method_4593(), direction);
                    this.vertex(x + width, y, z + length, this.sprite.method_4577(), this.sprite.method_4575(), direction);
                    this.vertex(x, y, z + length, this.sprite.method_4594(), this.sprite.method_4575(), direction);
                    continue block8;
                }
                case field_11036: {
                    this.vertex(x, y + height, z, this.sprite.method_4594(), this.sprite.method_4593(), direction);
                    this.vertex(x, y + height, z + length, this.sprite.method_4594(), this.sprite.method_4575(), direction);
                    this.vertex(x + width, y + height, z + length, this.sprite.method_4577(), this.sprite.method_4575(), direction);
                    this.vertex(x + width, y + height, z, this.sprite.method_4577(), this.sprite.method_4593(), direction);
                    continue block8;
                }
                case field_11034: {
                    this.vertex(x + width, y, z, this.sprite.method_4594(), this.sprite.method_4593(), direction);
                    this.vertex(x + width, y + height, z, this.sprite.method_4577(), this.sprite.method_4593(), direction);
                    this.vertex(x + width, y + height, z + length, this.sprite.method_4577(), this.sprite.method_4575(), direction);
                    this.vertex(x + width, y, z + length, this.sprite.method_4594(), this.sprite.method_4575(), direction);
                    continue block8;
                }
                case field_11039: {
                    this.vertex(x, y, z, this.sprite.method_4594(), this.sprite.method_4593(), direction);
                    this.vertex(x, y, z + length, this.sprite.method_4577(), this.sprite.method_4593(), direction);
                    this.vertex(x, y + height, z + length, this.sprite.method_4577(), this.sprite.method_4575(), direction);
                    this.vertex(x, y + height, z, this.sprite.method_4594(), this.sprite.method_4575(), direction);
                    continue block8;
                }
                case field_11043: {
                    this.vertex(x, y, z, this.sprite.method_4594(), this.sprite.method_4593(), direction);
                    this.vertex(x, y + height, z, this.sprite.method_4594(), this.sprite.method_4575(), direction);
                    this.vertex(x + width, y + height, z, this.sprite.method_4577(), this.sprite.method_4575(), direction);
                    this.vertex(x + width, y, z, this.sprite.method_4577(), this.sprite.method_4593(), direction);
                    continue block8;
                }
                case field_11035: {
                    this.vertex(x, y, z + length, this.sprite.method_4594(), this.sprite.method_4593(), direction);
                    this.vertex(x + width, y, z + length, this.sprite.method_4577(), this.sprite.method_4593(), direction);
                    this.vertex(x + width, y + height, z + length, this.sprite.method_4577(), this.sprite.method_4575(), direction);
                    this.vertex(x, y + height, z + length, this.sprite.method_4594(), this.sprite.method_4575(), direction);
                }
            }
        }
    }

    public record FluidAppearance(class_2960 texture, class_1058 sprite, int color) {
        public static FluidAppearance of(ItemFluids stack) {
            int color = stack.fluid().getColor(stack);
            class_1058 sprite = class_310.method_1551().method_1554().method_4743().method_3335(class_2246.field_10382.method_9564()).method_4711();
            FluidRenderHandler handler = FluidRenderHandlerRegistry.INSTANCE.get(stack.fluid().getPhysical().getStandingFluid());
            if (handler != null) {
                class_3610 state = stack.fluid().getFluidState(stack);
                color = handler.getFluidColor((class_1920)class_310.method_1551().field_1687, class_310.method_1551().field_1724.method_24515(), state);
                sprite = handler.getFluidSprites((class_1920)class_310.method_1551().field_1687, class_310.method_1551().field_1724.method_24515(), state)[0];
            }
            return new FluidAppearance(sprite.method_45852(), sprite, color);
        }

        public static int getItemColor(ItemFluids stack) {
            FluidRenderHandler handler;
            if (!stack.fluid().isCustomFluid() && (handler = FluidRenderHandlerRegistry.INSTANCE.get(stack.fluid().getPhysical().getStandingFluid())) != null) {
                class_3610 state = stack.fluid().getPhysical().getStandingFluid().method_15785();
                return class_5253.class_5254.method_57174((int)handler.getFluidColor((class_1920)class_310.method_1551().field_1687, class_310.method_1551().field_1724.method_24515(), state));
            }
            return class_5253.class_5254.method_57174((int)stack.fluid().getColor(stack));
        }

        public float[] rgba() {
            return new float[]{MathUtils.r(this.color), MathUtils.g(this.color), MathUtils.b(this.color), 1.0f};
        }
    }
}

