/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import ivorius.psychedelicraft.util.MathUtils;
import java.util.Random;
import net.minecraft.class_1058;
import net.minecraft.class_276;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5253;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class RenderUtil {
    private static final Vector4f POSITION_VECTOR = new Vector4f();
    private static final Vector3f NORMAL_VECTOR = new Vector3f();
    public static final int SCREEN_Z_OFFSET = -90;
    private static final Random RNG = new Random(0L);

    public static Random random(long seed) {
        RNG.setSeed(seed);
        return RNG;
    }

    public static void setColor(int color, boolean hasAlpha) {
        RenderSystem.setShaderColor((float)MathUtils.r(color), (float)MathUtils.g(color), (float)MathUtils.b(color), (float)(hasAlpha ? MathUtils.a(color) : 1.0f));
    }

    private static class_4588 fastVertex(class_4588 buffer, class_4587.class_4665 entry, float x, float y, float z) {
        entry.method_23761().transform(POSITION_VECTOR.set(x, y, z, 1.0f));
        return buffer.method_22912(RenderUtil.POSITION_VECTOR.x, RenderUtil.POSITION_VECTOR.y, RenderUtil.POSITION_VECTOR.z);
    }

    public static void vertex(class_4588 buffer, class_4587 matrices, float x, float y, float z, float u, float v, int light, int overlay) {
        matrices.method_23760().method_23761().transform(POSITION_VECTOR.set(x, y, z, 1.0f));
        matrices.method_23760().method_23762().transform(NORMAL_VECTOR.set(0.0f, 1.0f, 0.0f));
        buffer.method_23919(RenderUtil.POSITION_VECTOR.x, RenderUtil.POSITION_VECTOR.y, RenderUtil.POSITION_VECTOR.z, -1, u, v, light, overlay, RenderUtil.NORMAL_VECTOR.x, RenderUtil.NORMAL_VECTOR.y, RenderUtil.NORMAL_VECTOR.z);
    }

    public static void drawQuad(class_332 context, class_2960 texture, float x0, float y0, float x1, float y1) {
        RenderUtil.drawQuad(context, texture, x0, y0, x1, y1, 0.0f);
    }

    public static void drawQuad(class_332 context, class_2960 texture, float x0, float y0, float x1, float y1, float z) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        RenderSystem.enableBlend();
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        class_4587.class_4665 entry = context.method_51448().method_23760();
        RenderUtil.fastVertex((class_4588)buffer, entry, x0, y1, z).method_22913(0.0f, 1.0f);
        RenderUtil.fastVertex((class_4588)buffer, entry, x1, y1, z).method_22913(1.0f, 1.0f);
        RenderUtil.fastVertex((class_4588)buffer, entry, x1, y0, z).method_22913(1.0f, 0.0f);
        RenderUtil.fastVertex((class_4588)buffer, entry, x0, y0, z).method_22913(0.0f, 0.0f);
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.disableBlend();
    }

    public static void drawOverlay(class_332 context, class_2960 texture, float alpha, int width, int height, float u0, float v0, float u1, float v1, int offset) {
        if (alpha <= 0.0f) {
            return;
        }
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        RenderSystem.enableBlend();
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        class_4587.class_4665 entry = context.method_51448().method_23760();
        RenderUtil.fastVertex((class_4588)buffer, entry, -offset, height + offset, -90.0f).method_22913(u0, v1);
        RenderUtil.fastVertex((class_4588)buffer, entry, width + offset, height + offset, -90.0f).method_22913(u1, v1);
        RenderUtil.fastVertex((class_4588)buffer, entry, width + offset, -offset, -90.0f).method_22913(u1, v0);
        RenderUtil.fastVertex((class_4588)buffer, entry, -offset, -offset, -90.0f).method_22913(u0, v0);
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    public static void drawOverlay(class_332 context, class_2960 texture, int color, int width, int height, float u0, float v0, float u1, float v1, int offset) {
        int alpha = class_5253.class_5254.method_27762((int)color);
        if (alpha <= 0) {
            return;
        }
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)((float)class_5253.class_5254.method_27765((int)color) / 255.0f), (float)((float)class_5253.class_5254.method_27766((int)color) / 255.0f), (float)((float)class_5253.class_5254.method_27767((int)color) / 255.0f), (float)((float)alpha / 255.0f));
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        RenderSystem.enableBlend();
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        class_4587.class_4665 entry = context.method_51448().method_23760();
        RenderUtil.fastVertex((class_4588)buffer, entry, -offset, height + offset, -90.0f).method_22913(u0, v1).method_39415(color);
        RenderUtil.fastVertex((class_4588)buffer, entry, width + offset, height + offset, -90.0f).method_22913(u1, v1).method_39415(color);
        RenderUtil.fastVertex((class_4588)buffer, entry, width + offset, -offset, -90.0f).method_22913(u1, v0).method_39415(color);
        RenderUtil.fastVertex((class_4588)buffer, entry, -offset, -offset, -90.0f).method_22913(u0, v0).method_39415(color);
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    public static void drawBuffer(class_276 frame, float r, float g, float b, float a) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (int)frame.method_30277());
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        buffer.method_22912(0.0f, 0.0f, 0.0f).method_22913(0.0f, 1.0f).method_22912(0.0f, (float)frame.field_1477, 0.0f).method_22913(0.0f, 0.0f).method_22912((float)frame.field_1480, (float)frame.field_1477, 0.0f).method_22913(1.0f, 0.0f).method_22912((float)frame.field_1480, 0.0f, 0.0f).method_22913(1.0f, 1.0f);
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawRepeatingSprite(class_332 context, class_1058 sprite, int x, int y, int width, int height, float r, float g, float b, float a) {
        int tileSize = 16;
        int tilesX = width / 16;
        int tilesY = height / 16;
        int remainedWidth = width % 16;
        int remainedHeight = height % 16;
        for (int tileX = 0; tileX <= tilesX; ++tileX) {
            for (int tileY = 0; tileY <= tilesY; ++tileY) {
                int h;
                int w = tileX == tilesX ? remainedWidth : 16;
                int n = h = tileY == tilesY ? remainedHeight : 16;
                if (h <= 0 || w <= 0) continue;
                context.method_48465(x + tileX * 16, y + tileY * 16, 0, w, h, sprite, r, g, b, a);
            }
        }
    }
}

