/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.render.blocks;

import com.mojang.blaze3d.systems.RenderSystem;
import ivorius.psychedelicraft.Psychedelicraft;
import ivorius.psychedelicraft.block.PSBlocks;
import ivorius.psychedelicraft.block.entity.PSBlockEntities;
import ivorius.psychedelicraft.block.entity.RiftJarBlockEntity;
import ivorius.psychedelicraft.client.render.ZeroScreen;
import ivorius.psychedelicraft.client.render.bezier.Bezier;
import ivorius.psychedelicraft.client.render.bezier.BezierLabelRenderer;
import ivorius.psychedelicraft.client.render.blocks.RiftJarModel;
import ivorius.psychedelicraft.item.component.RiftFractionComponent;
import ivorius.psychedelicraft.util.MathUtils;
import java.util.Random;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import org.joml.Vector3d;

public class RiftJarBlockEntityRenderer
implements class_827<RiftJarBlockEntity> {
    public static final class_2960 TEXTURE = Psychedelicraft.id("textures/entity/rift_jar/rift_jar.png");
    public static final class_2960 CRACKED_TEXTURE = Psychedelicraft.id("textures/entity/rift_jar/rift_jar_cracked.png");
    private static final class_2960 FONT = class_2960.method_60656((String)"alt");
    private static final Bezier SPHERE_BEZIER_PATH = Bezier.sphere(3.0, 8.0, 0.2);
    private static final Bezier OUTGOING_PATH = Bezier.spiral(0.06, 6.0, 6.0, 1.0, 0.2, 0.0);
    private static final BezierLabelRenderer.Style LABEL_STYLE = new BezierLabelRenderer.Style().spread(true);
    private static final class_2561 SMALL_SPIRAL_TEXT = class_2561.method_43470((String)"This is a small spiral.").method_27694(s -> s.method_27704(FONT));
    private final RiftJarModel model = new RiftJarModel(RiftJarModel.getTexturedModelData().method_32109());
    private static final RiftJarBlockEntity ITEM_ENTITY = (RiftJarBlockEntity)PSBlockEntities.RIFT_JAR.method_11032(class_2338.field_10980, PSBlocks.RIFT_JAR.method_9564());

    public static void renderStack(class_1799 stack, class_811 mode, class_4587 matrices, class_4597 vertices, int light, int overlay) {
        RiftJarBlockEntityRenderer.ITEM_ENTITY.currentRiftFraction = RiftFractionComponent.getRiftFraction(stack);
        RiftJarBlockEntityRenderer.ITEM_ENTITY.ticksAliveVisual = (int)(System.currentTimeMillis() % 500L / 100L);
        class_310.method_1551().method_31975().method_23077((class_2586)ITEM_ENTITY, matrices, vertices, light, overlay);
    }

    public RiftJarBlockEntityRenderer(class_5614.class_5615 context) {
    }

    public void render(RiftJarBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertices, int light, int overlay) {
        float crackedVisibility;
        float ticks = (float)entity.ticksAliveVisual + tickDelta;
        matrices.method_22903();
        matrices.method_46416(0.5f, 0.5f, 0.5f);
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40716.rotationDegrees(90.0f - ((class_2350)entity.method_11010().method_11654((class_2769)class_2383.field_11177)).method_10144()));
        this.model.setAngles(entity, tickDelta);
        matrices.method_46416(0.0f, 1.001f, 0.0f);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        this.model.method_2828(matrices, vertices.getBuffer(class_1921.method_23580((class_2960)TEXTURE)), light, overlay, -1);
        float f = crackedVisibility = entity.jarBroken ? 1.0f : Math.min((entity.currentRiftFraction - 0.5f) * 2.0f, 1.0f);
        if (crackedVisibility > 0.0f) {
            this.model.method_2828(matrices, vertices.getBuffer(this.model.method_23500(CRACKED_TEXTURE)), light, overlay, MathUtils.withAlpha(-1, crackedVisibility));
        }
        if (entity.currentRiftFraction > 0.0f) {
            matrices.method_22903();
            matrices.method_46416(0.0f, 1.5f, 0.0f);
            matrices.method_22907(class_7833.field_40713.rotationDegrees(180.0f));
            matrices.method_22905(0.9f, 1.0f, 0.9f);
            ZeroScreen.render(ticks, (layer, u, v) -> this.model.renderInterior(matrices, vertices.getBuffer(layer), 0, 0, MathUtils.withAlpha(-1, Math.min(entity.currentRiftFraction * 2.0f, 1.0f))));
            matrices.method_22909();
        }
        matrices.method_22909();
        matrices.method_22909();
        matrices.method_22903();
        matrices.method_46416(0.5f, 0.5f, 0.5f);
        RenderSystem.disableCull();
        class_243 jarPosition = entity.method_11016().method_46558();
        for (RiftJarBlockEntity.JarRiftConnection connection : entity.getConnections()) {
            Vector3d connectionPoint = new Vector3d(connection.position.field_1352 - jarPosition.field_1352, connection.position.field_1351 - (jarPosition.field_1351 + (double)0.1f), connection.position.field_1350 - jarPosition.field_1350);
            if (connection.bezier == null) {
                connection.bezier = Bezier.spiral(0.1, 0.5, 8.0, connectionPoint, 0.2, 0.0);
            }
            BezierLabelRenderer.INSTANCE.render(matrices, vertices, light, connection.bezier, LABEL_STYLE.shift(ticks * -0.002f).topCap(connection.fractionUp), SMALL_SPIRAL_TEXT);
            if (!(connection.fractionUp > 0.0f)) continue;
            matrices.method_22903();
            matrices.method_22904(connectionPoint.x, connectionPoint.y, connectionPoint.z);
            BezierLabelRenderer.INSTANCE.render(matrices, vertices, light, SPHERE_BEZIER_PATH, LABEL_STYLE.shift(ticks * -0.002f).topCap(1.0f), (class_2561)class_2561.method_43470((String)RiftJarBlockEntityRenderer.cheeseString("This is a small circle.", 1.0f - connection.fractionUp, new Random(42L))).method_27694(s -> s.method_27704(FONT)));
            matrices.method_22909();
        }
        float outgoingStrength = entity.fractionHandleUp * entity.fractionOpen;
        if (outgoingStrength > 0.0f) {
            BezierLabelRenderer.INSTANCE.render(matrices, vertices, light, OUTGOING_PATH, LABEL_STYLE.shift(ticks * -0.002f).topCap(outgoingStrength), SMALL_SPIRAL_TEXT);
        }
        RenderSystem.enableCull();
        matrices.method_22909();
    }

    public static String cheeseString(String string, float effect, Random rand) {
        if (effect <= 0.0f) {
            return string;
        }
        StringBuilder builder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            if (rand.nextFloat() <= effect) {
                builder.append(' ');
                continue;
            }
            builder.append(string.charAt(i));
        }
        return builder.toString();
    }
}

