/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.render.shader;

import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.floats.FloatConsumer;
import ivorius.psychedelicraft.client.render.shader.ModdedResourceManager;
import ivorius.psychedelicraft.client.render.shader.UniformBinding;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_276;
import net.minecraft.class_279;
import net.minecraft.class_280;
import net.minecraft.class_283;
import net.minecraft.class_284;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5912;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

class LoadedShader
extends class_279 {
    private final UniformBinding.Set bindings;
    private int width;
    private int height;
    private float time;
    private float lastTickDelta;
    private List<Pass> passes;

    public LoadedShader(class_310 client, class_2960 id, UniformBinding.Set bindings) throws IOException, JsonSyntaxException {
        super(client.method_1531(), (class_5912)new ModdedResourceManager(client.method_1478(), id.method_12836()), client.method_1522(), id);
        this.bindings = bindings;
        if (this.passes == null) {
            this.passes = new ArrayList<Pass>();
        }
        this.method_1259(client.method_22683().method_4489(), client.method_22683().method_4506());
    }

    public void method_1258(float tickDelta) {
        if (tickDelta < this.lastTickDelta) {
            this.time += 1.0f - this.lastTickDelta;
            this.time += tickDelta;
        } else {
            this.time += tickDelta - this.lastTickDelta;
        }
        this.lastTickDelta = tickDelta;
        while (this.time > 20.0f) {
            this.time -= 20.0f;
        }
        boolean rendered = false;
        float passRenderFrame = this.time / 20.0f;
        for (Pass pass : this.passes) {
            rendered |= pass.render(passRenderFrame, tickDelta, rendered);
        }
    }

    public void method_1259(int targetsWidth, int targetsHeight) {
        this.width = targetsWidth;
        this.height = targetsHeight;
        super.method_1259(targetsWidth, targetsHeight);
    }

    public class_283 method_1262(String programName, class_276 source, class_276 dest, boolean linear) throws IOException {
        class_283 pass = super.method_1262(programName, source, dest, linear);
        if (this.passes == null) {
            this.passes = new ArrayList<Pass>();
        }
        this.passes.add(new Pass(pass));
        return pass;
    }

    class Pass
    implements UniformBinding.UniformSetter {
        private final class_280 program;
        private final class_283 pass;
        private final List<FloatConsumer> replay = new ArrayList<FloatConsumer>();
        private int updateCount;
        private boolean rendered;

        public Pass(class_283 pass) {
            this.pass = pass;
            this.program = pass.method_1295();
        }

        public boolean render(float passRenderTime, float tickDelta, boolean rendered) {
            if (this.pass.method_35777().equals("blit")) {
                return false;
            }
            if (this.updateCount == 0) {
                this.replay.clear();
                UniformBinding programBindings = LoadedShader.this.bindings.programBindings.getOrDefault(this.pass.method_35777(), UniformBinding.EMPTY);
                LoadedShader.this.bindings.global.bindUniforms(this, tickDelta, LoadedShader.this.width, LoadedShader.this.height, () -> programBindings.bindUniforms(this, tickDelta, LoadedShader.this.width, LoadedShader.this.height, () -> this.replay.add(this::renderPass)));
            }
            this.updateCount = (this.updateCount + 1) % 2;
            this.rendered = false;
            if (this.replay.isEmpty()) {
                return this.rendered;
            }
            try {
                for (FloatConsumer action : this.replay) {
                    action.accept(passRenderTime);
                }
            }
            catch (Throwable t) {
                throw new RuntimeException("Exception rendering shader " + this.pass.method_35777(), t);
            }
            return this.rendered;
        }

        private void renderPass(float passRenderTime) {
            this.pass.method_1293(passRenderTime);
            LoadedShader.this.passes.get((int)(LoadedShader.this.passes.size() - 1)).pass.method_1293(passRenderTime);
            this.rendered = true;
        }

        @Override
        public void set(String name, float value) {
            class_284 uniform = this.program.method_1271(name);
            if (uniform != null) {
                this.replay.add(Pass.uniformSetter(name, f -> uniform.method_1251(value)));
            }
        }

        @Override
        public void set(String name, float ... values) {
            class_284 uniform = this.program.method_1271(name);
            if (uniform != null) {
                float[] copy = Arrays.copyOf(values, values.length);
                this.replay.add(Pass.uniformSetter(name, f -> uniform.method_1253(copy)));
            }
        }

        @Override
        public void set(String name, Vector3fc values) {
            class_284 uniform = this.program.method_1271(name);
            if (uniform != null) {
                Vector3f copy = new Vector3f(values);
                this.replay.add(Pass.uniformSetter(name, f -> uniform.method_34413(copy)));
            }
        }

        @Override
        public void set(String name, Vector4fc values) {
            class_284 uniform = this.program.method_1271(name);
            if (uniform != null) {
                Vector4f copy = new Vector4f(values);
                this.replay.add(Pass.uniformSetter(name, f -> uniform.method_35652(copy)));
            }
        }

        private static FloatConsumer uniformSetter(String name, FloatConsumer consumer) {
            return f -> {
                try {
                    consumer.accept(f);
                }
                catch (Throwable t) {
                    throw new RuntimeException("Exception setting uniform: " + name, t);
                }
            };
        }
    }
}

