/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.compat.tia;

import ivorius.psychedelicraft.fluid.Processable;
import ivorius.psychedelicraft.item.component.ItemFluids;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

public interface FluidStageUtil {
    public static <T> Stream<T> combineSimilarProcesses(Stream<Processable.Process> processes, Function<Processable.Process, T> unit, Function<Set<Processable.Process>, T> reducer) {
        return FluidStageUtil.groupBy(processes.filter(p -> !p.transitions().isEmpty()), i -> i.transitions().size()).flatMap(group -> {
            if (((Set)group.getValue()).size() <= 1) {
                return ((Set)group.getValue()).stream().map(unit);
            }
            return FluidStageUtil.groupBy(((Set)group.getValue()).stream(), p -> p.transitions().stream().map(t -> new TransitionKey((Processable.Process)p, (Processable.Transition)t)).toList()).map(similars -> reducer.apply((Set)similars.getValue()));
        });
    }

    private static <K, T> Stream<Map.Entry<K, Set<T>>> groupBy(Stream<T> stream, Function<T, K> keyMapper) {
        HashMap groups = new HashMap();
        stream.forEach(t -> groups.computeIfAbsent(keyMapper.apply(t), k -> new HashSet()).add(t));
        return groups.entrySet().stream();
    }

    public record TransitionKey(Processable.ProcessType type, int time, int multiplier, ItemFluids result) {
        TransitionKey(Processable.Process process, Processable.Transition transition) {
            this(transition.type(), transition.time(), transition.multiplier(), transition.output().apply(process.fluid().getDefaultStack()));
        }
    }
}

